/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service;

import org.eclipse.dd.dsf.debug.service.AbstractDsfDebugServicesFactory;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IDisassembly;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IModules;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.service.GDBProcesses;
import org.eclipse.dd.gdb.internal.provisional.service.GDBRunControl;
import org.eclipse.dd.mi.service.CSourceLookup;
import org.eclipse.dd.mi.service.ExpressionService;
import org.eclipse.dd.mi.service.MIBreakpoints;
import org.eclipse.dd.mi.service.MIBreakpointsManager;
import org.eclipse.dd.mi.service.MIDisassembly;
import org.eclipse.dd.mi.service.MIMemory;
import org.eclipse.dd.mi.service.MIModules;
import org.eclipse.dd.mi.service.MIRegisters;
import org.eclipse.dd.mi.service.MIStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbDebugServicesFactory
extends AbstractDsfDebugServicesFactory {
    public GdbDebugServicesFactory(String version) {
    }

    public <V> V createService(DsfSession session, Class<V> clazz) {
        if (MIBreakpointsManager.class.isAssignableFrom(clazz)) {
            return (V)this.createBreakpointManagerService(session);
        }
        return (V)super.createService(session, clazz);
    }

    protected IDisassembly createDisassemblyService(DsfSession session) {
        return new MIDisassembly(session);
    }

    protected IRegisters createRegistersService(DsfSession session) {
        return new MIRegisters(session);
    }

    protected IBreakpoints createBreakpointService(DsfSession session) {
        return new MIBreakpoints(session);
    }

    protected ISourceLookup createSourceLookupService(DsfSession session) {
        return new CSourceLookup(session);
    }

    protected IExpressions createExpressionService(DsfSession session) {
        return new ExpressionService(session);
    }

    protected IStack createStackService(DsfSession session) {
        return new MIStack(session);
    }

    protected IModules createModulesService(DsfSession session) {
        return new MIModules(session);
    }

    protected IMemory createMemoryService(DsfSession session) {
        return new MIMemory(session);
    }

    protected IRunControl createRunControlService(DsfSession session) {
        return new GDBRunControl(session);
    }

    protected IProcesses createProcessesService(DsfSession session) {
        return new GDBProcesses(session);
    }

    protected MIBreakpointsManager createBreakpointManagerService(DsfSession session) {
        return new MIBreakpointsManager(session, "org.eclipse.cdt.debug.core");
    }
}

