/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.ICachingService;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.CommandCache;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.IMIExecutionGroupDMContext;
import org.eclipse.dd.mi.service.IMIProcessDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.MIControlDMContext;
import org.eclipse.dd.mi.service.command.commands.CLIAttach;
import org.eclipse.dd.mi.service.command.commands.CLIDetach;
import org.eclipse.dd.mi.service.command.commands.CLIInfoThreads;
import org.eclipse.dd.mi.service.command.commands.MIThreadListIds;
import org.eclipse.dd.mi.service.command.output.CLIInfoThreadsInfo;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIThreadListIdsInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIProcesses
extends AbstractDsfService
implements IMIProcesses,
ICachingService {
    private AbstractMIControl fCommandControl;
    private CommandCache fContainerCommandCache;
    private static final String FAKE_THREAD_ID = "0";
    private static final String UNIQUE_GROUP_ID = "";

    public MIProcesses(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                MIProcesses.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fCommandControl = (AbstractMIControl)((Object)this.getServicesTracker().getService(AbstractMIControl.class));
        this.fContainerCommandCache = new CommandCache(this.getSession(), (ICommandControl)this.fCommandControl);
        this.fContainerCommandCache.setContextAvailable((IDMContext)this.fCommandControl.getControlDMContext(), true);
        this.getSession().addServiceEventListener((Object)this, null);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return MIPlugin.getBundleContext();
    }

    @Override
    public IProcesses.IThreadDMContext createThreadContext(IProcesses.IProcessDMContext processDmc, String threadId) {
        return new MIThreadDMC(this.getSession().getId(), processDmc, threadId);
    }

    @Override
    public IProcesses.IProcessDMContext createProcessContext(MIControlDMContext controlDmc, String pid) {
        return new MIProcessDMC(this.getSession().getId(), controlDmc, pid);
    }

    @Override
    public IMIExecutionDMContext createExecutionContext(IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
        return new MIExecutionDMC(this.getSession().getId(), containerDmc, threadDmc, threadId);
    }

    @Override
    public IMIExecutionGroupDMContext createExecutionGroupContext(IProcesses.IProcessDMContext processDmc, String groupId) {
        return new MIExecutionGroupDMC(this.getSession().getId(), processDmc, groupId);
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof IProcesses.IThreadDMContext) {
            this.getExecutionData((IProcesses.IThreadDMContext)dmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid DMC type", null));
            rm.done();
        }
    }

    public void getExecutionData(IProcesses.IThreadDMContext dmc, final DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        if (dmc instanceof MIProcessDMC) {
            rm.setData((Object)new MIThreadDMData(UNIQUE_GROUP_ID, ((MIProcessDMC)dmc).getProcId()));
            rm.done();
        } else if (dmc instanceof MIThreadDMC) {
            final MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IProcesses.IProcessDMContext.class);
            this.getDebuggingContext((IProcesses.IThreadDMContext)procDmc, new DataRequestMonitor<IDMContext>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    if (this.getData() instanceof IMIExecutionGroupDMContext) {
                        IMIExecutionGroupDMContext contDmc = (IMIExecutionGroupDMContext)this.getData();
                        MIProcesses.this.fContainerCommandCache.execute((ICommand)new CLIInfoThreads(contDmc), (DataRequestMonitor)new DataRequestMonitor<CLIInfoThreadsInfo>((Executor)MIProcesses.this.getExecutor(), (RequestMonitor)rm){

                            protected void handleSuccess() {
                                MIThreadDMData threadData = new MIThreadDMData(MIProcesses.UNIQUE_GROUP_ID, MIProcesses.UNIQUE_GROUP_ID);
                                for (CLIInfoThreadsInfo.ThreadInfo thread : ((CLIInfoThreadsInfo)this.getData()).getThreadInfo()) {
                                    if (!thread.getId().equals(threadDmc.getId())) continue;
                                    threadData = new MIThreadDMData(thread.getName(), thread.getOsId());
                                    break;
                                }
                                rm.setData((Object)threadData);
                                rm.done();
                            }
                        });
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid DMC type", null));
                        rm.done();
                    }
                }
            });
        }
    }

    public void getDebuggingContext(IProcesses.IThreadDMContext dmc, DataRequestMonitor<IDMContext> rm) {
        if (dmc instanceof MIProcessDMC) {
            MIProcessDMC procDmc = (MIProcessDMC)dmc;
            rm.setData((Object)this.createExecutionGroupContext(procDmc, procDmc.getProcId()));
        } else if (dmc instanceof MIThreadDMC) {
            MIThreadDMC threadDmc = (MIThreadDMC)dmc;
            IMIProcessDMContext procDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIProcessDMContext.class);
            IMIExecutionGroupDMContext groupDmc = this.createExecutionGroupContext(procDmc, procDmc.getProcId());
            rm.setData((Object)this.createExecutionContext(groupDmc, threadDmc, threadDmc.getId()));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Invalid thread context.", null));
        }
        rm.done();
    }

    public void isDebuggerAttachSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void attachDebuggerToProcess(final IProcesses.IProcessDMContext procCtx, final DataRequestMonitor<IDMContext> rm) {
        if (procCtx instanceof IMIProcessDMContext) {
            MIControlDMContext controlDmc = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)procCtx, MIControlDMContext.class);
            this.fCommandControl.queueCommand(new CLIAttach(controlDmc, ((IMIProcessDMContext)procCtx).getProcId()), new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    IMIExecutionGroupDMContext groupDmc = MIProcesses.this.createExecutionGroupContext(procCtx, ((IMIProcessDMContext)procCtx).getProcId());
                    MIProcesses.this.getSession().dispatchEvent((Object)new ExecutionGroupStartedDMEvent(groupDmc), MIProcesses.this.getProperties());
                    rm.setData((Object)groupDmc);
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Invalid process context.", null));
            rm.done();
        }
    }

    public void canDetachDebuggerFromProcess(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void detachDebuggerFromProcess(final IDMContext dmc, final RequestMonitor rm) {
        MIControlDMContext controlDmc = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
        if (controlDmc != null) {
            this.fCommandControl.queueCommand(new CLIDetach((IDMContext)controlDmc), new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
                    if (containerDmc != null) {
                        MIProcesses.this.getSession().dispatchEvent((Object)new ExecutionGroupExitedDMEvent(containerDmc), MIProcesses.this.getProperties());
                    }
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Invalid context.", null));
            rm.done();
        }
    }

    public void canTerminate(IProcesses.IThreadDMContext thread, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void isDebugNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void debugNewProcess(String file, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Not supported", null));
        rm.done();
    }

    public void getProcessesBeingDebugged(IDMContext dmc, final DataRequestMonitor<IDMContext[]> rm) {
        final IMIExecutionGroupDMContext groupDmc = (IMIExecutionGroupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIExecutionGroupDMContext.class);
        if (groupDmc != null) {
            this.fContainerCommandCache.execute((ICommand)new MIThreadListIds(groupDmc), (DataRequestMonitor)new DataRequestMonitor<MIThreadListIdsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.setData((Object)MIProcesses.this.makeExecutionDMCs(groupDmc, (MIThreadListIdsInfo)this.getData()));
                    rm.done();
                }
            });
        } else {
            MIControlDMContext controlDmc = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class);
            IProcesses.IProcessDMContext procDmc = this.createProcessContext(controlDmc, UNIQUE_GROUP_ID);
            IMIExecutionGroupDMContext newGroupDmc = this.createExecutionGroupContext(procDmc, UNIQUE_GROUP_ID);
            rm.setData((Object)new IRunControl.IContainerDMContext[]{newGroupDmc});
            rm.done();
        }
    }

    private IRunControl.IExecutionDMContext[] makeExecutionDMCs(IRunControl.IContainerDMContext containerDmc, MIThreadListIdsInfo info) {
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IProcesses.IProcessDMContext.class);
        if (info.getStrThreadIds().length == 0) {
            return new IMIExecutionDMContext[]{this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, FAKE_THREAD_ID), FAKE_THREAD_ID)};
        }
        IRunControl.IExecutionDMContext[] executionDmcs = new IMIExecutionDMContext[info.getStrThreadIds().length];
        for (int i = 0; i < info.getStrThreadIds().length; ++i) {
            String threadId = info.getStrThreadIds()[i];
            executionDmcs[i] = this.createExecutionContext(containerDmc, this.createThreadContext(procDmc, threadId), threadId);
        }
        return executionDmcs;
    }

    public void getRunningProcesses(IDMContext dmc, DataRequestMonitor<IProcesses.IProcessDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Not supported", null));
        rm.done();
    }

    public void isRunNewProcessSupported(IDMContext dmc, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)false);
        rm.done();
    }

    public void runNewProcess(String file, DataRequestMonitor<IProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Not supported", null));
        rm.done();
    }

    public void terminate(IProcesses.IThreadDMContext thread, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Not supported", null));
        rm.done();
    }

    @Override
    public String getExecutionGroupIdFromThread(String threadId) {
        return UNIQUE_GROUP_ID;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fContainerCommandCache.setContextAvailable(e.getDMContext(), false);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.fContainerCommandCache.setContextAvailable(e.getDMContext(), true);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IStartedDMEvent e) {
        this.fContainerCommandCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        this.fContainerCommandCache.reset();
    }

    public void flushCache(IDMContext context) {
        this.fContainerCommandCache.reset(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecutionGroupExitedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IExitedDMEvent {
        public ExecutionGroupExitedDMEvent(IRunControl.IContainerDMContext context) {
            super((IDMContext)context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExecutionGroupStartedDMEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext>
    implements IRunControl.IStartedDMEvent {
        public ExecutionGroupStartedDMEvent(IMIExecutionGroupDMContext context) {
            super((IDMContext)context);
        }
    }

    @Immutable
    private static class MIExecutionDMC
    extends AbstractDMContext
    implements IMIExecutionDMContext {
        private final String fThreadId;

        protected MIExecutionDMC(String sessionId, IRunControl.IContainerDMContext containerDmc, IProcesses.IThreadDMContext threadDmc, String threadId) {
            IDMContext[] iDMContextArray;
            if (containerDmc == null && threadDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else if (containerDmc == null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = threadDmc;
            } else if (threadDmc == null) {
                IDMContext[] iDMContextArray3 = new IDMContext[1];
                iDMContextArray = iDMContextArray3;
                iDMContextArray3[0] = containerDmc;
            } else {
                IDMContext[] iDMContextArray4 = new IDMContext[2];
                iDMContextArray4[0] = containerDmc;
                iDMContextArray = iDMContextArray4;
                iDMContextArray4[1] = threadDmc;
            }
            super(sessionId, iDMContextArray);
            this.fThreadId = threadId;
        }

        public int getThreadId() {
            try {
                return Integer.parseInt(this.fThreadId);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public String getId() {
            return this.fThreadId;
        }

        public String toString() {
            return this.baseToString() + ".thread[" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && ((MIExecutionDMC)obj).fThreadId.equals(this.fThreadId);
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fThreadId.hashCode();
        }
    }

    @Immutable
    private static class MIExecutionGroupDMC
    extends AbstractDMContext
    implements IMIExecutionGroupDMContext {
        private final String fId;

        public MIExecutionGroupDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String groupId) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = groupId;
        }

        public String getGroupId() {
            return this.fId;
        }

        public String toString() {
            return this.baseToString() + ".threadGroup[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && (((MIExecutionGroupDMC)obj).fId == null ? this.fId == null : ((MIExecutionGroupDMC)obj).fId.equals(this.fId));
        }

        public int hashCode() {
            return super.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    private static class MIProcessDMC
    extends AbstractDMContext
    implements IMIProcessDMContext {
        private final String fId;

        public MIProcessDMC(String sessionId, MIControlDMContext controlDmc, String id) {
            IDMContext[] iDMContextArray;
            if (controlDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = controlDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        public String getProcId() {
            return this.fId;
        }

        public String toString() {
            return this.baseToString() + ".proc[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && (((MIProcessDMC)obj).fId == null ? this.fId == null : ((MIProcessDMC)obj).fId.equals(this.fId));
        }

        public int hashCode() {
            return super.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    private static class MIThreadDMC
    extends AbstractDMContext
    implements IProcesses.IThreadDMContext {
        private final String fId;

        public MIThreadDMC(String sessionId, IProcesses.IProcessDMContext processDmc, String id) {
            IDMContext[] iDMContextArray;
            if (processDmc == null) {
                iDMContextArray = new IDMContext[]{};
            } else {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = processDmc;
            }
            super(sessionId, iDMContextArray);
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String toString() {
            return this.baseToString() + ".OSthread[" + this.fId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && (((MIThreadDMC)((Object)obj)).fId == null ? this.fId == null : ((MIThreadDMC)((Object)obj)).fId.equals(this.fId));
        }

        public int hashCode() {
            return super.baseHashCode() ^ (this.fId == null ? 0 : this.fId.hashCode());
        }
    }

    @Immutable
    protected static class MIThreadDMData
    implements IProcesses.IThreadDMData {
        final String fName;
        final String fId;

        public MIThreadDMData(String name, String id) {
            this.fName = name;
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }
}

