/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dd.mi.service.command.output.IThreadInfo;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;
import org.eclipse.dd.mi.service.command.output.ThreadFrame;
import org.eclipse.dd.mi.service.command.output.ThreadInfo;

public class MIThreadInfoInfo
extends MIInfo {
    private String fCurrentThread = null;
    private IThreadInfo[] fThreadList = null;

    public MIThreadInfoInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public String getCurrentThread() {
        return this.fCurrentThread;
    }

    public IThreadInfo[] getThreadList() {
        return this.fThreadList;
    }

    private void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("threads")) {
                    MIValue val = results[i].getMIValue();
                    if (!(val instanceof MIList)) continue;
                    this.parseThreads((MIList)val);
                    continue;
                }
                if (!var.equals("current-thread-id") || !((value = results[i].getMIValue()) instanceof MIConst)) continue;
                this.fCurrentThread = ((MIConst)value).getCString().trim();
            }
        }
        if (this.fThreadList == null) {
            this.fThreadList = new IThreadInfo[0];
        }
    }

    private void parseThreads(MIList list) {
        MIValue[] values = list.getMIValues();
        this.fThreadList = new IThreadInfo[values.length];
        for (int i = 0; i < values.length; ++i) {
            MITuple value = (MITuple)values[i];
            MIResult[] results = value.getMIResults();
            String threadId = null;
            String targetId = null;
            String osId = null;
            String parentId = null;
            ThreadFrame topFrame = null;
            String state = null;
            String details = null;
            for (int j = 0; j < results.length; ++j) {
                MIValue val;
                MIResult result = results[j];
                String var = result.getVariable();
                if (var.equals("id")) {
                    val = results[j].getMIValue();
                    if (!(val instanceof MIConst)) continue;
                    threadId = ((MIConst)val).getCString().trim();
                    continue;
                }
                if (var.equals("target-id")) {
                    val = results[j].getMIValue();
                    if (!(val instanceof MIConst)) continue;
                    targetId = ((MIConst)val).getCString().trim();
                    osId = this.parseOsId(targetId);
                    parentId = this.parseParentId(targetId);
                    continue;
                }
                if (var.equals("frame")) {
                    val = results[j].getMIValue();
                    topFrame = this.parseFrame(val);
                    continue;
                }
                if (var.equals("state")) {
                    val = results[j].getMIValue();
                    if (!(val instanceof MIConst)) continue;
                    state = ((MIConst)val).getCString().trim();
                    continue;
                }
                if (!var.equals("details") || !((val = results[j].getMIValue()) instanceof MIConst)) continue;
                details = ((MIConst)val).getCString().trim();
            }
            this.fThreadList[i] = new ThreadInfo(threadId, targetId, osId, parentId, topFrame, details, state);
        }
    }

    private String parseOsId(String str) {
        Pattern pattern = Pattern.compile("(Thread\\s*)(0x[0-9a-fA-F]+|-?\\d+)(\\s*\\(LWP\\s*)(\\d*)", 0);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            return matcher.group(4);
        }
        pattern = Pattern.compile("Thread\\s*\\d+\\.(\\d+)", 0);
        matcher = pattern.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String parseParentId(String str) {
        Pattern pattern = Pattern.compile("Thread\\s*(\\d+)\\.\\d+", 0);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private ThreadFrame parseFrame(MIValue val) {
        return null;
    }
}

