/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.ui.memory.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.debug.ui.memory.transport.ImportMemoryDialog;
import org.eclipse.dd.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.dd.debug.ui.memory.transport.model.IMemoryImporter;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SRecordImporter
implements IMemoryImporter {
    File fInputFile;
    BigInteger fStartAddress;
    boolean fUseCustomAddress;
    Boolean fScrollToStart;
    private Text fStartText;
    private Text fFileText;
    private Button fComboRestoreToThisAddress;
    private Button fComboRestoreToFileAddress;
    private Button fScrollToBeginningOnImportComplete;
    private IMemoryBlock fMemoryBlock;
    private ImportMemoryDialog fParentDialog;
    private Properties fProperties;

    public Control createControl(final Composite parent, IMemoryBlock memBlock, Properties properties, ImportMemoryDialog parentDialog) {
        this.fMemoryBlock = memBlock;
        this.fParentDialog = parentDialog;
        this.fProperties = properties;
        Composite composite = new Composite(parent, 0){

            public void dispose() {
                SRecordImporter.this.fProperties.setProperty("File", SRecordImporter.this.fFileText.getText());
                SRecordImporter.this.fProperties.setProperty("Start", SRecordImporter.this.fStartText.getText());
                SRecordImporter.this.fProperties.setProperty("ScrollToStart", SRecordImporter.this.fScrollToStart.toString());
                SRecordImporter.this.fStartAddress = SRecordImporter.this.getStartAddress();
                SRecordImporter.this.fInputFile = SRecordImporter.this.getFile();
                super.dispose();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        this.fComboRestoreToFileAddress = new Button(composite, 16);
        this.fComboRestoreToFileAddress.setSelection(true);
        this.fComboRestoreToFileAddress.setText("Restore to address specified in the file");
        this.fComboRestoreToThisAddress = new Button(composite, 16);
        this.fComboRestoreToThisAddress.setText("Restore to this address: ");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fComboRestoreToFileAddress);
        this.fComboRestoreToThisAddress.setLayoutData((Object)data);
        this.fStartText = new Text(composite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fComboRestoreToFileAddress);
        data.left = new FormAttachment((Control)this.fComboRestoreToThisAddress);
        data.width = 100;
        this.fStartText.setLayoutData((Object)data);
        Label fileLabel = new Label(composite, 0);
        this.fFileText = new Text(composite, 0);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText("File name: ");
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fFileText.setLayoutData((Object)data);
        fileButton.setText("Browse...");
        data = new FormData();
        data.top = new FormAttachment((Control)this.fStartText);
        data.left = new FormAttachment((Control)this.fFileText);
        fileButton.setLayoutData((Object)data);
        this.fFileText.setText(properties.getProperty("File", ""));
        this.fScrollToStart = new Boolean(properties.getProperty("ScrollToStart", "true"));
        try {
            BigInteger startAddress = null;
            startAddress = this.fMemoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() : BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
            if (properties.getProperty("Start") != null) {
                this.fStartText.setText(properties.getProperty("Start"));
            } else {
                this.fStartText.setText("0x" + startAddress.toString(16));
            }
        }
        catch (Exception e) {
            DebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure", (Throwable)e));
        }
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 8192);
                dialog.setText("Choose memory export file");
                dialog.setFilterExtensions(new String[]{"*.*;*"});
                dialog.setFilterNames(new String[]{"All Files"});
                dialog.setFileName(SRecordImporter.this.fFileText.getText());
                dialog.open();
                if (dialog.getFileName() != null) {
                    SRecordImporter.this.fFileText.setText(dialog.getFilterPath() + File.separator + dialog.getFileName());
                }
                SRecordImporter.this.validate();
            }
        });
        this.fStartText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                try {
                    SRecordImporter.this.getStartAddress();
                }
                catch (Exception ex) {
                    valid = false;
                }
                SRecordImporter.this.fStartText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                SRecordImporter.this.validate();
            }
        });
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SRecordImporter.this.validate();
            }
        });
        this.fScrollToBeginningOnImportComplete = new Button(composite, 32);
        this.fScrollToBeginningOnImportComplete.setText("Scroll to File Start Address");
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton);
        this.fScrollToBeginningOnImportComplete.setLayoutData((Object)data);
        composite.pack();
        parent.pack();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SRecordImporter.this.validate();
            }
        });
        return composite;
    }

    private void validate() {
        boolean isValid = true;
        try {
            this.getStartAddress();
            if (!this.getFile().exists()) {
                isValid = false;
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        this.fParentDialog.setValid(isValid);
    }

    public boolean getScrollToStart() {
        return this.fScrollToBeginningOnImportComplete.getSelection();
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    public File getFile() {
        return new File(this.fFileText.getText());
    }

    public String getId() {
        return "snfimporter";
    }

    public String getName() {
        return "SRecord";
    }

    public void importMemory() {
        Job job = new Job("Memory Download from S-Record File"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean CHECKSUM_LENGTH = true;
                        BigInteger scrollToAddress = null;
                        BigInteger offset = null;
                        if (!SRecordImporter.this.fUseCustomAddress) {
                            offset = BigInteger.ZERO;
                        }
                        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(SRecordImporter.this.fInputFile)));
                        BigInteger jobs = BigInteger.valueOf(SRecordImporter.this.fInputFile.length());
                        BigInteger factor = BigInteger.ONE;
                        if (jobs.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                            factor = jobs.divide(BigInteger.valueOf(Integer.MAX_VALUE));
                            jobs = jobs.divide(factor);
                        }
                        monitor.beginTask("Transferring Data", jobs.intValue());
                        BigInteger jobCount = BigInteger.ZERO;
                        String line = reader.readLine();
                        while (line != null && !monitor.isCanceled()) {
                            String recordType = line.substring(0, 2);
                            int recordCount = Integer.parseInt(line.substring(2, 4), 16);
                            int bytesRead = 4 + recordCount;
                            int position = 4;
                            int addressSize = 0;
                            BigInteger recordAddress = null;
                            if ("S3".equals(recordType)) {
                                addressSize = 4;
                            } else if ("S1".equals(recordType)) {
                                addressSize = 2;
                            } else if ("S2".equals(recordType)) {
                                addressSize = 3;
                            }
                            recordAddress = new BigInteger(line.substring(position, position + addressSize * 2), 16);
                            recordCount -= addressSize;
                            position += addressSize * 2;
                            if (offset == null) {
                                offset = SRecordImporter.this.fStartAddress.subtract(recordAddress);
                            }
                            recordAddress = recordAddress.add(offset);
                            byte[] data = new byte[recordCount - 1];
                            for (int i = 0; i < data.length; ++i) {
                                data[i] = new BigInteger(line.substring(position++, position++ + 1), 16).byteValue();
                            }
                            StringBuffer buf = new StringBuffer(line.substring(2));
                            int checksum = 0;
                            for (int i = 0; i < buf.length(); i += 2) {
                                BigInteger value = new BigInteger(buf.substring(i, i + 2), 16);
                                checksum = (byte)(checksum + value.byteValue());
                            }
                            if (checksum != -1) {
                                reader.close();
                                monitor.done();
                                return new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), "Checksum failure of line = " + line);
                            }
                            if (scrollToAddress == null) {
                                scrollToAddress = recordAddress;
                            }
                            ((IMemoryBlockExtension)SRecordImporter.this.fMemoryBlock).setValue(recordAddress.subtract(((IMemoryBlockExtension)SRecordImporter.this.fMemoryBlock).getBigBaseAddress()), data);
                            jobCount = jobCount.add(BigInteger.valueOf(bytesRead));
                            while (jobCount.compareTo(factor) >= 0) {
                                jobCount = jobCount.subtract(factor);
                                monitor.worked(1);
                            }
                            line = reader.readLine();
                        }
                        reader.close();
                        monitor.done();
                        if (SRecordImporter.this.fProperties.getProperty("ScrollToStart", "false").equals("true")) {
                            SRecordImporter.this.fParentDialog.scrollRenderings(scrollToAddress);
                        }
                    }
                    catch (Exception e) {
                        DebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure", (Throwable)e));
                    }
                }
                catch (Exception e) {
                    DebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, MemoryTransportPlugin.getUniqueIdentifier(), 5013, "Failure", (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

