/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.memory.renderings.traditional;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressComposite;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TraditionalGoToAddressRendering
extends AbstractMemoryRendering {
    private IMemoryRenderingSite fSite;
    private IMemoryRenderingContainer fContainer;
    private Control fControl;

    public void init(IMemoryRenderingContainer container, IMemoryBlock block) {
        super.init(container, block);
        this.fSite = container.getMemoryRenderingSite();
        this.fContainer = container;
    }

    public TraditionalGoToAddressRendering(String renderingId) {
        super(renderingId);
    }

    public Control createControl(Composite parent) {
        Control fGotoAddressControl;
        Composite fGotoAddressContainer = parent;
        final GoToAddressComposite fGotoAddress = new GoToAddressComposite();
        this.fControl = fGotoAddressControl = fGotoAddress.createControl(fGotoAddressContainer);
        final Runnable goHandler = new Runnable(){

            public void run() {
                String expression = fGotoAddress.getExpressionText();
                int radix = 10;
                if (expression.toUpperCase().startsWith("0X")) {
                    expression = expression.substring(2);
                    radix = 16;
                } else if (fGotoAddress.isHex()) {
                    radix = 16;
                }
                BigInteger address = null;
                try {
                    address = new BigInteger(expression, radix);
                }
                catch (NumberFormatException nfe) {
                    MemoryViewUtil.openError((String)DebugUIMessages.GoToAddressAction_Go_to_address_failed, (String)DebugUIMessages.GoToAddressAction_Address_is_invalid, (Exception)nfe);
                }
                IMemoryRenderingContainer[] containers = TraditionalGoToAddressRendering.this.fSite.getMemoryRenderingContainers();
                for (int i = 0; i < containers.length; ++i) {
                    IMemoryRendering activeRendering;
                    if (!(containers[i] instanceof RenderingViewPane)) continue;
                    BigInteger absoluteAddress = null;
                    if (fGotoAddress.isGoToAddress()) {
                        absoluteAddress = address;
                    }
                    IMemoryBlock activeMemoryBlock = null;
                    if (address == null || containers[i] == null || (activeRendering = containers[i].getActiveRendering()) == null) continue;
                    activeMemoryBlock = activeRendering.getMemoryBlock();
                    IMemoryBlockExtension blockExtension = (IMemoryBlockExtension)activeMemoryBlock.getAdapter(IMemoryBlockExtension.class);
                    if (blockExtension != null) {
                        BigInteger baseAddress = null;
                        BigInteger addressableSize = null;
                        try {
                            baseAddress = blockExtension.getBigBaseAddress();
                            addressableSize = BigInteger.valueOf(blockExtension.getAddressableSize());
                        }
                        catch (DebugException de) {
                            // empty catch block
                        }
                        if (baseAddress != null) {
                            if (fGotoAddress.isOffset()) {
                                absoluteAddress = baseAddress.add(address);
                            } else if (fGotoAddress.isJump() && addressableSize != null) {
                                absoluteAddress = baseAddress.add(address.multiply(addressableSize));
                            }
                        }
                    }
                    if (absoluteAddress == null || !(activeRendering instanceof IRepositionableMemoryRendering)) continue;
                    try {
                        ((IRepositionableMemoryRendering)activeRendering).goToAddress(absoluteAddress);
                        continue;
                    }
                    catch (DebugException de) {
                        // empty catch block
                    }
                }
            }
        };
        Button button = fGotoAddress.getButton(0);
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    goHandler.run();
                }
            });
        }
        fGotoAddress.getExpressionWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    goHandler.run();
                }
                super.keyPressed(e);
            }
        });
        return this.fControl;
    }

    public Control getControl() {
        return this.fControl;
    }
}

