/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dd.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.services.IServiceLocator;

public class VMCommandUtils {
    public static IVMProvider getActiveVMProvider(IServiceLocator serviceLocator) {
        ISelection selection = null;
        ISelectionService selectionService = (ISelectionService)serviceLocator.getService(ISelectionService.class);
        if (selectionService != null) {
            selection = selectionService.getSelection();
        }
        if (selection != null && !selection.isEmpty()) {
            return VMCommandUtils.getVMProviderForSelection(selection);
        }
        IWorkbenchPart part = null;
        IPartService partService = (IPartService)serviceLocator.getService(IPartService.class);
        if (partService != null) {
            part = partService.getActivePart();
        }
        return VMCommandUtils.getVMProviderForPart(part);
    }

    public static IVMProvider getVMProviderForPart(IWorkbenchPart part) {
        IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow());
        ISelection debugContext = contextService.getActiveContext(VMCommandUtils.getPartId(part));
        if (debugContext == null) {
            debugContext = contextService.getActiveContext();
        }
        Object input = null;
        if (debugContext instanceof IStructuredSelection) {
            input = ((IStructuredSelection)debugContext).getFirstElement();
        }
        if (part instanceof IDebugView) {
            Viewer viewer = ((IDebugView)part).getViewer();
            if (input instanceof IAdaptable && viewer instanceof TreeModelViewer) {
                IPresentationContext presContext = ((TreeModelViewer)viewer).getPresentationContext();
                IVMAdapter vmAdapter = (IVMAdapter)((IAdaptable)input).getAdapter(IVMAdapter.class);
                if (vmAdapter != null) {
                    return vmAdapter.getVMProvider(presContext);
                }
            }
        }
        return null;
    }

    private static String getPartId(IWorkbenchPart part) {
        if (part instanceof IViewPart) {
            IViewSite site = (IViewSite)part.getSite();
            return site.getId() + (site.getSecondaryId() != null ? ":" + site.getSecondaryId() : "");
        }
        return part.getSite().getId();
    }

    public static IVMProvider getVMProviderForSelection(ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IVMContext) {
            return ((IVMContext)element).getVMNode().getVMProvider();
        }
        return null;
    }
}

