/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.SteppingController;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.StepQueueManager;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractThreadVMNode
extends AbstractDMVMNode
implements IElementLabelProvider {
    public AbstractThreadVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IExecutionDMContext.class);
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IContainerDMContext.class);
        if (runControl == null || contDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        runControl.getExecutionContexts(contDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    AbstractThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                AbstractThreadVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractThreadVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    public void getContextsForEvent(VMDelta parentDelta, Object e, final DataRequestMonitor<IVMContext[]> rm) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            IRunControl.IExecutionDMContext[] triggerContexts = ((IRunControl.IContainerResumedDMEvent)e).getTriggeringContexts();
            if (triggerContexts.length != 0) {
                rm.setData((Object)new IVMContext[]{this.createVMContext((IDMContext)triggerContexts[0])});
                rm.done();
                return;
            }
        } else if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            IRunControl.IExecutionDMContext[] triggerContexts = ((IRunControl.IContainerSuspendedDMEvent)e).getTriggeringContexts();
            if (triggerContexts.length != 0) {
                rm.setData((Object)new IVMContext[]{this.createVMContext((IDMContext)triggerContexts[0])});
                rm.done();
                return;
            }
        } else {
            if (e instanceof SteppingController.SteppingTimedOutEvent && ((SteppingController.SteppingTimedOutEvent)((Object)e)).getDMContext() instanceof IRunControl.IContainerDMContext) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10003, "", null));
                rm.done();
                return;
            }
            if (e instanceof StepQueueManager.ISteppingTimedOutEvent && ((StepQueueManager.ISteppingTimedOutEvent)e).getDMContext() instanceof IRunControl.IContainerDMContext) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10003, "", null));
                rm.done();
                return;
            }
            if (e instanceof FullStackRefreshEvent && ((FullStackRefreshEvent)((Object)e)).getDMContext() instanceof IRunControl.IContainerDMContext) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10003, "", null));
                rm.done();
                return;
            }
            if (e instanceof ModelProxyInstalledEvent) {
                this.getThreadVMCForModelProxyInstallEvent(parentDelta, new DataRequestMonitor<VMContextInfo>(this.getExecutor(), rm){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            rm.setData((Object)new IVMContext[]{((VMContextInfo)this.getData()).fVMContext});
                        } else {
                            rm.setData((Object)new IVMContext[0]);
                        }
                        rm.done();
                    }
                });
                return;
            }
        }
        super.getContextsForEvent(parentDelta, e, rm);
    }

    private void getThreadVMCForModelProxyInstallEvent(VMDelta parentDelta, final DataRequestMonitor<VMContextInfo> rm) {
        this.getVMProvider().updateNode((IVMNode)this, (IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            protected void handleSuccess() {
                try {
                    AbstractThreadVMNode.this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            IRunControl runControl = (IRunControl)AbstractThreadVMNode.this.getServicesTracker().getService(IRunControl.class);
                            if (runControl != null) {
                                int vmcIdx = -1;
                                int suspendedVmcIdx = -1;
                                for (int i = 0; i < ((List)this.getData()).size(); ++i) {
                                    IDMVMContext vmc;
                                    IRunControl.IExecutionDMContext execDmc;
                                    if (!(((List)this.getData()).get(i) instanceof IDMVMContext) || (execDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)(vmc = (IDMVMContext)((List)this.getData()).get(i)).getDMContext(), IRunControl.IExecutionDMContext.class)) == null) continue;
                                    int n = vmcIdx = vmcIdx < 0 ? i : vmcIdx;
                                    if (!runControl.isSuspended(execDmc)) continue;
                                    suspendedVmcIdx = suspendedVmcIdx < 0 ? i : suspendedVmcIdx;
                                }
                                if (suspendedVmcIdx >= 0) {
                                    rm.setData((Object)new VMContextInfo((IVMContext)((List)this.getData()).get(suspendedVmcIdx), suspendedVmcIdx, true));
                                } else if (vmcIdx >= 0) {
                                    rm.setData((Object)new VMContextInfo((IVMContext)((List)this.getData()).get(vmcIdx), vmcIdx, false));
                                } else {
                                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10004, "No threads available", null));
                                }
                                rm.done();
                            } else {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10004, "No threads available", null));
                                rm.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10003, "", null));
                    rm.done();
                }
            }
        }));
    }

    protected abstract void updateLabelInSessionThread(ILabelUpdate[] var1);

    public int getDeltaFlags(Object e) {
        IDMContext dmc;
        IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
        if (dmc instanceof IRunControl.IContainerDMContext) {
            return 0;
        }
        if (e instanceof IRunControl.IResumedDMEvent && ((IRunControl.IResumedDMEvent)e).getReason() != IRunControl.StateChangeReason.STEP) {
            return 1024;
        }
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 0;
        }
        if (e instanceof FullStackRefreshEvent) {
            return 1024;
        }
        if (e instanceof SteppingController.SteppingTimedOutEvent) {
            return 1024;
        }
        if (e instanceof StepQueueManager.ISteppingTimedOutEvent) {
            return 1024;
        }
        if (e instanceof ModelProxyInstalledEvent) {
            return 0x300000;
        }
        return 0;
    }

    public void buildDelta(Object e, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor rm) {
        IDMContext dmc;
        IDMContext iDMContext = dmc = e instanceof IDMEvent ? ((IDMEvent)e).getDMContext() : null;
        if (dmc instanceof IRunControl.IContainerDMContext) {
            rm.done();
        } else if (e instanceof IRunControl.IResumedDMEvent) {
            if (((IRunControl.IResumedDMEvent)e).getReason() != IRunControl.StateChangeReason.STEP) {
                parentDelta.addNode((Object)this.createVMContext(dmc), 1024);
            }
            rm.done();
        } else if (e instanceof IRunControl.ISuspendedDMEvent) {
            rm.done();
        } else if (e instanceof FullStackRefreshEvent) {
            parentDelta.addNode((Object)this.createVMContext(dmc), 1024);
            rm.done();
        } else if (e instanceof SteppingController.SteppingTimedOutEvent) {
            parentDelta.addNode((Object)this.createVMContext(dmc), 1024);
            rm.done();
        } else if (e instanceof StepQueueManager.ISteppingTimedOutEvent) {
            parentDelta.addNode((Object)this.createVMContext(dmc), 1024);
            rm.done();
        } else if (e instanceof ModelProxyInstalledEvent) {
            this.getThreadVMCForModelProxyInstallEvent(parentDelta, new DataRequestMonitor<VMContextInfo>(this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        parentDelta.addNode((Object)((VMContextInfo)this.getData()).fVMContext, nodeOffset + ((VMContextInfo)this.getData()).fIndex, 0x100000 | (((VMContextInfo)this.getData()).fIsSuspended ? 0 : 0x200000));
                    }
                    rm.done();
                }
            });
        } else {
            rm.done();
        }
    }

    private static class VMContextInfo {
        final IVMContext fVMContext;
        final int fIndex;
        final boolean fIsSuspended;

        VMContextInfo(IVMContext vmContext, int index, boolean isSuspended) {
            this.fVMContext = vmContext;
            this.fIndex = index;
            this.fIsSuspended = isSuspended;
        }
    }
}

