/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.VMCommandUtils;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.MessagesForNumberFormat;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class NumberFormatsContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final Map<String, String> FORMATS = new LinkedHashMap<String, String>();
    private IServiceLocator fServiceLocator;
    private static IContributionItem[] NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;

    protected IContributionItem[] getContributionItems() {
        IVMProvider provider = VMCommandUtils.getActiveVMProvider(this.fServiceLocator);
        if (provider == null) {
            return NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;
        }
        IPresentationContext context = provider.getPresentationContext();
        Object activeId = context.getProperty("CurrentNumericStyle");
        if (activeId == null) {
            activeId = "NATURAL.Format";
        }
        ArrayList<SelectNumberFormatAction> actions = new ArrayList<SelectNumberFormatAction>(FORMATS.size());
        for (String formatId : FORMATS.keySet()) {
            SelectNumberFormatAction action = new SelectNumberFormatAction(context, formatId);
            if (formatId.equals(activeId)) {
                action.setChecked(true);
            }
            actions.add(action);
        }
        if (actions.isEmpty()) {
            return NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;
        }
        IContributionItem[] items = new IContributionItem[actions.size()];
        for (int i = 0; i < actions.size(); ++i) {
            items[i] = new ActionContributionItem((IAction)actions.get(i));
        }
        return items;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    static {
        FORMATS.put("NATURAL.Format", MessagesForNumberFormat.NumberFormatContribution_Natural_label);
        FORMATS.put("HEX.Format", MessagesForNumberFormat.NumberFormatContribution_Hex_label);
        FORMATS.put("DECIMAL.Format", MessagesForNumberFormat.NumberFormatContribution_Decimal_label);
        FORMATS.put("OCTAL.Format", MessagesForNumberFormat.NumberFormatContribution_Octal_label);
        FORMATS.put("BINARY.Format", MessagesForNumberFormat.NumberFormatContribution_Binary_label);
        FORMATS.put("STRING.Format", MessagesForNumberFormat.NumberFormatContribution_String_label);
        NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS = new IContributionItem[]{new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 0);
                item.setEnabled(false);
                item.setText(MessagesForNumberFormat.NumberFormatContribution_EmptyFormatsList_label);
            }

            public boolean isEnabled() {
                return false;
            }
        }};
    }

    private class SelectNumberFormatAction
    extends Action {
        private final IPresentationContext fContext;
        private final String fFormatId;

        SelectNumberFormatAction(IPresentationContext context, String formatId) {
            super((String)FORMATS.get(formatId), 8);
            this.fContext = context;
            this.fFormatId = formatId;
        }

        public void run() {
            if (this.isChecked()) {
                this.fContext.setProperty("CurrentNumericStyle", (Object)this.fFormatId);
            }
        }
    }
}

