/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.VMCommandUtils;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.ui.IWorkbenchPart;

public class NumberFormatsPropertyTester
extends PropertyTester {
    private static final String SUPPORTED = "areNumberFormatsSupported";
    private static final String AVAILABLE = "isNumberFormatAvailable";
    private static final String ACTIVE = "isNumberFormatActive";
    private static final List<String> AVAILABLE_FORMATS = new ArrayList<String>();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IVMProvider provider;
        if (receiver instanceof IVMContext) {
            IVMProvider provider2 = ((IVMContext)receiver).getVMNode().getVMProvider();
            if (provider2 != null) {
                return this.testProvider(provider2, property, expectedValue);
            }
        } else if (receiver instanceof IDebugView && (provider = VMCommandUtils.getVMProviderForPart((IWorkbenchPart)((IDebugView)receiver))) != null) {
            return this.testProvider(provider, property, expectedValue);
        }
        return false;
    }

    private boolean testProvider(IVMProvider provider, String property, Object expectedValue) {
        if (SUPPORTED.equals(property)) {
            return true;
        }
        if (AVAILABLE.equals(property)) {
            return AVAILABLE_FORMATS.contains(expectedValue);
        }
        if (ACTIVE.equals(property)) {
            Object activeId = provider.getPresentationContext().getProperty("CurrentNumericStyle");
            return expectedValue != null && expectedValue.equals(activeId);
        }
        return false;
    }

    static {
        AVAILABLE_FORMATS.add("NATURAL.Format");
        AVAILABLE_FORMATS.add("HEX.Format");
        AVAILABLE_FORMATS.add("DECIMAL.Format");
        AVAILABLE_FORMATS.add("OCTAL.Format");
        AVAILABLE_FORMATS.add("BINARY.Format");
        AVAILABLE_FORMATS.add("STRING.Format");
    }
}

