/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.AbstractExpressionVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.IFormattedValueVMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register.RegisterCellModifier;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterVMNode
extends AbstractExpressionVMNode
implements IElementEditor,
IElementLabelProvider,
IElementMementoProvider {
    private IWatchExpressionFactoryAdapter2 fRegisterExpressionFactory = null;
    private final SyncRegisterDataAccess fSyncRegisterDataAccess;
    private final IFormattedValuePreferenceStore fFormattedPrefStore;
    private final String MEMENTO_NAME = "REGISTER_MEMENTO_NAME";

    public RegisterVMNode(IFormattedValuePreferenceStore prefStore, AbstractDMVMProvider provider, DsfSession session, SyncRegisterDataAccess syncDataAccess) {
        super(provider, session, IRegisters.IRegisterDMContext.class);
        this.fSyncRegisterDataAccess = syncDataAccess;
        this.fFormattedPrefStore = prefStore;
    }

    public String toString() {
        return "RegisterVMNode(" + this.getSession().getId() + ")";
    }

    protected SyncRegisterDataAccess getSyncRegisterDataAccess() {
        return this.fSyncRegisterDataAccess;
    }

    public IFormattedValuePreferenceStore getPreferenceStore() {
        return this.fFormattedPrefStore;
    }

    public IWatchExpressionFactoryAdapter2 getWatchExpressionFactory() {
        if (this.fRegisterExpressionFactory == null) {
            this.fRegisterExpressionFactory = new RegisterExpressionFactory();
        }
        return this.fRegisterExpressionFactory;
    }

    private void retrieveAllFormattedDataValues(ArrayList<QueuedValueUpdate> updates) {
        IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        if (regService == null) {
            for (QueuedValueUpdate up : updates) {
                this.handleFailedUpdate((IViewerUpdate)up.getUpdate());
            }
            return;
        }
        for (QueuedValueUpdate up : updates) {
            final ILabelUpdate update = up.getUpdate();
            final int idx = up.getIndex();
            final IFormattedValues.FormattedValueDMContext valueDmc = up.getValueDmc();
            this.getDMVMProvider().getModelData((IVMNode)this, (IViewerUpdate)update, (IDMService)regService, (IDMContext)valueDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        if (this.getStatus().getCode() == 10001) {
                            update.setLabel("...", idx);
                        } else {
                            update.setLabel("Error: " + this.getStatus().getMessage(), idx);
                        }
                        update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                        update.done();
                        return;
                    }
                    update.setLabel(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), idx);
                    IFormattedValues.FormattedValueDMData oldData = (IFormattedValues.FormattedValueDMData)RegisterVMNode.this.getDMVMProvider().getArchivedModelData((IVMNode)RegisterVMNode.this, (IViewerUpdate)update, (IDMContext)valueDmc);
                    if (oldData != null && !oldData.getFormattedValue().equals(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue())) {
                        update.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB(), idx);
                    }
                    update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                    update.done();
                }
            }, (Executor)this.getSession().getExecutor());
        }
    }

    private void getFormattedDmcForReqister(ILabelUpdate update, final IRegisters.IRegisterDMContext dmc, final DataRequestMonitor<IFormattedValues.FormattedValueDMContext> rm) {
        final IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        if (regService == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10003, "", null));
            rm.done();
            return;
        }
        IPresentationContext context = update.getPresentationContext();
        final String preferencePageFormatId = this.getPreferenceStore().getCurrentNumericFormat(context);
        regService.getAvailableFormats((IFormattedValues.IFormattedDataDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)this.getSession().getExecutor(), rm){

            public void handleSuccess() {
                String[] formatIds = (String[])this.getData();
                String finalFormatId = "NATURAL.Format";
                boolean requestedFormatIsSupported = false;
                for (String fId : formatIds) {
                    if (!preferencePageFormatId.equals(fId)) continue;
                    finalFormatId = preferencePageFormatId;
                    requestedFormatIsSupported = true;
                    break;
                }
                if (!requestedFormatIsSupported) {
                    if (formatIds.length != 0) {
                        finalFormatId = formatIds[0];
                    } else {
                        this.handleFailure();
                        return;
                    }
                }
                rm.setData((Object)regService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)dmc, finalFormatId));
                rm.done();
            }
        });
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    RegisterVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(final ILabelUpdate[] updates) {
        final ArrayList valueUpdatesToProcess = new ArrayList();
        final DsfExecutor dsfExecutor = this.getSession().getExecutor();
        MultiRequestMonitor<RequestMonitor> mrm = new MultiRequestMonitor<RequestMonitor>((Executor)dsfExecutor, null){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    for (ILabelUpdate up : updates) {
                        RegisterVMNode.this.handleFailedUpdate((IViewerUpdate)up);
                    }
                    return;
                }
                RegisterVMNode.this.retrieveAllFormattedDataValues(valueUpdatesToProcess);
            }
        };
        for (final ILabelUpdate update : updates) {
            final IRegisters.IRegisterDMContext dmc = (IRegisters.IRegisterDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRegisters.IRegisterDMContext.class);
            if (dmc == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
            if (regService == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            this.getDMVMProvider().getModelData((IVMNode)this, (IViewerUpdate)update, (IDMService)regService, (IDMContext)dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRegisters.IRegisterDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update, (MultiRequestMonitor)mrm){
                final /* synthetic */ MultiRequestMonitor val$mrm;
                {
                    this.val$mrm = multiRequestMonitor;
                    super(x0, x1);
                }

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        String[] localColumns = update.getPresentationContext().getColumns();
                        if (localColumns == null) {
                            localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                        }
                        for (int idx = 0; idx < localColumns.length; ++idx) {
                            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                                update.setLabel("Unknown name", idx);
                                update.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_REGISTER"), idx);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                                update.setLabel("", idx);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                                if (this.getStatus().getCode() == 10001) {
                                    update.setLabel("...", idx);
                                } else {
                                    update.setLabel("Error: " + this.getStatus().getMessage(), idx);
                                }
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) {
                                update.setLabel("...", idx);
                            } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx])) {
                                update.setLabel("", idx);
                            }
                            update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                        }
                        update.done();
                        return;
                    }
                    String[] localColumns = update.getColumnIds();
                    if (localColumns == null) {
                        localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                    }
                    boolean allFieldsProcessed = true;
                    for (int idx = 0; idx < localColumns.length; ++idx) {
                        update.setFontData(JFaceResources.getFontDescriptor((String)"org.eclipse.debug.ui.VariableTextFont").getFontData()[0], idx);
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IRegisterDMData)this.getData()).getName(), idx);
                            update.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_REGISTER"), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                            allFieldsProcessed = false;
                            final QueuedValueUpdate valueUpdate = new QueuedValueUpdate(update, idx, dmc);
                            valueUpdatesToProcess.add(valueUpdate);
                            DataRequestMonitor<IFormattedValues.FormattedValueDMContext> rm = new DataRequestMonitor<IFormattedValues.FormattedValueDMContext>((Executor)dsfExecutor, null){

                                public void handleCompleted() {
                                    valueUpdate.setValueDmc((IFormattedValues.FormattedValueDMContext)this.getData());
                                    val$mrm.requestMonitorDone((RequestMonitor)this);
                                }
                            };
                            this.val$mrm.add((RequestMonitor)rm);
                            RegisterVMNode.this.getFormattedDmcForReqister(update, dmc, (DataRequestMonitor<IFormattedValues.FormattedValueDMContext>)((DataRequestMonitor)rm));
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                            IRegisters.IRegisterDMData data = (IRegisters.IRegisterDMData)this.getData();
                            String typeStr = "Unsigned";
                            String ReadAttrStr = "ReadNone";
                            String WriteAddrStr = "WriteNone";
                            if (data.isFloat()) {
                                typeStr = "Floating Point";
                            }
                            if (data.isReadOnce()) {
                                ReadAttrStr = "ReadOnce";
                            } else if (data.isReadable()) {
                                ReadAttrStr = "Readable";
                            }
                            if (data.isReadOnce()) {
                                WriteAddrStr = "WriteOnce";
                            } else if (data.isReadable()) {
                                WriteAddrStr = "Writeable";
                            }
                            typeStr = typeStr + " - " + ReadAttrStr + "/" + WriteAddrStr;
                            update.setLabel(typeStr, idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IRegisterDMData)this.getData()).getDescription(), idx);
                            continue;
                        }
                        if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx])) continue;
                        IVMContext vmc = (IVMContext)update.getElement();
                        IExpression expression = (IExpression)vmc.getAdapter(IExpression.class);
                        if (expression != null) {
                            update.setLabel(expression.getExpressionText(), idx);
                            continue;
                        }
                        update.setLabel(((IRegisters.IRegisterDMData)this.getData()).getName(), idx);
                    }
                    if (allFieldsProcessed) {
                        update.done();
                    }
                }
            }, (Executor)this.getSession().getExecutor());
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        for (IHasChildrenUpdate update : updates) {
            update.setHasChilren(true);
            update.done();
        }
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        if (regService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        regService.getRegisters(this.createCompositeDMVMContext((IViewerUpdate)update), (DataRequestMonitor)new ViewerDataRequestMonitor<IRegisters.IRegisterDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    RegisterVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                RegisterVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new RegisterVMC(dmc);
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IRegisters.IRegistersChangedDMEvent || e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            return 1024;
        }
        if (e instanceof IRegisters.IRegisterChangedDMEvent) {
            return 2048;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IRegisters.IRegistersChangedDMEvent || e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        if (e instanceof IRegisters.IRegisterChangedDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IRegisters.IRegisterChangedDMEvent)e).getDMContext()), 2048);
        }
        rm.done();
    }

    @Override
    public boolean canParseExpression(IExpression expression) {
        return this.parseExpressionForRegisterName(expression.getExpressionText()) != null;
    }

    private String parseExpressionForRegisterName(String expression) {
        if (expression.startsWith("GRP(")) {
            int startIdx = "GRP(".length();
            int endIdx = expression.indexOf(41, startIdx);
            String remaining = expression.substring(endIdx + 1);
            if (!remaining.startsWith(".REG(")) {
                return null;
            }
            startIdx = ".REG(".length();
            endIdx = remaining.indexOf(41, startIdx);
            String regName = remaining.substring(startIdx, endIdx);
            return regName.trim();
        }
        if (expression.startsWith("$")) {
            return null;
        }
        return null;
    }

    @Override
    protected void testElementForExpression(Object element, IExpression expression, final DataRequestMonitor<Boolean> rm) {
        if (!(element instanceof IDMVMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final IRegisters.IRegisterDMContext dmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IRegisterDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final String regName = this.parseExpressionForRegisterName(expression.getExpressionText());
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IRegisters registersService = (IRegisters)RegisterVMNode.this.getServicesTracker().getService(IRegisters.class);
                    if (registersService != null) {
                        registersService.getRegisterData(dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>(ImmediateExecutor.getInstance(), (RequestMonitor)rm){

                            protected void handleSuccess() {
                                rm.setData((Object)((IRegisters.IRegisterDMData)this.getData()).getName().equals(regName));
                                rm.done();
                            }
                        });
                    } else {
                        rm.setStatus((IStatus)new Status(2, "org.eclipse.dd.dsf.debug.ui", 10001, "Register service not available", null));
                        rm.done();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            rm.setStatus((IStatus)new Status(2, "org.eclipse.dd.dsf.debug.ui", 10001, "DSF session shut down", null));
            rm.done();
        }
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof RegisterVMC) {
            ((RegisterVMC)element).setExpression(expression);
        }
    }

    @Override
    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        if (event instanceof IRegisters.IRegisterChangedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            return 2048;
        }
        if (event instanceof IRegisters.IRegistersChangedDMEvent || event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRegisters.IRegistersChangedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    @Override
    public void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IRegisters.IRegisterChangedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            parentDelta.addNode(element, 2048);
        }
        rm.done();
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        IRegisters.IRegisterDMData regData;
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnId) && (regData = this.getSyncRegisterDataAccess().readRegister(element)) != null && regData.isWriteable()) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return new RegisterCellModifier((AbstractCachingVMProvider)this.getDMVMProvider(), this.fFormattedPrefStore, this.getSyncRegisterDataAccess());
    }

    public void compareElements(IElementCompareRequest[] requests) {
        for (final IElementCompareRequest request : requests) {
            final IRegisters.IRegisterDMContext regDmc = (IRegisters.IRegisterDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IRegisters.IRegisterDMContext.class);
            final String mementoName = request.getMemento().getString("REGISTER_MEMENTO_NAME");
            if (regDmc == null || mementoName == null) {
                request.done();
                continue;
            }
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IRegisters regService = (IRegisters)RegisterVMNode.this.getServicesTracker().getService(IRegisters.class);
                        if (regService != null) {
                            regService.getRegisterData(regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)regService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (this.getStatus().isOK()) {
                                        request.setEqual(mementoName.equals("Register." + ((IRegisters.IRegisterDMData)this.getData()).getName()));
                                    }
                                    request.done();
                                }
                            });
                        } else {
                            request.done();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                request.done();
            }
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        for (final IElementMementoRequest request : requests) {
            final IRegisters.IRegisterDMContext regDmc = (IRegisters.IRegisterDMContext)this.findDmcInPath(request.getViewerInput(), request.getElementPath(), IRegisters.IRegisterDMContext.class);
            if (regDmc == null) {
                request.done();
                continue;
            }
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IRegisters regService = (IRegisters)RegisterVMNode.this.getServicesTracker().getService(IRegisters.class);
                        if (regService != null) {
                            regService.getRegisterData(regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)regService.getExecutor(), null){

                                protected void handleCompleted() {
                                    if (this.getStatus().isOK()) {
                                        request.getMemento().putString("REGISTER_MEMENTO_NAME", "Register." + ((IRegisters.IRegisterDMData)this.getData()).getName());
                                    }
                                    request.done();
                                }
                            });
                        } else {
                            request.done();
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                request.done();
            }
        }
    }

    private class QueuedValueUpdate {
        ILabelUpdate fUpdate;
        int fIndex;
        IRegisters.IRegisterDMContext fDmc;
        IFormattedValues.FormattedValueDMContext fValueDmc = null;

        public QueuedValueUpdate(ILabelUpdate update, int index, IRegisters.IRegisterDMContext dmc) {
            this.fUpdate = update;
            this.fIndex = index;
            this.fDmc = dmc;
        }

        public ILabelUpdate getUpdate() {
            return this.fUpdate;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public IRegisters.IRegisterDMContext getDmc() {
            return this.fDmc;
        }

        public void setValueDmc(IFormattedValues.FormattedValueDMContext dmc) {
            this.fValueDmc = dmc;
        }

        public IFormattedValues.FormattedValueDMContext getValueDmc() {
            return this.fValueDmc;
        }
    }

    protected class RegisterExpressionFactory
    implements IWatchExpressionFactoryAdapter2 {
        protected RegisterExpressionFactory() {
        }

        public boolean canCreateWatchExpression(Object element) {
            return element instanceof RegisterVMC;
        }

        public String createWatchExpression(Object element) throws CoreException {
            IRegisters.IRegisterGroupDMData groupData = RegisterVMNode.this.getSyncRegisterDataAccess().getRegisterGroupDMData(element);
            IRegisters.IRegisterDMData registerData = RegisterVMNode.this.getSyncRegisterDataAccess().getRegisterDMData(element);
            if (groupData != null && registerData != null) {
                StringBuffer exprBuf = new StringBuffer();
                exprBuf.append("GRP( ");
                exprBuf.append(groupData.getName());
                exprBuf.append(" )");
                exprBuf.append(".REG( ");
                exprBuf.append(registerData.getName());
                exprBuf.append(" )");
                return exprBuf.toString();
            }
            return null;
        }
    }

    protected class RegisterVMC
    extends AbstractDMVMNode.DMVMContext
    implements IFormattedValueVMContext {
        private IExpression fExpression;

        public RegisterVMC(IDMContext dmc) {
            super((AbstractDMVMNode)RegisterVMNode.this, dmc);
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return RegisterVMNode.this.getWatchExpressionFactory();
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof RegisterVMC && super.equals(other)) {
                RegisterVMC otherReg = (RegisterVMC)other;
                return otherReg.fExpression == null && this.fExpression == null || otherReg.fExpression != null && otherReg.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }

        public IFormattedValuePreferenceStore getPreferenceStore() {
            return RegisterVMNode.this.fFormattedPrefStore;
        }
    }
}

