/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.viewmodel.numberformat.detail;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.detailsupport.DetailPaneMaxLengthAction;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.detailsupport.DetailPaneWordWrapAction;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.detailsupport.MessagesForDetailPane;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.detailsupport.TextViewerAction;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class NumberFormatDetailPane
implements IDetailPane,
IAdaptable,
IPropertyChangeListener {
    private IWorkbenchPartSite fWorkbenchPartSite;
    private Map<String, IAction> fActionMap = new HashMap<String, IAction>();
    private List<String> fSelectionActions = new ArrayList<String>();
    protected static final String DETAIL_COPY_ACTION = ActionFactory.COPY.getId() + ".SourceDetailPane";
    protected static final String DETAIL_SELECT_ALL_ACTION = IDebugView.SELECT_ALL_ACTION + ".SourceDetailPane";
    protected static final String DETAIL_WORD_WRAP_ACTION = "org.eclipse.dd.dsf.debug.ui.detail_pane_word_wrap";
    protected static final String DETAIL_MAX_LENGTH_ACTION = "MaxLength";
    public static final String ID = "NumberFormatPane";
    private String fDebugModelIdentifier;
    private StatusLineContributionItem fStatusLineItem;
    private SourceViewer fSourceViewer;
    private IStructuredSelection fLastDisplayed = null;
    private IDocument fDetailDocument;
    private DetailJob fDetailJob = null;
    private final String fPositionLabelPattern = MessagesForDetailPane.DetailPane_LabelPattern;
    private final PositionLabelValue fLineLabel = new PositionLabelValue();
    private final PositionLabelValue fColumnLabel = new PositionLabelValue();
    private final Object[] fPositionLabelPatternArguments = new Object[]{this.fLineLabel, this.fColumnLabel};
    private ICursorListener fCursorListener;

    public void init(IWorkbenchPartSite workbench) {
        this.fWorkbenchPartSite = workbench;
    }

    protected void setAction(String actionID, IAction action) {
        if (action == null) {
            this.fActionMap.remove(actionID);
        } else {
            this.fActionMap.put(actionID, action);
        }
    }

    protected void setGlobalAction(String actionID, IAction action) {
        this.getViewSite().getActionBars().setGlobalActionHandler(actionID, action);
    }

    protected void setSelectionDependantAction(String actionID) {
        if (actionID != null) {
            this.fSelectionActions.add(actionID);
        }
    }

    protected IAction getAction(String actionID) {
        return this.fActionMap.get(actionID);
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void updateSelectionDependentActions() {
        Iterator<String> iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    protected IViewSite getViewSite() {
        if (this.fWorkbenchPartSite == null) {
            return null;
        }
        return (IViewSite)this.fWorkbenchPartSite.getPart().getSite();
    }

    protected IWorkbenchPartSite getWorkbenchPartSite() {
        return this.fWorkbenchPartSite;
    }

    protected boolean isInView() {
        return this.fWorkbenchPartSite != null;
    }

    public Control createControl(Composite parent) {
        this.createSourceViewer(parent);
        if (this.isInView()) {
            this.createViewSpecificComponents();
            this.createActions();
            DsfDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        }
        return this.fSourceViewer.getControl();
    }

    private void createSourceViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 768);
        this.fSourceViewer.setDocument(this.getDetailDocument());
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.dd.dsf.debug.uiDetailPaneFont"));
        this.fSourceViewer.getTextWidget().setWordWrap(DsfDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
        this.fSourceViewer.setEditable(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fSourceViewer.getTextWidget(), "org.eclipse.debug.ui.detail_pane_context");
        Control control = this.fSourceViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
    }

    private void createViewSpecificComponents() {
        this.getDetailDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                NumberFormatDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NumberFormatDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NumberFormatDetailPane.this.getViewSite().setSelectionProvider(NumberFormatDetailPane.this.fSourceViewer.getSelectionProvider());
                NumberFormatDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, NumberFormatDetailPane.this.getAction(DETAIL_SELECT_ALL_ACTION));
                NumberFormatDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, NumberFormatDetailPane.this.getAction(DETAIL_COPY_ACTION));
                NumberFormatDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                NumberFormatDetailPane.this.getViewSite().setSelectionProvider(null);
                NumberFormatDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                NumberFormatDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                NumberFormatDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        this.fStatusLineItem = new StatusLineContributionItem("ModeContributionItem");
        IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
        manager.add((IContributionItem)this.fStatusLineItem);
        this.fSourceViewer.getTextWidget().addMouseListener((MouseListener)this.getCursorListener());
        this.fSourceViewer.getTextWidget().addKeyListener((KeyListener)this.getCursorListener());
        this.createDetailContextMenu((Control)this.fSourceViewer.getTextWidget());
    }

    private void createActions() {
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 7);
        textAction.configureAction(MessagesForDetailPane.DetailPane_Select_All, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_select_all_action_context");
        this.setAction(DETAIL_SELECT_ALL_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 4);
        textAction.configureAction(MessagesForDetailPane.DetailPane_Copy, "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, "org.eclipse.debug.ui.detail_pane_copy_action_context");
        this.setAction(DETAIL_COPY_ACTION, (IAction)textAction);
        this.setSelectionDependantAction(DETAIL_COPY_ACTION);
        this.updateSelectionDependentActions();
        Action action = new DetailPaneWordWrapAction((ITextViewer)this.fSourceViewer);
        this.setAction(DETAIL_WORD_WRAP_ACTION, (IAction)action);
        action = new DetailPaneMaxLengthAction(this.fSourceViewer.getControl().getShell());
        this.setAction(DETAIL_MAX_LENGTH_ACTION, (IAction)action);
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                NumberFormatDetailPane.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getViewSite().registerContextMenu("org.eclipse.debug.ui.VariableView.detail", menuMgr, this.fSourceViewer.getSelectionProvider());
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_COPY_ACTION));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_WORD_WRAP_ACTION));
        menu.add(this.getAction(DETAIL_MAX_LENGTH_ACTION));
        menu.add((IContributionItem)new Separator("additions"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(IStructuredSelection selection) {
        String[] ids;
        IDebugModelProvider debugModelProvider;
        if (selection == null) {
            this.clearSourceViewer();
            return;
        }
        this.fLastDisplayed = selection;
        if (selection.isEmpty() || !(selection instanceof ITreeSelection)) {
            this.clearSourceViewer();
            return;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IAdaptable && (debugModelProvider = (IDebugModelProvider)((IAdaptable)firstElement).getAdapter(IDebugModelProvider.class)) != null && (ids = debugModelProvider.getModelIdentifiers()) != null && ids.length > 0) {
            this.setDebugModel(ids[0]);
        }
        NumberFormatDetailPane numberFormatDetailPane = this;
        synchronized (numberFormatDetailPane) {
            Viewer viewer;
            Object input;
            IWorkbenchPart part;
            if (this.fDetailJob != null) {
                this.fDetailJob.cancel();
            }
            if ((part = this.fWorkbenchPartSite.getPart()) instanceof IDebugView && (input = (viewer = ((IDebugView)part).getViewer()).getInput()) != null && viewer instanceof TreeModelViewer) {
                TreeModelViewer treeModelViewer = (TreeModelViewer)viewer;
                this.fDetailJob = new DetailJob(treeModelViewer.getPresentationContext(), input, (ITreeSelection)selection, null);
                this.fDetailJob.schedule();
            }
        }
    }

    public boolean setFocus() {
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getTextWidget().setFocus();
            return true;
        }
        return false;
    }

    public void dispose() {
        this.fActionMap.clear();
        this.fSelectionActions.clear();
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        this.fDebugModelIdentifier = null;
        if (this.fSourceViewer != null && this.fSourceViewer.getControl() != null) {
            this.fSourceViewer.getControl().dispose();
        }
        if (this.isInView()) {
            this.disposeUndoRedoAction(ITextEditorActionConstants.UNDO);
            this.disposeUndoRedoAction(ITextEditorActionConstants.REDO);
            this.getViewSite().getActionBars().getStatusLineManager().remove((IContributionItem)this.fStatusLineItem);
            DsfDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public String getDescription() {
        return MessagesForDetailPane.NumberFormatDetailPane_Description;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return MessagesForDetailPane.NumberFormatDetailPane_Name;
    }

    public Object getAdapter(Class required) {
        if (IFindReplaceTarget.class.equals((Object)required)) {
            return this.fSourceViewer.getFindReplaceTarget();
        }
        if (ITextViewer.class.equals((Object)required)) {
            return this.fSourceViewer;
        }
        return null;
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    protected void clearSourceViewer() {
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        this.fLastDisplayed = null;
        this.fDetailDocument.set("");
        this.fSourceViewer.setEditable(false);
    }

    protected void configureDetailsViewer() {
        SourceViewerConfiguration svc = new SourceViewerConfiguration();
        this.fSourceViewer.setEditable(false);
        this.fSourceViewer.unconfigure();
        this.fSourceViewer.configure(svc);
        if (this.isInView()) {
            this.createUndoRedoActions();
        }
    }

    protected String getCursorPosition() {
        if (this.fSourceViewer == null) {
            return "";
        }
        StyledText styledText = this.fSourceViewer.getTextWidget();
        int caret = styledText.getCaretOffset();
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return "";
        }
        try {
            int line = document.getLineOfOffset(caret);
            int lineOffset = document.getLineOffset(line);
            int tabWidth = styledText.getTabs();
            int column = 0;
            for (int i = lineOffset; i < caret; ++i) {
                if ('\t' == document.getChar(i)) {
                    column += tabWidth - (tabWidth == 0 ? 0 : column % tabWidth);
                    continue;
                }
                ++column;
            }
            this.fLineLabel.fValue = line + 1;
            this.fColumnLabel.fValue = column + 1;
            return MessageFormat.format(this.fPositionLabelPattern, this.fPositionLabelPatternArguments);
        }
        catch (BadLocationException x) {
            return "";
        }
    }

    private ICursorListener getCursorListener() {
        if (this.fCursorListener == null) {
            this.fCursorListener = new ICursorListener(){

                public void keyPressed(KeyEvent e) {
                    NumberFormatDetailPane.this.fStatusLineItem.setText(NumberFormatDetailPane.this.getCursorPosition());
                }

                public void keyReleased(KeyEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    NumberFormatDetailPane.this.fStatusLineItem.setText(NumberFormatDetailPane.this.getCursorPosition());
                }
            };
        }
        return this.fCursorListener;
    }

    protected String getDebugModel() {
        return this.fDebugModelIdentifier;
    }

    protected void setDebugModel(String id) {
        if (id != this.fDebugModelIdentifier) {
            this.fDebugModelIdentifier = id;
            this.configureDetailsViewer();
        }
    }

    protected void createUndoRedoActions() {
        this.disposeUndoRedoAction(ITextEditorActionConstants.UNDO);
        this.disposeUndoRedoAction(ITextEditorActionConstants.REDO);
        IUndoContext undoContext = this.getUndoContext();
        if (undoContext != null) {
            UndoActionHandler undoAction = new UndoActionHandler((IWorkbenchPartSite)this.getViewSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
            undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.setAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            this.setGlobalAction(ITextEditorActionConstants.UNDO, (IAction)undoAction);
            RedoActionHandler redoAction = new RedoActionHandler((IWorkbenchPartSite)this.getViewSite(), undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
            redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
            this.setAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
            this.setGlobalAction(ITextEditorActionConstants.REDO, (IAction)redoAction);
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected void disposeUndoRedoAction(String actionId) {
        OperationHistoryActionHandler action = (OperationHistoryActionHandler)this.getAction(actionId);
        if (action != null) {
            action.dispose();
            this.setAction(actionId, null);
        }
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager = this.fSourceViewer.getUndoManager();
        if (undoManager instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("org.eclipse.dd.dsf.debug.uiDetailPaneFont")) {
            this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.dd.dsf.debug.uiDetailPaneFont"));
        } else if (propertyName.equals("org.eclipse.dd.dsf.debug.ui.max_detail_length")) {
            this.display(this.fLastDisplayed);
        } else if (propertyName.equals(DETAIL_WORD_WRAP_ACTION)) {
            this.fSourceViewer.getTextWidget().setWordWrap(DsfDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
            this.getAction(DETAIL_WORD_WRAP_ACTION).setChecked(DsfDebugUIPlugin.getDefault().getPreferenceStore().getBoolean(DETAIL_WORD_WRAP_ACTION));
        }
    }

    class DetailJob
    extends Job
    implements IValueDetailListener {
        private IPresentationContext fPresentationContext;
        private Object fViewerInput;
        private ITreeSelection fElements;
        private boolean fFirst;
        private IProgressMonitor fMonitor;
        private boolean fComputed;

        public DetailJob(IPresentationContext context, Object viewerInput, ITreeSelection elements, IDebugModelPresentation model) {
            super("compute variable details");
            this.fFirst = true;
            this.fComputed = false;
            this.setSystem(true);
            this.fPresentationContext = context;
            this.fViewerInput = viewerInput;
            this.fElements = elements;
        }

        private void putInformationIntoDetailPane(final AbstractCachingVMProvider provider, final IVMNode node, final TreePath path, final IFormattedValues.IFormattedDataDMContext finalDmc, final IFormattedValues service, final IProgressMonitor monitor, final String name) {
            DataRequestMonitor<String[]> getAvailableFormatsDone = new DataRequestMonitor<String[]>((Executor)service.getExecutor(), null){

                protected void handleSuccess() {
                    if (monitor.isCanceled()) {
                        ((Object)((Object)this)).notifyAll();
                        return;
                    }
                    String[] formats = (String[])this.getData();
                    final ArrayList completedFormatStrings = new ArrayList();
                    final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)service.getExecutor(), null){

                        protected void handleCompleted() {
                            if (monitor.isCanceled()) {
                                ((Object)((Object)this)).notifyAll();
                                return;
                            }
                            Collections.sort(completedFormatStrings);
                            int len = completedFormatStrings.size();
                            if (len == 0) {
                                DetailJob.this.detailComputed(null, "");
                            } else {
                                String finalResult = "Name : " + name + "\n";
                                int cnt = 0;
                                for (String str : completedFormatStrings) {
                                    finalResult = finalResult + "   " + str;
                                    if (++cnt >= len) continue;
                                    finalResult = finalResult + "\n";
                                }
                                DetailJob.this.detailComputed(null, finalResult);
                            }
                        }
                    };
                    countingRm.setDoneCount(formats.length);
                    for (final String str : formats) {
                        IFormattedValues.FormattedValueDMContext valueDmc = service.getFormattedValueContext(finalDmc, str);
                        provider.getModelData(node, new IViewerUpdate(){

                            public void cancel() {
                            }

                            public void done() {
                            }

                            public Object getViewerInput() {
                                return DetailJob.this.fViewerInput;
                            }

                            public TreePath getElementPath() {
                                return path;
                            }

                            public Object getElement() {
                                return path.getLastSegment();
                            }

                            public IPresentationContext getPresentationContext() {
                                return DetailJob.this.fPresentationContext;
                            }

                            public boolean isCanceled() {
                                return monitor.isCanceled();
                            }

                            public void setStatus(IStatus status) {
                            }

                            public IStatus getStatus() {
                                return null;
                            }
                        }, (IDMService)service, (IDMContext)valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)service.getExecutor(), null){

                            public void handleCompleted() {
                                if (this.getStatus().isOK()) {
                                    if (str == "HEX.Format") {
                                        completedFormatStrings.add("Hex.... : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                    } else if (str == "OCTAL.Format") {
                                        completedFormatStrings.add("Octal.. : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                    } else if (str == "NATURAL.Format") {
                                        completedFormatStrings.add("Natural : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                    } else if (str == "BINARY.Format") {
                                        completedFormatStrings.add("Binary. : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                    } else if (str == "DECIMAL.Format") {
                                        completedFormatStrings.add("Decimal : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                    } else if (str == "STRING.Format") {
                                        completedFormatStrings.add("String : " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                    } else {
                                        completedFormatStrings.add("Other.. : (" + str + ") " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                                    }
                                }
                                countingRm.done();
                            }
                        }, provider.getExecutor());
                    }
                }
            };
            service.getAvailableFormats(finalDmc, (DataRequestMonitor)getAvailableFormatsDone);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(final IProgressMonitor monitor) {
            String message = null;
            if (this.fMonitor != null && !this.fMonitor.isCanceled()) {
                this.fMonitor.setCanceled(true);
            }
            this.fMonitor = monitor;
            TreePath[] paths = this.fElements.getPaths();
            for (int i = 0; i < paths.length && !monitor.isCanceled(); ++i) {
                final TreePath path = paths[i];
                Object element = paths[i].getLastSegment();
                if (element instanceof IDMVMContext) {
                    IDMVMContext vmc = (IDMVMContext)element;
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfDebugUIPlugin.getBundleContext(), vmc.getDMContext().getSessionId());
                    final AbstractCachingVMProvider provider = (AbstractCachingVMProvider)vmc.getAdapter(AbstractCachingVMProvider.class);
                    final IVMNode node = (IVMNode)vmc.getAdapter(IVMNode.class);
                    final IRegisters.IBitFieldDMContext bitfieldDmc = (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IBitFieldDMContext.class);
                    if (bitfieldDmc != null) {
                        final IRegisters regService = (IRegisters)tracker.getService(IRegisters.class);
                        regService.getExecutor().submit(new Runnable(){

                            public void run() {
                                regService.getBitFieldData(bitfieldDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)regService.getExecutor(), null){

                                    public void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            DetailJob.this.putInformationIntoDetailPane(provider, node, path, (IFormattedValues.IFormattedDataDMContext)bitfieldDmc, (IFormattedValues)regService, monitor, ((IRegisters.IBitFieldDMData)this.getData()).getName());
                                        }
                                    }
                                });
                            }
                        });
                    } else {
                        final IRegisters.IRegisterDMContext regDmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IRegisterDMContext.class);
                        if (regDmc != null) {
                            final IRegisters regService = (IRegisters)tracker.getService(IRegisters.class);
                            regService.getExecutor().submit(new Runnable(){

                                public void run() {
                                    regService.getRegisterData(regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)regService.getExecutor(), null){

                                        public void handleCompleted() {
                                            if (this.getStatus().isOK()) {
                                                DetailJob.this.putInformationIntoDetailPane(provider, node, path, (IFormattedValues.IFormattedDataDMContext)regDmc, (IFormattedValues)regService, monitor, ((IRegisters.IRegisterDMData)this.getData()).getName());
                                            }
                                        }
                                    });
                                }
                            });
                        } else {
                            final IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IExpressions.IExpressionDMContext.class);
                            if (exprDmc == null) continue;
                            final IExpressions exprService = (IExpressions)tracker.getService(IExpressions.class);
                            exprService.getExecutor().submit(new Runnable(){

                                public void run() {
                                    DetailJob.this.putInformationIntoDetailPane(provider, node, path, (IFormattedValues.IFormattedDataDMContext)exprDmc, (IFormattedValues)exprService, monitor, exprDmc.getExpression());
                                }
                            });
                        }
                    }
                    tracker.dispose();
                    DetailJob detailJob = this;
                    synchronized (detailJob) {
                        block13: {
                            try {
                                ((Object)((Object)this)).wait(30000L);
                                if (this.fComputed) break block13;
                                this.fMonitor.setCanceled(true);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                    }
                }
                message = element instanceof String ? (String)element : element.toString();
                this.fComputed = true;
                if (this.fComputed) continue;
                if (message == null) {
                    this.detailComputed(null, "");
                    continue;
                }
                this.detailComputed(null, message);
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void canceling() {
            super.canceling();
            DetailJob detailJob = this;
            synchronized (detailJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detailComputed(IValue value, final String result) {
            DetailJob detailJob = this;
            synchronized (detailJob) {
                this.fComputed = true;
            }
            if (!this.fMonitor.isCanceled()) {
                WorkbenchJob append = new WorkbenchJob("append details"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!DetailJob.this.fMonitor.isCanceled()) {
                            String insert = result;
                            int length = 0;
                            if (!DetailJob.this.fFirst) {
                                length = NumberFormatDetailPane.this.getDetailDocument().getLength();
                            }
                            if (length > 0) {
                                insert = "\n" + result;
                            }
                            try {
                                int max = DsfDebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.debug.ui.max_detail_length");
                                if (max > 0 && insert.length() > max) {
                                    insert = insert.substring(0, max) + "...";
                                }
                                if (DetailJob.this.fFirst) {
                                    NumberFormatDetailPane.this.getDetailDocument().set(insert);
                                    DetailJob.this.fFirst = false;
                                } else {
                                    NumberFormatDetailPane.this.getDetailDocument().replace(length, 0, insert);
                                }
                            }
                            catch (BadLocationException e) {
                                DsfDebugUIPlugin.log(e);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                append.setSystem(true);
                append.schedule();
            }
            detailJob = this;
            synchronized (detailJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    static interface ICursorListener
    extends MouseListener,
    KeyListener {
    }

    private static class PositionLabelValue {
        public int fValue;

        private PositionLabelValue() {
        }

        public String toString() {
            return String.valueOf(this.fValue);
        }
    }
}

