/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.update;

import java.util.List;
import java.util.Stack;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxyExtension;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiLevelUpdateHandler
extends DataRequestMonitor<List<Object>> {
    private final Executor fExecutor;
    private final IElementContentProvider fContentProvider;
    private final IPresentationContext fPresentationContext;
    private final String[] fColumns;
    private final Viewer fViewer;
    private final Object fViewerInput;
    private final Stack<UpdateLevel> fStack = new Stack();
    private final CountingRequestMonitor fRequestMonitor;
    private int fIndex = 0;
    private TreePath fCurrentPath;
    private int fLowIndex = 0;
    private int fHighIndex = 0x7FFFFFFE;
    private int fPendingUpdates;

    public MultiLevelUpdateHandler(Executor executor, IVMModelProxyExtension modelProxy, IPresentationContext presentationContext, IElementContentProvider contentProvider, RequestMonitor parentRequestMonitor) {
        super(executor, null);
        this.fExecutor = executor;
        this.fViewer = modelProxy.getViewer();
        this.fViewerInput = modelProxy.getViewerInput();
        this.fCurrentPath = modelProxy.getRootPath();
        this.fPresentationContext = presentationContext;
        this.fColumns = presentationContext.getColumns();
        this.fContentProvider = contentProvider;
        this.fRequestMonitor = new CountingRequestMonitor(this.fExecutor, parentRequestMonitor);
    }

    void startUpdate() {
        this.fContentProvider.update(new IChildrenUpdate[]{new VMChildrenUpdate(this.fCurrentPath, this.fViewerInput, this.fPresentationContext, this.fLowIndex, this.fHighIndex - this.fLowIndex + 1, this)});
    }

    void setRange(int low, int high) {
        this.fLowIndex = low;
        this.fHighIndex = high;
    }

    boolean isDone() {
        return this.fStack.isEmpty();
    }

    public synchronized void done() {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    List data = (List)MultiLevelUpdateHandler.this.getData();
                    if (data != null && !data.isEmpty()) {
                        MultiLevelUpdateHandler.this.fStack.push(new UpdateLevel(MultiLevelUpdateHandler.this.fCurrentPath, data));
                    }
                    MultiLevelUpdateHandler.this.processNext();
                }

                public String toString() {
                    return "Completed: " + MultiLevelUpdateHandler.this.toString();
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.handleRejectedExecutionException();
        }
    }

    protected void processNext() {
        while (true) {
            IElementLabelProvider labelProvider;
            if (this.fIndex > this.fHighIndex) {
                this.fStack.clear();
            }
            if (this.fStack.isEmpty()) {
                this.fRequestMonitor.setDoneCount(this.fPendingUpdates);
                super.done();
                return;
            }
            UpdateLevel current = this.fStack.peek();
            assert (!current.isDone());
            TreePath path = current.fPath;
            Object data = current.nextChild();
            if (current.isDone()) {
                this.fStack.pop();
            }
            if (data == null) {
                ++this.fIndex;
                continue;
            }
            path = path.createChildPath(data);
            if (this.fIndex >= this.fLowIndex && this.fIndex <= this.fHighIndex && data instanceof IAdaptable && (labelProvider = (IElementLabelProvider)((IAdaptable)data).getAdapter(IElementLabelProvider.class)) != null) {
                ++this.fPendingUpdates;
                labelProvider.update(new ILabelUpdate[]{new DummyLabelUpdate(data, path, (RequestMonitor)this.fRequestMonitor)});
            }
            ++this.fIndex;
            if (!(this.fViewer instanceof TreeViewer)) continue;
            TreeViewer treeViewer = (TreeViewer)this.fViewer;
            if (treeViewer.getExpandedState(data)) {
                this.fCurrentPath = path;
                this.fContentProvider.update(new IChildrenUpdate[]{new VMChildrenUpdate(path, this.fViewerInput, this.fPresentationContext, -1, -1, this)});
                return;
            }
            ++this.fPendingUpdates;
            this.fContentProvider.update(new IHasChildrenUpdate[]{new VMHasChildrenUpdate(path, this.fViewerInput, this.fPresentationContext, (DataRequestMonitor<Boolean>)new DataRequestMonitor(this.fExecutor, (RequestMonitor)this.fRequestMonitor))});
        }
    }

    private final class DummyLabelUpdate
    implements ILabelUpdate {
        private final RequestMonitor fMonitor;
        private final Object fData;
        private final TreePath fPath;

        private DummyLabelUpdate(Object data, TreePath path, RequestMonitor rm) {
            this.fMonitor = rm;
            this.fData = data;
            this.fPath = path;
        }

        public Object getElement() {
            return this.fData;
        }

        public TreePath getElementPath() {
            return this.fPath.createChildPath(this.fData);
        }

        public IPresentationContext getPresentationContext() {
            return MultiLevelUpdateHandler.this.fPresentationContext;
        }

        public Object getViewerInput() {
            return MultiLevelUpdateHandler.this.fViewerInput;
        }

        public void cancel() {
        }

        public IStatus getStatus() {
            return null;
        }

        public boolean isCanceled() {
            return false;
        }

        public void setStatus(IStatus status) {
        }

        public String[] getColumnIds() {
            return MultiLevelUpdateHandler.this.fColumns;
        }

        public void setBackground(RGB arg0, int arg1) {
        }

        public void setFontData(FontData arg0, int arg1) {
        }

        public void setForeground(RGB arg0, int arg1) {
        }

        public void setImageDescriptor(ImageDescriptor arg0, int arg1) {
        }

        public void setLabel(String arg0, int arg1) {
        }

        public void done() {
            this.fMonitor.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UpdateLevel {
        private final List<Object> fChildren;
        private final TreePath fPath;
        private int fChildIndex;

        private UpdateLevel(TreePath path, List<Object> children) {
            this.fPath = path;
            this.fChildren = children;
            this.fChildIndex = 0;
            assert (!this.isDone());
        }

        private boolean isDone() {
            return this.fChildIndex == this.fChildren.size();
        }

        private Object nextChild() {
            if (this.isDone()) {
                return null;
            }
            return this.fChildren.get(this.fChildIndex++);
        }
    }
}

