/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.gdb;

import java.math.BigInteger;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IDisassembly;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IInstruction;
import org.eclipse.dd.dsf.debug.service.IMixedInstruction;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.service.MIDisassembly;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.tests.gdb.framework.AsyncCompletionWaitor;
import org.eclipse.dd.tests.gdb.framework.BackgroundRunner;
import org.eclipse.dd.tests.gdb.framework.BaseTestCase;
import org.eclipse.dd.tests.gdb.framework.SyncUtil;
import org.eclipse.dd.tests.gdb.launching.TestsPlugin;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BackgroundRunner.class)
public class MIDisassemblyTest
extends BaseTestCase {
    private static final String FILE_NAME = "MemoryTestApp.cc";
    private static final int LINE_NUMBER = 35;
    private static final String INVALID_FILE_NAME = "invalid_filename";
    private final AsyncCompletionWaitor fWait = new AsyncCompletionWaitor();
    private DsfSession fSession;
    private DsfServicesTracker fServicesTracker;
    private IDisassembly.IDisassemblyDMContext fDisassemblyDmc;
    private MIDisassembly fDisassembly;
    private IExpressions fExpressionService;

    @BeforeClass
    public static void testSuiteInitialization() {
        MIDisassemblyTest.setLaunchAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "data/launch/bin/MemoryTestApp.exe");
    }

    @AfterClass
    public static void testSuiteCleanup() {
    }

    @Before
    public void testCaseInitialization() {
        this.fSession = this.getGDBLaunch().getSession();
        this.fServicesTracker = new DsfServicesTracker(TestsPlugin.getBundleContext(), this.fSession.getId());
        assert (this.fServicesTracker != null);
        ICommandControlService commandControl = (ICommandControlService)this.fServicesTracker.getService(ICommandControlService.class);
        this.fDisassemblyDmc = (IDisassembly.IDisassemblyDMContext)commandControl.getContext();
        assert (this.fDisassemblyDmc != null);
        this.fDisassembly = (MIDisassembly)this.fServicesTracker.getService(MIDisassembly.class);
        assert (this.fDisassembly != null);
        this.fExpressionService = (IExpressions)this.fServicesTracker.getService(IExpressions.class);
        assert (this.fExpressionService != null);
    }

    @After
    public void testCaseCleanup() {
        this.fExpressionService = null;
        this.fDisassembly = null;
        this.fServicesTracker.dispose();
        this.fServicesTracker = null;
    }

    private IAddress evaluateExpression(String expression) throws Throwable {
        MIStoppedEvent stoppedEvent = this.getInitialStoppedEvent();
        IStack.IFrameDMContext frameDmc = SyncUtil.SyncGetStackFrame((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), 0);
        IExpressions.IExpressionDMContext expressionDMC = SyncUtil.SyncCreateExpression((IDMContext)frameDmc, expression);
        final IFormattedValues.FormattedValueDMContext formattedValueDMC = SyncUtil.SyncGetFormattedValue((IFormattedValues)this.fExpressionService, (IFormattedValues.IFormattedDataDMContext)expressionDMC, "HEX.Format");
        DataRequestMonitor<IFormattedValues.FormattedValueDMData> drm = new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIDisassemblyTest.this.fWait.setReturnInfo(this.getData());
                }
                MIDisassemblyTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIDisassemblyTest.this.fExpressionService.getFormattedExpressionValue(formattedValueDMC, this.val$drm);
            }
        });
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        String result = "";
        Object returnInfo = this.fWait.getReturnInfo();
        if (returnInfo instanceof IFormattedValues.FormattedValueDMData) {
            result = ((IFormattedValues.FormattedValueDMData)returnInfo).getFormattedValue();
        }
        return new Addr64(result);
    }

    private void getInstruction(final IDisassembly.IDisassemblyDMContext dmc, final BigInteger startAddress, final BigInteger endAddress) throws InterruptedException {
        DataRequestMonitor<IInstruction[]> drm = new DataRequestMonitor<IInstruction[]>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIDisassemblyTest.this.fWait.setReturnInfo(this.getData());
                }
                MIDisassemblyTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIDisassemblyTest.this.fDisassembly.getInstructions(dmc, startAddress, endAddress, this.val$drm);
            }
        });
    }

    private void getInstruction(final IDisassembly.IDisassemblyDMContext dmc, final String function, final int linenum, final int count) throws InterruptedException {
        DataRequestMonitor<IInstruction[]> drm = new DataRequestMonitor<IInstruction[]>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIDisassemblyTest.this.fWait.setReturnInfo(this.getData());
                }
                MIDisassemblyTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIDisassemblyTest.this.fDisassembly.getInstructions(dmc, function, linenum, count, this.val$drm);
            }
        });
    }

    private void getMixedInstruction(final IDisassembly.IDisassemblyDMContext dmc, final BigInteger startAddress, final BigInteger endAddress) throws InterruptedException {
        DataRequestMonitor<IMixedInstruction[]> drm = new DataRequestMonitor<IMixedInstruction[]>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIDisassemblyTest.this.fWait.setReturnInfo(this.getData());
                }
                MIDisassemblyTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIDisassemblyTest.this.fDisassembly.getMixedInstructions(dmc, startAddress, endAddress, this.val$drm);
            }
        });
    }

    private void getMixedInstruction(final IDisassembly.IDisassemblyDMContext dmc, final String function, final int linenum, final int count) throws InterruptedException {
        DataRequestMonitor<IMixedInstruction[]> drm = new DataRequestMonitor<IMixedInstruction[]>((Executor)this.fSession.getExecutor(), null){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIDisassemblyTest.this.fWait.setReturnInfo(this.getData());
                }
                MIDisassemblyTest.this.fWait.waitFinished(this.getStatus());
            }
        };
        this.fSession.getExecutor().submit(new Runnable((DataRequestMonitor)drm){
            final /* synthetic */ DataRequestMonitor val$drm;
            {
                this.val$drm = dataRequestMonitor;
            }

            public void run() {
                MIDisassemblyTest.this.fDisassembly.getMixedInstructions(dmc, function, linenum, count, this.val$drm);
            }
        });
    }

    @Test(timeout=20000L)
    public void readWithNullContext() throws Throwable {
        BigInteger startAddress = null;
        BigInteger endAddress = null;
        this.fWait.waitReset();
        this.getInstruction(null, startAddress, endAddress);
        this.fWait.waitUntilDone(0);
        String expected = "Unknown context type";
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
    }

    @Test(timeout=20000L)
    public void readWithInvalidAddress() throws Throwable {
        BigInteger startAddress = BigInteger.ZERO;
        BigInteger endAddress = null;
        this.fWait.waitReset();
        this.getInstruction(this.fDisassemblyDmc, startAddress, endAddress);
        this.fWait.waitUntilDone(0);
        String expected = "Cannot access memory at address";
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
    }

    @Test(timeout=20000L)
    public void readWithNullAddress() throws Throwable {
        BigInteger startAddress = null;
        BigInteger endAddress = null;
        this.fWait.waitReset();
        this.getInstruction(this.fDisassemblyDmc, startAddress, endAddress);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        IInstruction[] result = (IInstruction[])this.fWait.getReturnInfo();
        Assert.assertTrue((String)"No instruction retrieved", (result.length != 0 ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void readWithValidAddress() throws Throwable {
        Addr64 main = (Addr64)this.evaluateExpression("&main");
        BigInteger startAddress = main.getValue();
        BigInteger endAddress = null;
        this.fWait.waitReset();
        this.getInstruction(this.fDisassemblyDmc, startAddress, endAddress);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        IInstruction[] result = (IInstruction[])this.fWait.getReturnInfo();
        Assert.assertTrue((String)"No instruction retrieved", (result.length != 0 ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void readWithValidFunction() throws Throwable {
        String filename = INVALID_FILE_NAME;
        int linenum = 1;
        int count = -1;
        this.fWait.waitReset();
        this.getInstruction(this.fDisassemblyDmc, filename, linenum, count);
        this.fWait.waitUntilDone(0);
        String expected = "Invalid filename";
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
    }

    @Test(timeout=20000L)
    public void readWithInvalidLineNumber() throws Throwable {
        String filename = FILE_NAME;
        int linenum = -1;
        int count = -1;
        this.fWait.waitReset();
        this.getInstruction(this.fDisassemblyDmc, filename, linenum, count);
        this.fWait.waitUntilDone(0);
        String expected = "Invalid line number";
        Assert.assertFalse((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        Assert.assertTrue((String)("Wrong error message: expected '" + expected + "', received '" + this.fWait.getMessage() + "'"), (boolean)this.fWait.getMessage().contains(expected));
    }

    @Test(timeout=20000L)
    public void readWithValidFilename() throws Throwable {
        String filename = FILE_NAME;
        int linenum = 35;
        int count = -1;
        this.fWait.waitReset();
        this.getInstruction(this.fDisassemblyDmc, filename, linenum, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        IInstruction[] result = (IInstruction[])this.fWait.getReturnInfo();
        Assert.assertTrue((String)"No instruction retrieved", (result.length != 0 ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void readWithLineCount() throws Throwable {
        String filename = FILE_NAME;
        int linenum = 35;
        int count = 5;
        this.fWait.waitReset();
        this.getInstruction(this.fDisassemblyDmc, filename, linenum, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        IInstruction[] result = (IInstruction[])this.fWait.getReturnInfo();
        Assert.assertTrue((String)("Wrong number of instructions retrieved, expected " + count + ", got " + result.length), (result.length == count ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void readMixedWithValidAddress() throws Throwable {
        Addr64 main = (Addr64)this.evaluateExpression("&main");
        BigInteger startAddress = main.getValue();
        BigInteger endAddress = null;
        this.fWait.waitReset();
        this.getMixedInstruction(this.fDisassemblyDmc, startAddress, endAddress);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        IMixedInstruction[] result = (IMixedInstruction[])this.fWait.getReturnInfo();
        Assert.assertTrue((String)"No instruction retrieved", (result.length != 0 ? 1 : 0) != 0);
    }

    @Test(timeout=20000L)
    public void readMixedWithLineCount() throws Throwable {
        String filename = FILE_NAME;
        int linenum = 35;
        int count = 5;
        this.fWait.waitReset();
        this.getMixedInstruction(this.fDisassemblyDmc, filename, linenum, count);
        this.fWait.waitUntilDone(0);
        Assert.assertTrue((String)this.fWait.getMessage(), (boolean)this.fWait.isOK());
        IMixedInstruction[] result = (IMixedInstruction[])this.fWait.getReturnInfo();
        int total = 0;
        for (IMixedInstruction mixed : result) {
            IInstruction[] inst = mixed.getInstructions();
            total += inst.length;
        }
        Assert.assertTrue((String)("Wrong number of instructions retrieved, expected " + count + ", got " + result.length), (total == count ? 1 : 0) != 0);
    }
}

