/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.tests.dsf.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.tests.dsf.TestDsfExecutor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DsfSequenceTests {
    TestDsfExecutor fExecutor;

    @Before
    public void startExecutor() throws ExecutionException, InterruptedException {
        this.fExecutor = new TestDsfExecutor();
    }

    @After
    public void shutdownExecutor() throws ExecutionException, InterruptedException {
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                DsfSequenceTests.this.fExecutor.shutdown();
            }
        }).get();
        if (this.fExecutor.exceptionsCaught()) {
            Throwable[] exceptions = this.fExecutor.getExceptions();
            throw new ExecutionException(exceptions[0]);
        }
        this.fExecutor = null;
    }

    @Test
    public void simpleTest() throws InterruptedException, ExecutionException {
        class IntegerHolder {
            int fInteger;

            IntegerHolder() {
            }
        }
        final IntegerHolder stepCounter = new IntegerHolder();
        final Sequence.Step[] steps = new Sequence.Step[]{new Sequence.Step(){
            {
            }

            public void execute(RequestMonitor requestMonitor) {
                ++stepCounter.fInteger;
                requestMonitor.done();
            }
        }, new Sequence.Step(){
            {
            }

            public void execute(RequestMonitor requestMonitor) {
                ++stepCounter.fInteger;
                requestMonitor.done();
            }
        }};
        Sequence sequence = new Sequence((DsfExecutor)this.fExecutor){

            public Sequence.Step[] getSteps() {
                return steps;
            }
        };
        Assert.assertTrue((!sequence.isDone() ? 1 : 0) != 0);
        Assert.assertTrue((!sequence.isCancelled() ? 1 : 0) != 0);
        this.fExecutor.execute((Runnable)sequence);
        sequence.get();
        Assert.assertTrue((stepCounter.fInteger == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sequence.isDone());
        Assert.assertTrue((!sequence.isCancelled() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ExecutionException.class)
    public void rollbackTest() throws InterruptedException, ExecutionException {
        class IntegerHolder {
            int fInteger;

            IntegerHolder() {
            }
        }
        final IntegerHolder stepCounter = new IntegerHolder();
        final IntegerHolder rollBackCounter = new IntegerHolder();
        final Sequence.Step[] steps = new Sequence.Step[]{new Sequence.Step(){
            {
            }

            public void execute(RequestMonitor requestMonitor) {
                ++stepCounter.fInteger;
                requestMonitor.done();
            }

            public void rollBack(RequestMonitor requestMonitor) {
                ++rollBackCounter.fInteger;
                requestMonitor.done();
            }
        }, new Sequence.Step(){
            {
            }

            public void execute(RequestMonitor requestMonitor) {
                ++stepCounter.fInteger;
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.tests.dsf", -1, "", null));
                requestMonitor.done();
            }

            public void rollBack(RequestMonitor requestMonitor) {
                ++rollBackCounter.fInteger;
                requestMonitor.done();
            }
        }};
        Sequence sequence = new Sequence((DsfExecutor)this.fExecutor){

            public Sequence.Step[] getSteps() {
                return steps;
            }
        };
        this.fExecutor.execute((Runnable)sequence);
        try {
            sequence.get();
            Assert.assertTrue((stepCounter.fInteger == 2 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Assert.assertTrue((stepCounter.fInteger == 2 ? 1 : 0) != 0);
            Assert.assertTrue((rollBackCounter.fInteger == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)sequence.isDone());
            Assert.assertTrue((!sequence.isCancelled() ? 1 : 0) != 0);
            throw throwable;
        }
        Assert.assertTrue((rollBackCounter.fInteger == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sequence.isDone());
        Assert.assertTrue((!sequence.isCancelled() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Exception should have been thrown", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ExecutionException.class)
    public void exceptionTest() throws InterruptedException, ExecutionException {
        final Sequence.Step[] steps = new Sequence.Step[]{new Sequence.Step(){

            public void execute(RequestMonitor requestMonitor) {
                throw new Error("Exception part of unit test.");
            }
        }};
        Sequence sequence = new Sequence((DsfExecutor)this.fExecutor){

            public Sequence.Step[] getSteps() {
                return steps;
            }
        };
        this.fExecutor.execute((Runnable)sequence);
        try {
            sequence.get();
        }
        catch (Throwable throwable) {
            Assert.assertTrue((boolean)sequence.isDone());
            Assert.assertTrue((!sequence.isCancelled() ? 1 : 0) != 0);
            throw throwable;
        }
        Assert.assertTrue((boolean)sequence.isDone());
        Assert.assertTrue((!sequence.isCancelled() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Exception should have been thrown", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=CancellationException.class)
    public void cancelBeforeWaitingTest() throws InterruptedException, ExecutionException {
        final Sequence.Step[] steps = new Sequence.Step[]{new Sequence.Step(){

            public void execute(RequestMonitor requestMonitor) {
                Assert.assertTrue((String)"Sequence was cancelled, it should not be called.", (boolean)false);
            }
        }};
        Sequence sequence = new Sequence((DsfExecutor)this.fExecutor){

            public Sequence.Step[] getSteps() {
                return steps;
            }
        };
        sequence.cancel(false);
        Assert.assertTrue((!sequence.isDone() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sequence.isCancelled());
        this.fExecutor.execute((Runnable)sequence);
        try {
            sequence.get();
        }
        finally {
            Assert.assertTrue((boolean)sequence.isDone());
            Assert.assertTrue((boolean)sequence.isCancelled());
        }
        Assert.assertTrue((String)"CancellationException should have been thrown", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=CancellationException.class)
    public void cancelFromStepTest() throws InterruptedException, ExecutionException {
        class IntegerHolder {
            int fInteger;

            IntegerHolder() {
            }
        }
        final IntegerHolder stepCounter = new IntegerHolder();
        final IntegerHolder rollBackCounter = new IntegerHolder();
        final Sequence.Step[] steps = new Sequence.Step[]{new Sequence.Step(){
            {
            }

            public void execute(RequestMonitor requestMonitor) {
                ++stepCounter.fInteger;
                requestMonitor.done();
            }

            public void rollBack(RequestMonitor requestMonitor) {
                ++rollBackCounter.fInteger;
                requestMonitor.done();
            }
        }, new Sequence.Step(){
            {
            }

            public void execute(RequestMonitor requestMonitor) {
                ++stepCounter.fInteger;
                this.getSequence().cancel(false);
                requestMonitor.done();
            }

            public void rollBack(RequestMonitor requestMonitor) {
                ++rollBackCounter.fInteger;
                requestMonitor.done();
            }
        }};
        Sequence sequence = new Sequence((DsfExecutor)this.fExecutor){

            public Sequence.Step[] getSteps() {
                return steps;
            }
        };
        this.fExecutor.schedule((Runnable)sequence, 1L, TimeUnit.MILLISECONDS);
        try {
            sequence.get();
            Assert.assertTrue((stepCounter.fInteger == 2 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Assert.assertTrue((stepCounter.fInteger == 2 ? 1 : 0) != 0);
            Assert.assertTrue((rollBackCounter.fInteger == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)sequence.isDone());
            Assert.assertTrue((boolean)sequence.isCancelled());
            throw throwable;
        }
        Assert.assertTrue((rollBackCounter.fInteger == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)sequence.isDone());
        Assert.assertTrue((boolean)sequence.isCancelled());
        Assert.assertTrue((String)"CancellationException should have been thrown", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=CancellationException.class)
    public void cancelBeforeWithProgressManagerTest() throws InterruptedException, ExecutionException {
        final Sequence.Step[] steps = new Sequence.Step[]{new Sequence.Step(){

            public void execute(RequestMonitor requestMonitor) {
                Assert.assertTrue((String)"Sequence was cancelled, it should not be called.", (boolean)false);
            }
        }};
        NullProgressMonitor pm = new NullProgressMonitor();
        Sequence sequence = new Sequence((DsfExecutor)this.fExecutor, (IProgressMonitor)pm, "", "", null){

            public Sequence.Step[] getSteps() {
                return steps;
            }
        };
        pm.setCanceled(true);
        this.fExecutor.execute((Runnable)sequence);
        try {
            sequence.get();
        }
        finally {
            Assert.assertTrue((boolean)sequence.isDone());
            Assert.assertTrue((boolean)sequence.isCancelled());
        }
    }
}

