/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.memory.renderings.traditional;

import java.math.BigInteger;
import org.eclipse.dd.debug.memory.renderings.traditional.Rendering;
import org.eclipse.dd.debug.memory.renderings.traditional.TraditionalRenderingMessages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

class CopyAction
extends Action {
    private Rendering fRendering;

    public CopyAction(Rendering rendering) {
        this.fRendering = rendering;
        this.setText(DebugUIMessages.CopyViewToClipboardAction_title);
        this.setToolTipText(DebugUIMessages.CopyViewToClipboardAction_tooltip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_ELCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_LCL_COPY_VIEW_TO_CLIPBOARD"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_DLCL_COPY_VIEW_TO_CLIPBOARD"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int COLUMNS = 80;
        String PANE_SPACING = "  ";
        Clipboard clip = null;
        try {
            clip = new Clipboard(this.fRendering.getDisplay());
            BigInteger start = this.fRendering.getSelection().getStart();
            BigInteger end = this.fRendering.getSelection().getEnd();
            if (end == null) {
                return;
            }
            if (start.compareTo(end) > 0) {
                BigInteger bigI = end;
                end = start;
                start = bigI;
            }
            int radix = this.fRendering.getRadix();
            int bytesPerColumn = this.fRendering.getBytesPerColumn();
            boolean isLittleEndian = this.fRendering.isLittleEndian();
            int bytesPerCharacter = this.fRendering.getBytesPerCharacter();
            int addressWidth = this.fRendering.getAddressString(start).length();
            int binaryCellWidth = this.fRendering.getRadixCharacterCount(radix, bytesPerColumn) + 1;
            int asciiCellWidth = this.fRendering.getBytesPerColumn() / this.fRendering.getBytesPerCharacter();
            int combindCellWidths = (this.fRendering.getPaneVisible(2) ? binaryCellWidth : 0) + (this.fRendering.getPaneVisible(3) ? asciiCellWidth : 0);
            int availableWidth = 80;
            if (this.fRendering.getPaneVisible(1)) {
                availableWidth -= addressWidth;
                availableWidth -= "  ".length();
            }
            if (this.fRendering.getPaneVisible(2) && this.fRendering.getPaneVisible(3)) {
                availableWidth -= "  ".length();
            }
            int columns = availableWidth / combindCellWidths;
            BigInteger lengthToRead = end.subtract(start);
            int rows = lengthToRead.divide(BigInteger.valueOf(columns * bytesPerColumn)).intValue();
            if (rows * columns * bytesPerColumn < lengthToRead.intValue()) {
                ++rows;
            }
            StringBuffer buffer = new StringBuffer();
            for (int row = 0; row < rows; ++row) {
                MemoryByte[] bytes;
                BigInteger cellAddress;
                int col;
                BigInteger rowAddress = start.add(BigInteger.valueOf(row * columns * bytesPerColumn));
                if (this.fRendering.getPaneVisible(1)) {
                    buffer.append(this.fRendering.getAddressString(rowAddress));
                    buffer.append("  ");
                }
                if (this.fRendering.getPaneVisible(2)) {
                    for (col = 0; col < columns; ++col) {
                        cellAddress = rowAddress.add(BigInteger.valueOf(col * bytesPerColumn));
                        if (cellAddress.compareTo(end) < 0) {
                            try {
                                bytes = this.fRendering.getBytes(cellAddress, bytesPerColumn);
                                buffer.append(this.fRendering.getRadixText(bytes, radix, isLittleEndian));
                            }
                            catch (DebugException de) {
                                this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_COPY_OPERATION"), (Exception)((Object)de));
                                if (clip != null) {
                                    clip.dispose();
                                }
                                return;
                            }
                        } else {
                            for (int i = this.fRendering.getRadixCharacterCount(radix, bytesPerColumn); i > 0; --i) {
                                buffer.append(' ');
                            }
                        }
                        if (col == columns - 1) continue;
                        buffer.append(' ');
                    }
                }
                if (this.fRendering.getPaneVisible(2) && this.fRendering.getPaneVisible(3)) {
                    buffer.append("  ");
                }
                if (this.fRendering.getPaneVisible(3)) {
                    for (col = 0; col < columns; ++col) {
                        cellAddress = rowAddress.add(BigInteger.valueOf(col * this.fRendering.getBytesPerColumn()));
                        if (cellAddress.compareTo(end) >= 0) continue;
                        try {
                            bytes = this.fRendering.getBytes(cellAddress, this.fRendering.getBytesPerColumn());
                            buffer.append(this.fRendering.formatText(bytes, isLittleEndian, this.fRendering.getTextMode()));
                            continue;
                        }
                        catch (DebugException de) {
                            this.fRendering.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_COPY_OPERATION"), (Exception)((Object)de));
                            if (clip != null) {
                                clip.dispose();
                            }
                            return;
                        }
                    }
                }
                buffer.append("\n");
            }
            if (buffer.length() > 0) {
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                clip.setContents(new Object[]{buffer.toString()}, new Transfer[]{plainTextTransfer});
            }
        }
        finally {
            if (clip != null) {
                clip.dispose();
            }
        }
    }
}

