/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.memory.renderings.actions;

import java.io.File;
import java.math.BigInteger;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ImportMemoryDialog
extends SelectionDialog {
    private Combo formatCombo;
    private IMemoryBlock fMemoryBlock;
    private Text startText;
    private Text fileText;
    private Button comboRestoreToThisAddress;
    private Button comboRestoreToFileAddress;

    public ImportMemoryDialog(Shell parent, IMemoryBlock memoryBlock) {
        super(parent);
        super.setTitle("Download to Memory");
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMemoryBlock = memoryBlock;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (results != null) {
            return results;
        }
        return new Object[0];
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        this.setSelectionResult(new Object[]{this.getFormat(), new Boolean(this.comboRestoreToThisAddress.getSelection()), this.getStartAddress(), this.getFile()});
        super.okPressed();
    }

    public String getFormat() {
        return this.formatCombo.getItem(this.formatCombo.getSelectionIndex());
    }

    public BigInteger getStartAddress() {
        String text = this.startText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    public File getFile() {
        return new File(this.fileText.getText());
    }

    private void validate() {
        boolean isValid = true;
        try {
            this.getStartAddress();
        }
        catch (Exception e) {
            isValid = false;
        }
        this.getButton(0).setEnabled(isValid);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, DebugUIPlugin.getUniqueIdentifier() + ".AddMemoryRenderingDialog_context");
        Composite composite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label textLabel = new Label(composite, 0);
        textLabel.setText("Format: ");
        this.formatCombo = new Combo(composite, 2056);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.formatCombo, 0, 0x1000000);
        textLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)textLabel);
        this.formatCombo.setLayoutData((Object)data);
        this.formatCombo.setItems(new String[]{"S-Record"});
        this.formatCombo.select(0);
        this.comboRestoreToFileAddress = new Button(composite, 16);
        this.comboRestoreToFileAddress.setText("Restore to address specified in the file");
        data = new FormData();
        data.top = new FormAttachment((Control)this.formatCombo);
        this.comboRestoreToFileAddress.setLayoutData((Object)data);
        this.comboRestoreToThisAddress = new Button(composite, 16);
        this.comboRestoreToThisAddress.setText("Restore to this address: ");
        data = new FormData();
        data.top = new FormAttachment((Control)this.comboRestoreToFileAddress);
        this.comboRestoreToThisAddress.setLayoutData((Object)data);
        this.startText = new Text(composite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.comboRestoreToFileAddress);
        data.left = new FormAttachment((Control)this.comboRestoreToThisAddress);
        data.width = 100;
        this.startText.setLayoutData((Object)data);
        Label fileLabel = new Label(composite, 0);
        this.fileText = new Text(composite, 0);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText("File name: ");
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fileText.setLayoutData((Object)data);
        fileButton.setText("Browse...");
        data = new FormData();
        data.top = new FormAttachment((Control)this.startText);
        data.left = new FormAttachment((Control)this.fileText);
        fileButton.setLayoutData((Object)data);
        try {
            BigInteger startAddress = null;
            startAddress = this.fMemoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() : BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
            this.startText.setText("0x" + startAddress.toString(16));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ImportMemoryDialog.this.getShell(), 8192);
                dialog.setText("Choose memory export file");
                dialog.setFilterExtensions(new String[]{"*.*"});
                dialog.setFilterNames(new String[]{"All Files (*.*)"});
                dialog.setFileName(ImportMemoryDialog.this.fileText.getText());
                dialog.open();
                if (dialog.getFileName() != null) {
                    ImportMemoryDialog.this.fileText.setText(dialog.getFilterPath() + File.separator + dialog.getFileName());
                }
                ImportMemoryDialog.this.validate();
            }
        });
        this.startText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                try {
                    ImportMemoryDialog.this.getStartAddress();
                }
                catch (Exception ex) {
                    valid = false;
                }
                ImportMemoryDialog.this.startText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                ImportMemoryDialog.this.validate();
            }
        });
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportMemoryDialog.this.validate();
            }
        });
        return composite;
    }
}

