/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.memory.renderings.actions;

import java.math.BigInteger;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.debug.memory.renderings.actions.Messages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FindReplaceDialog
extends SelectionDialog {
    private IMemoryBlockExtension fMemoryBlock;
    static final int preFetchSize = 10240;
    private Text findText;
    private Text replaceText;
    private Combo startText;
    private Combo endText;
    private Button findButton;
    private Button replaceButton;
    private Button replaceFindButton;
    private Button replaceAllButton;
    private Button closeButton;
    private MemoryView fMemoryView;
    Button formatAsciiButton;
    Button formatHexButton;
    Button formatOctalButton;
    Button formatBinaryButton;
    Button formatDecimalButton;
    Button formatByteSequenceButton;
    Button caseInSensitiveCheckbox;
    Button forwardButton;

    public FindReplaceDialog(Shell parent, IMemoryBlockExtension memoryBlock, MemoryView memoryView) {
        super(parent);
        super.setTitle(Messages.getString("FindReplaceDialog.Title"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMemoryBlock = memoryBlock;
        this.fMemoryView = memoryView;
        this.setBlockOnOpen(false);
    }

    private BigInteger getUserStart() {
        String start = this.startText.getText();
        if (start.toUpperCase().startsWith("0X")) {
            start = start.substring(2);
        }
        return new BigInteger(start, 16);
    }

    private BigInteger getUserEnd() {
        String end = this.endText.getText();
        if (end.toUpperCase().startsWith("0X")) {
            end = end.substring(2);
        }
        return new BigInteger(end, 16);
    }

    private boolean getIsDirectionForward() {
        return this.forwardButton.getSelection();
    }

    private SearchPhrase getSearchPhrase() {
        SearchPhrase phrase = null;
        if (this.formatAsciiButton.getSelection()) {
            phrase = new AsciiSearchPhrase(this.findText.getText(), this.caseInSensitiveCheckbox.getSelection());
        } else if (this.formatHexButton.getSelection()) {
            phrase = new BigIntegerSearchPhrase(new BigInteger(this.findText.getText().toUpperCase().startsWith("0X") ? this.findText.getText().substring(2) : this.findText.getText(), 16), 16);
        } else if (this.formatOctalButton.getSelection()) {
            phrase = new BigIntegerSearchPhrase(new BigInteger(this.findText.getText().startsWith("0") ? this.findText.getText().substring(1) : this.findText.getText(), 8), 8);
        } else if (this.formatBinaryButton.getSelection()) {
            phrase = new BigIntegerSearchPhrase(new BigInteger(this.findText.getText().toUpperCase().startsWith("0B") ? this.findText.getText().substring(2) : this.findText.getText(), 2), 2);
        } else if (this.formatDecimalButton.getSelection()) {
            phrase = new BigIntegerSearchPhrase(new BigInteger(this.findText.getText(), 10), 10);
        } else if (this.formatByteSequenceButton.getSelection()) {
            phrase = new ByteSequenceSearchPhrase(this.findText.getText());
        }
        return phrase;
    }

    protected byte[] parseByteSequence(String s) {
        Vector<Byte> sequence = new Vector<Byte>();
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).trim();
            if (element.length() <= 0) continue;
            BigInteger value = element.toUpperCase().startsWith("0X") ? new BigInteger(element.substring(2), 16) : new BigInteger(element, 10);
            Byte b = new Byte(value.byteValue());
            if (value.compareTo(BigInteger.valueOf(255L)) > 0) {
                return null;
            }
            sequence.addElement(b);
        }
        Byte[] seq = sequence.toArray(new Byte[sequence.size()]);
        byte[] bytes = new byte[seq.length];
        for (int i = 0; i < seq.length; ++i) {
            bytes[i] = seq[i];
        }
        return bytes;
    }

    private byte[] getReplaceData() {
        if (this.formatAsciiButton.getSelection()) {
            return this.replaceText.getText().getBytes();
        }
        if (this.formatHexButton.getSelection()) {
            return this.removeZeroPrefixByte(new BigInteger(this.replaceText.getText().toUpperCase().startsWith("0X") ? this.replaceText.getText().substring(2) : this.replaceText.getText(), 16).toByteArray());
        }
        if (this.formatOctalButton.getSelection()) {
            return this.removeZeroPrefixByte(new BigInteger(this.replaceText.getText().startsWith("0") ? this.replaceText.getText().substring(1) : this.replaceText.getText(), 8).toByteArray());
        }
        if (this.formatBinaryButton.getSelection()) {
            return this.removeZeroPrefixByte(new BigInteger(this.replaceText.getText().toUpperCase().startsWith("0B") ? this.replaceText.getText().substring(2) : this.replaceText.getText(), 2).toByteArray());
        }
        if (this.formatDecimalButton.getSelection()) {
            return this.removeZeroPrefixByte(new BigInteger(this.replaceText.getText(), 10).toByteArray());
        }
        if (this.formatByteSequenceButton.getSelection()) {
            return this.parseByteSequence(this.replaceText.getText());
        }
        return new byte[0];
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.findButton = this.createButton(parent, 10, Messages.getString("FindReplaceDialog.ButtonFind"), true);
        this.findButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performFind(FindReplaceDialog.this.getUserStart(), FindReplaceDialog.this.getUserEnd(), FindReplaceDialog.this.getSearchPhrase(), FindReplaceDialog.this.getIsDirectionForward(), null, false, false);
                FindReplaceDialog.this.cancelPressed();
            }
        });
        this.replaceFindButton = this.createButton(parent, 11, Messages.getString("FindReplaceDialog.ButtonReplaceFind"), false);
        this.replaceFindButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performFind(FindReplaceDialog.this.getUserStart(), FindReplaceDialog.this.getUserEnd(), FindReplaceDialog.this.getSearchPhrase(), FindReplaceDialog.this.getIsDirectionForward(), FindReplaceDialog.this.getReplaceData(), false, true);
                FindReplaceDialog.this.cancelPressed();
            }
        });
        this.replaceButton = this.createButton(parent, 12, Messages.getString("FindReplaceDialog.ButtonReplace"), false);
        this.replaceButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performFind(FindReplaceDialog.this.getUserStart(), FindReplaceDialog.this.getUserEnd(), FindReplaceDialog.this.getSearchPhrase(), FindReplaceDialog.this.getIsDirectionForward(), FindReplaceDialog.this.getReplaceData(), false, false);
                FindReplaceDialog.this.cancelPressed();
            }
        });
        this.replaceAllButton = this.createButton(parent, 13, Messages.getString("FindReplaceDialog.ButtonReplaceAll"), false);
        this.replaceAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performFind(FindReplaceDialog.this.getUserStart(), FindReplaceDialog.this.getUserEnd(), FindReplaceDialog.this.getSearchPhrase(), FindReplaceDialog.this.getIsDirectionForward(), FindReplaceDialog.this.getReplaceData(), true, false);
                FindReplaceDialog.this.cancelPressed();
            }
        });
        this.closeButton = this.createButton(parent, 1, Messages.getString("FindReplaceDialog.Close"), false);
        ((GridLayout)parent.getLayout()).numColumns = 2;
        this.validate();
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (results != null) {
            return results;
        }
        return new Object[0];
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        this.setSelectionResult(new Object[0]);
        super.okPressed();
    }

    public BigInteger getEndAddress() {
        String text = this.endText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger endAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return endAddress;
    }

    public BigInteger getStartAddress() {
        String text = this.startText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    private void validate() {
        boolean valid = false;
        boolean replaceValid = false;
        try {
            BigInteger endAddress = this.getEndAddress();
            BigInteger startAddress = this.getStartAddress();
            if (this.getSearchPhrase() != null && this.getSearchPhrase().getByteLength() > 0) {
                valid = true;
            }
            if (this.getReplaceData() != null && this.getReplaceData().length > 0) {
                replaceValid = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.findButton.setEnabled(valid);
        this.replaceButton.setEnabled(replaceValid);
        this.replaceFindButton.setEnabled(replaceValid);
        this.replaceAllButton.setEnabled(replaceValid);
    }

    private String pad(int characterCount, String value) {
        StringBuffer sb = new StringBuffer(value);
        for (int i = 0; i < characterCount - value.length(); ++i) {
            sb.insert(0, "0");
        }
        return sb.toString();
    }

    private String[] removeNullElements(String[] strings) {
        Vector<String> nonNullStrings = new Vector<String>();
        for (String string : strings) {
            if (string == null) continue;
            nonNullStrings.addElement(string);
        }
        return nonNullStrings.toArray(new String[0]);
    }

    private String getMemoryBlockBaseAddress() {
        BigInteger base = null;
        try {
            base = this.fMemoryBlock.getBigBaseAddress();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (base == null) {
            base = BigInteger.ZERO;
        }
        return "0x" + this.pad(this.getAddressSize() * 2, base.toString(16).toUpperCase());
    }

    private String getViewportStart() {
        ISelection selection = this.fMemoryView.getViewPane("org.eclipse.debug.ui.MemoryView.RenderingViewPane.1").getSelectionProvider().getSelection();
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof IRepositionableMemoryRendering) {
            ((IRepositionableMemoryRendering)((StructuredSelection)selection).getFirstElement()).getSelectedAddress();
        }
        return null;
    }

    private String getStart() {
        BigInteger start = null;
        try {
            start = this.fMemoryBlock.getMemoryBlockStartAddress();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (start == null) {
            start = BigInteger.ZERO;
        }
        return "0x" + this.pad(this.getAddressSize() * 2, start.toString(16).toUpperCase());
    }

    private String getEnd() {
        BigInteger end = null;
        try {
            end = this.fMemoryBlock.getMemoryBlockEndAddress();
        }
        catch (DebugException de) {
            // empty catch block
        }
        if (end == null) {
            end = BigInteger.ZERO;
            for (int i = this.getAddressSize(); i > 0; --i) {
                end = end.shiftLeft(8);
                end = end.or(BigInteger.valueOf(255L));
            }
        }
        return "0x" + this.pad(this.getAddressSize() * 2, end.toString(16).toUpperCase());
    }

    private int getAddressSize() {
        int addressSize;
        try {
            addressSize = this.fMemoryBlock.getAddressSize();
        }
        catch (DebugException de) {
            addressSize = 4;
        }
        return addressSize;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, DebugUIPlugin.getUniqueIdentifier() + ".AddMemoryRenderingDialog_context");
        Composite composite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label findLabel = new Label(composite, 0);
        Label replaceLabel = new Label(composite, 0);
        this.replaceText = new Text(composite, 2048);
        findLabel.setText(Messages.getString("FindReplaceDialog.LabelFind"));
        this.findText = new Text(composite, 2048);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.replaceText, 0, 16384);
        data.width = 260;
        this.findText.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.findText, 0, 0x1000000);
        findLabel.setLayoutData((Object)data);
        replaceLabel.setText(Messages.getString("FindReplaceDialog.LabelReplaceWith"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.findText);
        replaceLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)replaceLabel, 0, 0x1000000);
        data.left = new FormAttachment((Control)replaceLabel);
        data.width = 260;
        this.replaceText.setLayoutData((Object)data);
        Group directionGroup = new Group(composite, 0);
        Group formatGroup = new Group(composite, 0);
        Group rangeGroup = new Group(composite, 0);
        directionGroup.setText(Messages.getString("FindReplaceDialog.LabelDirection"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        directionGroup.setLayout((Layout)layout);
        this.forwardButton = new Button((Composite)directionGroup, 16);
        this.forwardButton.setText(Messages.getString("FindReplaceDialog.ButtonForward"));
        Button backwardButton = new Button((Composite)directionGroup, 16);
        backwardButton.setText(Messages.getString("FindReplaceDialog.ButtonBackward"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.replaceText);
        data.right = new FormAttachment((Control)formatGroup, 0, 131072);
        data.left = new FormAttachment((Control)formatGroup, 0, 16384);
        data.bottom = new FormAttachment((Control)rangeGroup, 0, 1024);
        directionGroup.setLayoutData((Object)data);
        rangeGroup.setText(Messages.getString("FindReplaceDialog.LabelRange"));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        rangeGroup.setLayout((Layout)layout);
        Label startLabel = new Label((Composite)rangeGroup, 0);
        startLabel.setText(Messages.getString("FindReplaceDialog.LabelStartAddress"));
        this.startText = new Combo((Composite)rangeGroup, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.grabExcessHorizontalSpace = true;
        this.startText.setLayoutData((Object)gridData);
        Label endLabel = new Label((Composite)rangeGroup, 0);
        endLabel.setText(Messages.getString("FindReplaceDialog.LabelEndAddress"));
        this.endText = new Combo((Composite)rangeGroup, 2048);
        gridData = new GridData();
        gridData.widthHint = 200;
        gridData.grabExcessHorizontalSpace = true;
        this.endText.setLayoutData((Object)gridData);
        data = new FormData();
        data.left = new FormAttachment((Control)directionGroup);
        data.top = new FormAttachment((Control)directionGroup, 0, 128);
        data.right = new FormAttachment((Control)this.findText, 0, 131072);
        rangeGroup.setLayoutData((Object)data);
        this.startText.setItems(this.removeNullElements(new String[]{this.getViewportStart(), this.getStart(), this.getEnd(), this.getMemoryBlockBaseAddress()}));
        this.endText.setItems(this.removeNullElements(new String[]{this.getEnd(), this.getStart(), this.getMemoryBlockBaseAddress(), this.getViewportStart()}));
        this.startText.select(0);
        this.endText.select(0);
        formatGroup.setText(Messages.getString("FindReplaceDialog.LabelFormat"));
        layout = new GridLayout();
        layout.numColumns = 1;
        formatGroup.setLayout((Layout)layout);
        this.formatAsciiButton = new Button((Composite)formatGroup, 16);
        this.formatAsciiButton.setText(Messages.getString("FindReplaceDialog.ButtonASCII"));
        this.formatHexButton = new Button((Composite)formatGroup, 16);
        this.formatHexButton.setText(Messages.getString("FindReplaceDialog.ButtonHexadecimal"));
        this.formatOctalButton = new Button((Composite)formatGroup, 16);
        this.formatOctalButton.setText(Messages.getString("FindReplaceDialog.ButtonOctal"));
        this.formatBinaryButton = new Button((Composite)formatGroup, 16);
        this.formatBinaryButton.setText(Messages.getString("FindReplaceDialog.ButtonBinary"));
        this.formatDecimalButton = new Button((Composite)formatGroup, 16);
        this.formatDecimalButton.setText(Messages.getString("FindReplaceDialog.ButtonDecimal"));
        this.formatByteSequenceButton = new Button((Composite)formatGroup, 16);
        this.formatByteSequenceButton.setText(Messages.getString("FindReplaceDialog.ButtonByteSequence"));
        data = new FormData();
        data.top = new FormAttachment((Control)rangeGroup);
        formatGroup.setLayoutData((Object)data);
        Group optionsGroup = new Group(composite, 0);
        optionsGroup.setText(Messages.getString("FindReplaceDialog.LabelOptions"));
        data = new FormData();
        data.left = new FormAttachment((Control)formatGroup);
        data.top = new FormAttachment((Control)rangeGroup);
        data.bottom = new FormAttachment((Control)formatGroup, 0, 1024);
        data.right = new FormAttachment((Control)rangeGroup, 0, 131072);
        optionsGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        optionsGroup.setLayout((Layout)layout);
        Button wrapCheckbox = new Button((Composite)optionsGroup, 32);
        wrapCheckbox.setText(Messages.getString("FindReplaceDialog.ButtonWrapSearch"));
        wrapCheckbox.setEnabled(false);
        this.caseInSensitiveCheckbox = new Button((Composite)optionsGroup, 32);
        this.caseInSensitiveCheckbox.setText(Messages.getString("FindReplaceDialog.ButtonCaseInsensitive"));
        this.formatAsciiButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.caseInSensitiveCheckbox.setEnabled(true);
            }
        });
        SelectionListener nonAsciiListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.caseInSensitiveCheckbox.setEnabled(false);
            }
        };
        this.formatHexButton.addSelectionListener(nonAsciiListener);
        this.formatOctalButton.addSelectionListener(nonAsciiListener);
        this.formatBinaryButton.addSelectionListener(nonAsciiListener);
        this.formatDecimalButton.addSelectionListener(nonAsciiListener);
        this.formatByteSequenceButton.addSelectionListener(nonAsciiListener);
        this.startText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                try {
                    FindReplaceDialog.this.getStartAddress();
                }
                catch (Exception ex) {
                    valid = false;
                }
                FindReplaceDialog.this.startText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                FindReplaceDialog.this.validate();
            }
        });
        this.endText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    FindReplaceDialog.this.getEndAddress();
                    FindReplaceDialog.this.endText.setForeground(Display.getDefault().getSystemColor(2));
                }
                catch (Exception ex) {
                    FindReplaceDialog.this.endText.setForeground(Display.getDefault().getSystemColor(3));
                }
                FindReplaceDialog.this.validate();
            }
        });
        this.findText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindReplaceDialog.this.validate();
            }
        });
        this.replaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindReplaceDialog.this.validate();
            }
        });
        this.forwardButton.setSelection(true);
        this.formatAsciiButton.setSelection(true);
        composite.setTabList(new Control[]{this.findText, this.replaceText, directionGroup, rangeGroup, formatGroup, optionsGroup});
        this.findText.setFocus();
        return composite;
    }

    MemoryByte[] getBytesFromAddress(BigInteger address, int length, FindReplaceMemoryCache cache) throws DebugException {
        if (address.compareTo(cache.memoryCacheStartAddress) < 0 || address.add(BigInteger.valueOf(length)).compareTo(cache.memoryCacheStartAddress.add(BigInteger.valueOf(cache.memoryCacheData.length))) >= 0) {
            BigInteger fetchAddress = address.subtract(BigInteger.valueOf(10240L));
            if (fetchAddress.compareTo(BigInteger.ZERO) < 0) {
                fetchAddress = BigInteger.ZERO;
            }
            MemoryByte[] bytes = this.fMemoryBlock.getBytesFromAddress(fetchAddress, 20480L);
            cache.memoryCacheStartAddress = fetchAddress;
            cache.memoryCacheData = bytes;
        }
        MemoryByte[] bytes = new MemoryByte[length];
        System.arraycopy(cache.memoryCacheData, address.subtract(cache.memoryCacheStartAddress).intValue(), bytes, 0, length);
        return bytes;
    }

    private void performFind(final BigInteger start, final BigInteger end, final SearchPhrase searchPhrase, final boolean searchForward, final byte[] replaceData, final boolean isReplaceAll, final boolean replaceThenFind) {
        Job job = new Job("Searching memory for " + searchPhrase){

            public IStatus run(IProgressMonitor monitor) {
                ISelection selection;
                BigInteger searchPhraseLength = BigInteger.valueOf(searchPhrase.getByteLength());
                BigInteger range = searchForward ? end.subtract(start) : start.subtract(end);
                BigInteger currentPosition = start;
                boolean isReplace = replaceData != null;
                BigInteger jobs = range.subtract(searchPhraseLength);
                BigInteger factor = BigInteger.ONE;
                if (jobs.compareTo(BigInteger.valueOf(0x7FFFFFFL)) > 0) {
                    factor = jobs.divide(BigInteger.valueOf(0x7FFFFFFL));
                    jobs = jobs.divide(factor);
                }
                BigInteger jobCount = BigInteger.ZERO;
                BigInteger replaceCount = BigInteger.ZERO;
                FindReplaceMemoryCache cache = new FindReplaceMemoryCache();
                monitor.beginTask(Messages.getString("FindReplaceDialog.SearchingMemoryFor") + searchPhrase, jobs.intValue());
                boolean matched = false;
                while (!matched && (searchForward && currentPosition.compareTo(end.subtract(searchPhraseLength)) < 0 || !searchForward && currentPosition.compareTo(end) > 0) && !monitor.isCanceled()) {
                    try {
                        MemoryByte[] bytes = FindReplaceDialog.this.getBytesFromAddress(currentPosition, searchPhraseLength.intValue(), cache);
                        matched = searchPhrase.isMatch(bytes);
                    }
                    catch (DebugException e) {
                        // empty catch block
                    }
                    if (!matched) {
                        currentPosition = searchForward ? currentPosition.add(BigInteger.ONE) : currentPosition.subtract(BigInteger.ONE);
                    }
                    if ((jobCount = jobCount.add(BigInteger.ONE)).compareTo(factor) == 0) {
                        jobCount = BigInteger.ZERO;
                        monitor.worked(1);
                    }
                    if (!matched) continue;
                    if (isReplace) {
                        try {
                            FindReplaceDialog.this.fMemoryBlock.setValue(currentPosition.subtract(FindReplaceDialog.this.fMemoryBlock.getBigBaseAddress()), replaceData);
                        }
                        catch (DebugException de) {
                            // empty catch block
                        }
                        replaceCount = replaceCount.add(BigInteger.ONE);
                    }
                    if (isReplace && replaceThenFind && replaceCount.compareTo(BigInteger.ONE) == 0) {
                        isReplace = false;
                        matched = false;
                        currentPosition = searchForward ? currentPosition.add(BigInteger.ONE) : currentPosition.subtract(BigInteger.ONE);
                    }
                    if (!isReplaceAll) continue;
                    matched = false;
                    if (searchForward) {
                        currentPosition = currentPosition.add(BigInteger.ONE);
                        continue;
                    }
                    currentPosition = currentPosition.subtract(BigInteger.ONE);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (matched && (selection = FindReplaceDialog.this.fMemoryView.getViewPane("org.eclipse.debug.ui.MemoryView.RenderingViewPane.1").getSelectionProvider().getSelection()) instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof IRepositionableMemoryRendering) {
                    try {
                        ((IRepositionableMemoryRendering)((StructuredSelection)selection).getFirstElement()).goToAddress(currentPosition);
                    }
                    catch (DebugException de) {
                        // empty catch block
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private byte[] removeZeroPrefixByte(byte[] bytes) {
        if (bytes[0] != 0 || bytes.length == 1) {
            return bytes;
        }
        byte[] processedBytes = new byte[bytes.length - 1];
        System.arraycopy(bytes, 1, processedBytes, 0, processedBytes.length);
        return processedBytes;
    }

    class AsciiSearchPhrase
    implements SearchPhrase {
        private String fPhrase;
        private boolean fIsCaseInsensitive;

        public AsciiSearchPhrase(String phrase, boolean isCaseInsensitive) {
            this.fPhrase = phrase;
            this.fIsCaseInsensitive = isCaseInsensitive;
        }

        public int getByteLength() {
            return this.fPhrase.length();
        }

        public String toString() {
            return this.fPhrase;
        }

        public boolean isMatch(MemoryByte[] bytes) {
            byte[] targetBytes = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                targetBytes[i] = bytes[i].getValue();
            }
            String searchString = this.fPhrase;
            String targetString = new String(targetBytes);
            if (this.fIsCaseInsensitive) {
                searchString = searchString.toUpperCase();
                targetString = targetString.toUpperCase();
            }
            return searchString.equals(targetString);
        }
    }

    class BigIntegerSearchPhrase
    implements SearchPhrase {
        private BigInteger fPhrase;
        private int fRadix;

        public BigIntegerSearchPhrase(BigInteger phrase, int radix) {
            this.fPhrase = phrase;
            this.fRadix = radix;
        }

        public int getByteLength() {
            return FindReplaceDialog.this.removeZeroPrefixByte(this.fPhrase.toByteArray()).length;
        }

        public String toString() {
            return this.fPhrase.toString(this.fRadix);
        }

        public boolean isMatch(MemoryByte[] bytes) {
            byte[] targetBytes = new byte[bytes.length + 1];
            targetBytes[0] = 0;
            for (int i = 0; i < bytes.length; ++i) {
                targetBytes[i + 1] = bytes[i].getValue();
            }
            BigInteger targetBigInteger = new BigInteger(targetBytes);
            return this.fPhrase.equals(targetBigInteger);
        }
    }

    class ByteSequenceSearchPhrase
    implements SearchPhrase {
        private byte[] fBytes = null;

        public ByteSequenceSearchPhrase(String phrase) {
            this.fBytes = FindReplaceDialog.this.parseByteSequence(phrase);
        }

        public int getByteLength() {
            return this.fBytes.length;
        }

        public String toString() {
            if (this.fBytes == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.fBytes.length; ++i) {
                buf.append(BigInteger.valueOf(this.fBytes[i]).toString(16) + " ");
            }
            return buf.toString();
        }

        public boolean isMatch(MemoryByte[] bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i].getValue() == this.fBytes[i]) continue;
                return false;
            }
            return true;
        }
    }

    class FindReplaceMemoryCache {
        BigInteger memoryCacheStartAddress = BigInteger.ZERO;
        MemoryByte[] memoryCacheData = new MemoryByte[0];

        FindReplaceMemoryCache() {
        }
    }

    static interface SearchPhrase {
        public boolean isMatch(MemoryByte[] var1);

        public int getByteLength();

        public String toString();
    }
}

