/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.expression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.ExpressionVMProvider;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.IExpressionLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.MessagesForExpressionVM;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.VMElementsUpdate;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionManagerLayoutNode
extends AbstractVMLayoutNode
implements IElementLabelProvider,
IElementEditor {
    private IExpressionLayoutNode[] fExpressionNodes = new IExpressionLayoutNode[0];
    private IExpressionManager fManager = DebugPlugin.getDefault().getExpressionManager();
    private WatchExpressionCellModifier fWatchExpressionCellModifier = new WatchExpressionCellModifier();

    public ExpressionManagerLayoutNode(AbstractVMProvider provider) {
        super(provider);
    }

    public void updateHasElements(IHasChildrenUpdate[] updates) {
        for (int i = 0; i < updates.length; ++i) {
            updates[i].setHasChilren(this.fManager.getExpressions().length != 0);
            updates[i].done();
        }
    }

    public void updateElementCount(IChildrenCountUpdate update) {
        update.setChildCount(this.fManager.getExpressions().length);
        update.done();
    }

    public void updateElements(final IChildrenUpdate update) {
        IExpression[] expressions = this.fManager.getExpressions();
        final CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), null){

            protected void handleCompleted() {
                update.done();
            }
        };
        int expressionRmCount = 0;
        for (int i = update.getOffset(); i < update.getOffset() + update.getLength() && i < expressions.length; ++i) {
            if (i > expressions.length) continue;
            String expressionText = expressions[i].getExpressionText();
            final int expressionIdx = i;
            final IExpression expression = expressions[i];
            IExpressionLayoutNode expressionNode = this.findNodeForExpression(expressionText);
            if (expressionNode == null) {
                update.setChild((Object)new InvalidExpressionVMC(expression), i);
                continue;
            }
            ++expressionRmCount;
            VMElementsUpdate expressionElementUpdate = new VMElementsUpdate(update, 0, 1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.getExecutor(), (RequestMonitor)multiRm){

                protected void handleOK() {
                    update.setChild(((List)this.getData()).get(0), expressionIdx);
                    multiRm.done();
                }

                protected void handleError() {
                    update.setChild((Object)new InvalidExpressionVMC(expression), expressionIdx);
                    multiRm.done();
                }
            });
            expressionNode.getElementForExpression((IChildrenUpdate)expressionElementUpdate, expressionText, expression);
        }
        if (expressionRmCount > 0) {
            multiRm.setCount(expressionRmCount);
        } else {
            multiRm.done();
        }
    }

    public void update(ILabelUpdate[] updates) {
        for (ILabelUpdate update : updates) {
            if (update.getElement() instanceof InvalidExpressionVMC) {
                this.updateInvalidExpressionVMCLabel(update, (InvalidExpressionVMC)((Object)update.getElement()));
                continue;
            }
            update.done();
        }
    }

    private void updateInvalidExpressionVMCLabel(ILabelUpdate update, InvalidExpressionVMC vmc) {
        String[] stringArray;
        if (update.getColumnIds() != null) {
            stringArray = update.getColumnIds();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME";
        }
        String[] columnIds = stringArray;
        for (int i = 0; i < columnIds.length; ++i) {
            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnIds[i])) {
                update.setLabel(vmc.fExpression.getExpressionText(), i);
                update.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_EXPRESSION"), i);
                continue;
            }
            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(columnIds[i])) {
                update.setLabel(vmc.fExpression.getExpressionText(), i);
                update.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_EXPRESSION"), i);
                continue;
            }
            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnIds[i])) {
                update.setLabel(MessagesForExpressionVM.ExpressionManagerLayoutNode__invalidExpression_valueColumn_label, i);
                continue;
            }
            update.setLabel("", i);
        }
        update.done();
    }

    private IExpressionLayoutNode findNodeForExpression(String expressionText) {
        for (IExpressionLayoutNode node : this.fExpressionNodes) {
            if (node.getExpressionLength(expressionText) <= 0) continue;
            return node;
        }
        return null;
    }

    public void setChildNodes(IVMLayoutNode[] childNodes) {
        throw new UnsupportedOperationException("This node does not support children.");
    }

    public void setExpressionLayoutNodes(IExpressionLayoutNode[] nodes) {
        this.fExpressionNodes = nodes;
    }

    public void dispose() {
        for (IExpressionLayoutNode exprNode : this.fExpressionNodes) {
            exprNode.dispose();
        }
        super.dispose();
    }

    public int getDeltaFlags(Object event) {
        int retVal = 0;
        if (event instanceof ExpressionVMProvider.ExpressionsChangedEvent) {
            retVal |= 0x400;
        }
        for (IExpressionLayoutNode node : this.fExpressionNodes) {
            retVal |= node.getDeltaFlags(event);
        }
        return retVal;
    }

    public void buildDelta(Object event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof ExpressionVMProvider.ExpressionsChangedEvent) {
            parentDelta.addFlags(1024);
        }
        CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), requestMonitor);
        int buildDeltaForExpressionCallCount = 0;
        IExpression[] expressions = this.fManager.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            int flags;
            String expressionText = expressions[i].getExpressionText();
            IExpressionLayoutNode node = this.findNodeForExpression(expressionText);
            if (node == null || (flags = node.getDeltaFlagsForExpression(expressionText, event)) == 0) continue;
            node.buildDeltaForExpression(expressions[i], i + nodeOffset, expressionText, event, parentDelta, this.getTreePathFromDelta((IModelDelta)parentDelta), new RequestMonitor(this.getExecutor(), (RequestMonitor)multiRm));
            ++buildDeltaForExpressionCallCount;
        }
        if (buildDeltaForExpressionCallCount != 0) {
            multiRm.setCount(buildDeltaForExpressionCallCount);
        } else {
            requestMonitor.done();
        }
    }

    protected Map<IExpressionLayoutNode, Integer> getExpressionsWithDeltaFlags(String expressionText, Object e) {
        HashMap<IExpressionLayoutNode, Integer> nodes = new HashMap<IExpressionLayoutNode, Integer>();
        for (IExpressionLayoutNode node : this.fExpressionNodes) {
            int delta = node.getDeltaFlagsForExpression(expressionText, e);
            if (delta == 0) continue;
            nodes.put(node, delta);
        }
        return nodes;
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return this.fWatchExpressionCellModifier;
    }

    private class InvalidExpressionVMC
    extends AbstractVMLayoutNode.AbstractVMContext {
        final IExpression fExpression;

        public InvalidExpressionVMC(IExpression expression) {
            super((IVMAdapter)ExpressionManagerLayoutNode.this.getVMProvider().getVMAdapter(), (IVMLayoutNode)ExpressionManagerLayoutNode.this);
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object obj) {
            return obj instanceof InvalidExpressionVMC && ((InvalidExpressionVMC)((Object)obj)).fExpression.equals(this.fExpression);
        }

        public int hashCode() {
            return this.fExpression.hashCode();
        }
    }
}

