/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.register;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.dd.dsf.debug.ui.viewmodel.formatsupport.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;

public class RegisterBitFieldLayoutCellModifier
extends WatchExpressionCellModifier {
    private BitFieldEditorStyle fStyle;
    private IRegisters.IBitFieldDMData fBitFieldData = null;
    private Object fElement = null;
    private SyncRegisterDataAccess fDataAccess = null;
    private IFormattedValuePreferenceStore fFormatPrefStore;

    public RegisterBitFieldLayoutCellModifier(IFormattedValuePreferenceStore formatPrefStore, BitFieldEditorStyle style, SyncRegisterDataAccess access) {
        this.fStyle = style;
        this.fDataAccess = access;
        this.fFormatPrefStore = formatPrefStore;
    }

    private IRegisters.IBitFieldDMContext getBitFieldDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IRegisters.IBitFieldDMContext)((IAdaptable)element).getAdapter(IRegisters.IBitFieldDMContext.class);
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(property)) {
            if (this.getBitFieldDMC(element) == null) {
                return false;
            }
            this.fElement = element;
            this.fBitFieldData = this.fDataAccess.readBitField(element);
            return this.fBitFieldData == null || this.fBitFieldData.isWriteable();
        }
        return super.canModify(element, property);
    }

    public Object getValue(Object element, String property) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(property)) {
            if (element != this.fElement) {
                return false;
            }
            if (this.fStyle == BitFieldEditorStyle.BITFIELDTEXT) {
                String value = this.fDataAccess.getFormattedValue(this.fElement, this.fFormatPrefStore.getDefaultFormatId());
                if (value == null) {
                    value = "...";
                }
                return value;
            }
            IRegisters.IMnemonic curMnemonic = this.fBitFieldData.getCurrentMnemonicValue();
            int index = 0;
            for (IRegisters.IMnemonic mnemonic : this.fBitFieldData.getMnemonics()) {
                if (mnemonic.equals(curMnemonic)) {
                    return new Integer(index);
                }
                ++index;
            }
            return null;
        }
        return super.getValue(element, property);
    }

    public void modify(Object element, String property, Object value) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(property)) {
            if (this.fStyle == BitFieldEditorStyle.BITFIELDTEXT) {
                if (value instanceof String) {
                    this.fDataAccess.writeBitField(element, (String)value, "HEX.Format");
                }
            } else if (value instanceof Integer) {
                Integer val = (Integer)value;
                this.fDataAccess.writeBitField(element, this.fBitFieldData.getMnemonics()[val]);
            }
        } else {
            super.modify(element, property, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BitFieldEditorStyle {
        NOTHING,
        BITFIELDCOMBO,
        BITFIELDTEXT;

    }
}

