/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.variable;

import java.util.ArrayList;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableLocalsLayoutNode
extends AbstractDMVMLayoutNode<IExpressions.IExpressionDMData> {
    public VariableLocalsLayoutNode(AbstractVMProvider provider, DsfSession session) {
        super(provider, session, IExpressions.IExpressionDMContext.class);
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IExpressions.IExpressionDMContext dmc = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getElementPath(), IExpressions.IExpressionDMContext.class);
            ((IDMService)this.getServicesTracker().getService(null, dmc.getServiceFilter())).getModelData((IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>(this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    int idx;
                    if (!this.getStatus().isOK() || !((IExpressions.IExpressionDMData)this.getData()).isValid()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        VariableLocalsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{null};
                    }
                    boolean weAreExtractingFormattedData = false;
                    for (idx = 0; idx < localColumns.length; ++idx) {
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                            update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getName(), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                            update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getTypeName(), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                            weAreExtractingFormattedData = true;
                            continue;
                        }
                        if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) continue;
                        update.setLabel("", idx);
                    }
                    if (!weAreExtractingFormattedData) {
                        update.done();
                    } else {
                        for (idx = 0; idx < localColumns.length; ++idx) {
                            if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) continue;
                            VariableLocalsLayoutNode.this.updateFormattedExpressionValue(update, idx, dmc);
                        }
                    }
                }
            });
        }
    }

    private void updateFormattedExpressionValue(final ILabelUpdate update, final int labelIndex, final IExpressions.IExpressionDMContext dmc) {
        final IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        String preferencePageFormatId = "NATURAL.Format";
        expressionService.getAvailableFormattedValues((IFormattedValues.IFormattedDataDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<String[]>(this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    VariableLocalsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                String[] formatIds = (String[])this.getData();
                String finalFormatId = "NATURAL.Format";
                boolean requestedFormatIsSupported = false;
                for (String fId : formatIds) {
                    if (!"NATURAL.Format".equals(fId)) continue;
                    finalFormatId = "NATURAL.Format";
                    requestedFormatIsSupported = true;
                    break;
                }
                if (!requestedFormatIsSupported) {
                    if (formatIds.length != 0) {
                        finalFormatId = formatIds[0];
                    } else {
                        VariableLocalsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                }
                IFormattedValues.FormattedValueDMContext valueDmc = expressionService.getFormattedValue((IFormattedValues.IFormattedDataDMContext)dmc, finalFormatId);
                expressionService.getModelData((IDMContext)valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>(VariableLocalsLayoutNode.this.getSession().getExecutor(), null){

                    public void handleCompleted() {
                        if (!this.getStatus().isOK()) {
                            VariableLocalsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        update.setLabel(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), labelIndex);
                        update.done();
                    }
                });
            }
        });
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IExecutionDMContext.class);
        final IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)this.findDmcInPath(update.getElementPath(), IStack.IFrameDMContext.class);
        final IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        final IStack stackFrameService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (execDmc == null || frameDmc == null || expressionService == null || stackFrameService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final DsfExecutor dsfExecutor = this.getSession().getExecutor();
        DataRequestMonitor<IStack.IVariableDMContext[]> rm = new DataRequestMonitor<IStack.IVariableDMContext[]>(dsfExecutor, null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    VariableLocalsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                IStack.IVariableDMContext[] localsDMCs = (IStack.IVariableDMContext[])this.getData();
                if (localsDMCs == null) {
                    VariableLocalsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                final ArrayList localsDMData = new ArrayList();
                MultiRequestMonitor<DataRequestMonitor<IStack.IVariableDMData>> mrm = new MultiRequestMonitor<DataRequestMonitor<IStack.IVariableDMData>>(dsfExecutor, null){

                    public void handleCompleted() {
                        if (!this.getStatus().isOK()) {
                            VariableLocalsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        IExpressions.IExpressionDMContext[] expressionDMCs = new IExpressions.IExpressionDMContext[localsDMData.size()];
                        int i = 0;
                        for (IStack.IVariableDMData localDMData : localsDMData) {
                            expressionDMCs[i++] = expressionService.createExpression((IDMContext)frameDmc, localDMData.getName());
                        }
                        VariableLocalsLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])expressionDMCs);
                        update.done();
                    }
                };
                for (IStack.IVariableDMContext localDMC : localsDMCs) {
                    DataRequestMonitor<IStack.IVariableDMData> rm = new DataRequestMonitor<IStack.IVariableDMData>(dsfExecutor, null, (MultiRequestMonitor)mrm){
                        final /* synthetic */ MultiRequestMonitor val$mrm;
                        {
                            this.val$mrm = multiRequestMonitor;
                            super(x0, x1);
                        }

                        public void handleCompleted() {
                            localsDMData.add(this.getData());
                            this.val$mrm.requestMonitorDone((RequestMonitor)this);
                        }
                    };
                    mrm.add((RequestMonitor)rm);
                    stackFrameService.getModelData((IDMContext)localDMC, (DataRequestMonitor)rm);
                }
            }
        };
        stackFrameService.getLocals((IDMContext)frameDmc, (DataRequestMonitor)rm);
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(IDMEvent<?> e, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            parent.addFlags(1024);
        }
        super.buildDeltaForDMEvent(e, parent, nodeOffset, requestMonitor);
    }
}

