/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.register;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.AbstractExpressionVMNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterGroupVMNode
extends AbstractExpressionVMNode
implements IElementEditor,
IElementLabelProvider {
    private final SyncRegisterDataAccess fSyncRegisterDataAccess;
    protected final RegisterGroupExpressionFactory fRegisterGroupExpressionFactory = new RegisterGroupExpressionFactory();
    private WatchExpressionCellModifier fWatchExpressionCellModifier = new WatchExpressionCellModifier();

    public RegisterGroupVMNode(AbstractDMVMProvider provider, DsfSession session, SyncRegisterDataAccess syncDataAccess) {
        super(provider, session, IRegisters.IRegisterGroupDMContext.class);
        this.fSyncRegisterDataAccess = syncDataAccess;
    }

    public SyncRegisterDataAccess getSyncRegisterDataAccess() {
        return this.fSyncRegisterDataAccess;
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        ((IRegisters)this.getServicesTracker().getService(IRegisters.class)).getRegisterGroups(this.createCompositeDMVMContext((IViewerUpdate)update), (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    update.done();
                    return;
                }
                RegisterGroupVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new RegisterGroupVMC(dmc);
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    RegisterGroupVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IRegisters.IRegisterGroupDMContext dmc = (IRegisters.IRegisterGroupDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRegisters.IRegisterGroupDMContext.class);
            if (!this.checkDmc((IDMContext)dmc, (IViewerUpdate)update) || !this.checkService(IRegisters.class, null, (IViewerUpdate)update)) continue;
            this.getDMVMProvider().getModelData((IVMNode)this, (IViewerUpdate)update, (IDMService)this.getServicesTracker().getService(IRegisters.class, null), (IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        RegisterGroupVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{null};
                    }
                    for (int i = 0; i < localColumns.length; ++i) {
                        RegisterGroupVMNode.this.fillColumnLabel(dmc, (IRegisters.IRegisterGroupDMData)this.getData(), localColumns[i], i, update);
                    }
                    update.done();
                }
            }, (Executor)this.getExecutor());
        }
    }

    protected void fillColumnLabel(IRegisters.IRegisterGroupDMContext dmContext, IRegisters.IRegisterGroupDMData dmData, String columnId, int idx, ILabelUpdate update) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(columnId)) {
            update.setLabel(dmData.getName(), idx);
            update.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_REGISTER_GROUP"), idx);
        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnId)) {
            update.setLabel("", idx);
        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(columnId)) {
            update.setLabel(dmData.getDescription(), idx);
        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(columnId)) {
            update.setLabel("", idx);
        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            IVMContext vmc = (IVMContext)update.getElement();
            IExpression expression = (IExpression)vmc.getAdapter(IExpression.class);
            if (expression != null) {
                update.setLabel(expression.getExpressionText(), idx);
            } else {
                update.setLabel(dmData.getName(), idx);
            }
        } else if (columnId == null) {
            update.setLabel(dmData.getName(), idx);
            update.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_REGISTER_GROUP"), idx);
        }
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof IRegisters.IGroupsChangedDMEvent) {
            return 1024;
        }
        if (e instanceof IRegisters.IGroupChangedDMEvent) {
            return 2048;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        } else if (e instanceof IRegisters.IGroupsChangedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        } else if (e instanceof IRegisters.IGroupChangedDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IRegisters.IGroupChangedDMEvent)e).getDMContext()), 2048);
        }
        rm.done();
    }

    @Override
    public boolean canParseExpression(IExpression expression) {
        return this.parseExpressionForGroupName(expression.getExpressionText()) != null;
    }

    private String parseExpressionForGroupName(String expression) {
        int secondQuoteIdx;
        if (expression.startsWith("$$\"") && (secondQuoteIdx = expression.indexOf(34, "$$\"".length())) > 0) {
            return expression.substring(3, secondQuoteIdx);
        }
        return null;
    }

    public int getExpressionLength(String expression) {
        int secondQuoteIdx;
        if (expression.startsWith("$$\"") && (secondQuoteIdx = expression.indexOf(34, "$$\"".length())) > 0) {
            return secondQuoteIdx + 1;
        }
        return -1;
    }

    @Override
    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    @Override
    public void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IRegisters.IGroupsChangedDMEvent) {
            parentDelta.addNode(element, 1024);
        }
        if (event instanceof IRegisters.IGroupChangedDMEvent) {
            parentDelta.addNode(element, 2048);
        }
        rm.done();
    }

    @Override
    protected void testElementForExpression(Object element, IExpression expression, DataRequestMonitor<Boolean> rm) {
        if (!(element instanceof IDMVMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        IRegisters.IRegisterGroupDMContext dmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IRegisterGroupDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        String groupName = this.parseExpressionForGroupName(expression.getExpressionText());
        if (dmc.getName().equals(groupName)) {
            rm.setData((Object)Boolean.TRUE);
        } else {
            rm.setData((Object)Boolean.FALSE);
        }
        rm.done();
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof RegisterGroupVMC) {
            ((RegisterGroupVMC)((Object)element)).setExpression(expression);
        }
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return this.fWatchExpressionCellModifier;
    }

    protected class RegisterGroupExpressionFactory
    implements IWatchExpressionFactoryAdapter2 {
        protected RegisterGroupExpressionFactory() {
        }

        public boolean canCreateWatchExpression(Object element) {
            return element instanceof RegisterGroupVMC;
        }

        public String createWatchExpression(Object element) throws CoreException {
            RegisterGroupVMC registerVmc = (RegisterGroupVMC)((Object)element);
            StringBuffer exprBuf = new StringBuffer();
            IRegisters.IRegisterGroupDMContext groupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)registerVmc.getDMContext(), IRegisters.IRegisterGroupDMContext.class);
            if (groupDmc != null) {
                exprBuf.append("$$\"");
                exprBuf.append(groupDmc.getName());
                exprBuf.append('\"');
                return exprBuf.toString();
            }
            return null;
        }
    }

    protected class RegisterGroupVMC
    extends AbstractDMVMNode.DMVMContext {
        private IExpression fExpression;

        public RegisterGroupVMC(IDMContext dmc) {
            super((AbstractDMVMNode)RegisterGroupVMNode.this, dmc);
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return RegisterGroupVMNode.this.fRegisterGroupExpressionFactory;
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof RegisterGroupVMC && super.equals(other)) {
                RegisterGroupVMC otherGroup = (RegisterGroupVMC)((Object)other);
                return otherGroup.fExpression == null && this.fExpression == null || otherGroup.fExpression != null && otherGroup.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }
    }
}

