/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.IColorManagerExtension;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceRange;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceTag;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceTagListener;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.ISourceTagProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class SourceTagDamagerRepairer
extends DefaultDamagerRepairer
implements ISourceTagListener {
    private ISourceTagProvider fSourceTagProvider;
    private Map<String, ITokenScanner> fScannerMap = new HashMap<String, ITokenScanner>();
    private List<ISourceTag> fSourceTags = new ArrayList<ISourceTag>();
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private Map<String, TextAttribute> fAttributeMap = new HashMap<String, TextAttribute>();
    private static final String[] KEYS = new String[]{"class", "methodDeclaration", "functionDeclaration", "field", "globalVariable", "typedef", "macroDefinition", "enumerator", "enum"};

    public SourceTagDamagerRepairer(ITokenScanner scanner, ISourceTagProvider sourceTagProvider, IColorManager colorManager, IPreferenceStore store) {
        super(scanner);
        this.fSourceTagProvider = sourceTagProvider;
        this.fColorManager = colorManager;
        this.fPreferenceStore = store;
        this.fDefaultTextAttribute = new TextAttribute(null, null, 0);
        if (this.fSourceTagProvider != null) {
            this.fSourceTagProvider.addSourceTagListener(this);
            this.sourceTagsChanged(this.fSourceTagProvider);
        }
    }

    private void initTextAttributes() {
        boolean shEnabled = this.fPreferenceStore.getBoolean("semanticHighlighting.enabled");
        for (int i = 0; i < KEYS.length; ++i) {
            boolean enabled;
            String enabledKey = "semanticHighlighting." + KEYS[i] + ".enabled";
            String colorKey = "semanticHighlighting." + KEYS[i] + ".color";
            boolean bl = enabled = shEnabled && this.fPreferenceStore.getBoolean(enabledKey);
            if (enabled) {
                String boldKey = "semanticHighlighting." + KEYS[i] + ".bold";
                String italicKey = "semanticHighlighting." + KEYS[i] + ".italic";
                String strikethroughKey = "semanticHighlighting." + KEYS[i] + ".strikethrough";
                String underlineKey = "semanticHighlighting." + KEYS[i] + ".underline";
                this.addTextAttribute(KEYS[i], colorKey, boldKey, italicKey, strikethroughKey, underlineKey);
                continue;
            }
            this.removeTextAttribute(KEYS[i], colorKey);
        }
    }

    private void removeTextAttribute(String key, String colorKey) {
        if (this.fColorManager != null && colorKey != null) {
            Color color = this.fColorManager.getColor(colorKey);
            if (this.fColorManager instanceof IColorManagerExtension && color != null) {
                IColorManagerExtension ext = (IColorManagerExtension)this.fColorManager;
                ext.unbindColor(colorKey);
            }
        }
        this.fAttributeMap.remove(key);
    }

    private void addTextAttribute(String key, String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager instanceof IColorManagerExtension) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            Color color = this.fColorManager.getColor(colorKey);
            if (color == null || !rgb.equals((Object)color.getRGB())) {
                IColorManagerExtension ext = (IColorManagerExtension)this.fColorManager;
                ext.unbindColor(colorKey);
                ext.bindColor(colorKey, rgb);
            }
        }
        TextAttribute textAttribute = this.createTextAttribute(colorKey, boldKey, italicKey, strikethroughKey, underlineKey);
        this.fAttributeMap.put(key, textAttribute);
    }

    private TextAttribute createTextAttribute(String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        int style;
        Color color = null;
        if (colorKey != null) {
            color = this.fColorManager.getColor(colorKey);
        }
        int n = style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
        if (this.fPreferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        if (this.fPreferenceStore.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (this.fPreferenceStore.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(color, null, style);
    }

    public void setScanner(String contentType, ITokenScanner scanner) {
        this.fScannerMap.put(contentType, scanner);
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        if (this.fAttributeMap.isEmpty()) {
            this.initTextAttributes();
        }
        String contentType = region.getType();
        this.fScanner = this.fScannerMap.get(contentType);
        if (!contentType.equals("__dftl_partition_content_type") && !contentType.equals("__c_preprocessor")) {
            super.createPresentation(presentation, region);
            return;
        }
        if (this.fScanner == null) {
            return;
        }
        int lastStart = region.getOffset();
        int regionEnd = lastStart + region.getLength();
        int length = 0;
        int sourceTagCount = this.fSourceTags.size();
        int sourceTagIdx = 0;
        ISourceTag sourceTag = null;
        ISourceRange range = null;
        int sourceTagStart = 0;
        int sourceTagEnd = 0;
        if (sourceTagCount > 0 && this.fDocument.getLength() > 0) {
            int left = 0;
            int mid = (int)((float)sourceTagCount * ((float)lastStart / (float)this.fDocument.getLength()));
            int right = sourceTagCount - 1;
            while (true) {
                sourceTag = this.fSourceTags.get(mid);
                range = sourceTag.getRangeOfIdentifier();
                sourceTagStart = range.getBeginOffset();
                sourceTagEnd = range.getEndOffset() + 1;
                if (mid == left) break;
                if (mid < right && sourceTagEnd < lastStart) {
                    left = mid;
                    mid = (mid + right) / 2;
                    continue;
                }
                if (sourceTagStart >= regionEnd) {
                    right = mid;
                    mid = (left + mid) / 2;
                    continue;
                }
                if (sourceTagStart <= lastStart) break;
                right = --mid;
            }
            sourceTagIdx = mid + 1;
        }
        TextAttribute lastAttribute = this.fDefaultTextAttribute;
        this.fScanner.setRange(this.fDocument, lastStart, region.getLength());
        while (true) {
            IToken token = this.fScanner.nextToken();
            TextAttribute attribute = this.getTokenTextAttribute(token);
            int tokenLength = this.fScanner.getTokenLength();
            if (tokenLength > 0 && (lastAttribute == attribute || lastAttribute != null && lastAttribute.equals((Object)attribute))) {
                length += tokenLength;
                continue;
            }
            while (sourceTag != null && length > 0) {
                if (sourceTagStart >= regionEnd) {
                    sourceTag = null;
                    break;
                }
                if (sourceTagStart >= lastStart) {
                    if (sourceTagStart >= lastStart + length) break;
                    String sourceTagStyle = this.getSourceTagStyle(sourceTag.getStyleCode());
                    if (sourceTagStyle != null) {
                        if (sourceTagStart > lastStart) {
                            this.addRange(presentation, lastStart, Math.min(sourceTagStart - lastStart, length), lastAttribute);
                        }
                        int rangeEnd = Math.min(sourceTagEnd, regionEnd);
                        this.addRange(presentation, sourceTagStart, rangeEnd - sourceTagStart, this.getSourceTagTextAttribute(sourceTagStyle));
                        length = lastStart + length - rangeEnd;
                        lastStart = rangeEnd;
                    } else {
                        this.fSourceTags.remove(--sourceTagIdx);
                        --sourceTagCount;
                    }
                }
                if ((sourceTag = sourceTagIdx < sourceTagCount ? this.fSourceTags.get(sourceTagIdx++) : null) == null) continue;
                range = sourceTag.getRangeOfIdentifier();
                sourceTagStart = range.getBeginOffset();
                sourceTagEnd = range.getEndOffset() + 1;
            }
            if (token.isEOF()) break;
            if (length > 0) {
                this.addRange(presentation, lastStart, length, lastAttribute);
                lastAttribute = attribute;
                lastStart = this.fScanner.getTokenOffset();
                length = tokenLength;
                continue;
            }
            lastAttribute = attribute;
            length = this.fScanner.getTokenOffset() - lastStart + tokenLength;
        }
        this.addRange(presentation, lastStart, length, lastAttribute);
    }

    private TextAttribute getSourceTagTextAttribute(String sourceTagStyle) {
        return this.fAttributeMap.get(sourceTagStyle);
    }

    private String getSourceTagStyle(int styleCode) {
        switch (styleCode) {
            case 0: {
                return null;
            }
            case 1: {
                return "class";
            }
            case 2: {
                return "class";
            }
            case 3: {
                return "class";
            }
            case 6: {
                return "functionDeclaration";
            }
            case 8: {
                return "methodDeclaration";
            }
            case 10: {
                return "globalVariable";
            }
            case 11: {
                return "field";
            }
            case 12: {
                return "enumerator";
            }
            case 13: {
                return "macroDefinition";
            }
            case 14: {
                return null;
            }
            case 16: {
                return "enum";
            }
            case 15: {
                return null;
            }
            case 17: {
                return "typedef";
            }
        }
        return null;
    }

    public void sourceTagsChanged(ISourceTagProvider sourceTagProvider) {
        this.fSourceTags.clear();
        if (sourceTagProvider != null) {
            sourceTagProvider.getSourceTags(this.fSourceTags);
            Collections.sort(this.fSourceTags, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ISourceRange sr1 = ((ISourceTag)o1).getRangeOfIdentifier();
                    ISourceRange sr2 = ((ISourceTag)o2).getRangeOfIdentifier();
                    return sr1.getBeginOffset() - sr2.getBeginOffset();
                }
            });
        }
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (length > 0 && attr != null) {
            presentation.addStyleRange(new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), attr.getStyle()));
        }
    }

    public boolean affectsBahvior(PropertyChangeEvent event) {
        return event.getProperty().startsWith("semanticHighlighting.");
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        this.initTextAttributes();
    }
}

