/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.sourcelookup;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

@ThreadSafe
class InstructionPointerManager {
    private List<AnnotationWrapper> fAnnotationWrappers = Collections.synchronizedList(new LinkedList());

    public void addAnnotation(ITextEditor textEditor, IStack.IFrameDMContext frame, Position position, boolean isTopFrame) {
        Image image;
        String text;
        String id;
        IEditorInput editorInput;
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        IAnnotationModel annModel = docProvider.getAnnotationModel((Object)(editorInput = textEditor.getEditorInput()));
        if (annModel == null) {
            return;
        }
        if (isTopFrame) {
            id = "org.eclipse.dd.debug.currentIP";
            text = "Debug Current Instruction Pointer";
            image = DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER_TOP");
        } else {
            id = "org.eclipse.dd.debug.secondaryIP";
            text = "Debug Call Stack";
            image = DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER");
        }
        IPAnnotation annotation = new IPAnnotation(frame, id, text, image);
        annModel.removeAnnotation((Annotation)annotation);
        annModel.addAnnotation((Annotation)annotation, position);
        this.fAnnotationWrappers.add(new AnnotationWrapper(textEditor, annotation, frame));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotations(IRunControl.IExecutionDMContext execDmc) {
        List<AnnotationWrapper> list = this.fAnnotationWrappers;
        synchronized (list) {
            Iterator<AnnotationWrapper> wrapperItr = this.fAnnotationWrappers.iterator();
            while (wrapperItr.hasNext()) {
                AnnotationWrapper wrapper = wrapperItr.next();
                if (!DMContexts.isAncestorOf((IDMContext)wrapper.getFrameDMC(), (IDMContext)execDmc)) continue;
                this.removeAnnotation(wrapper.getTextEditor(), wrapper.getAnnotation());
                wrapperItr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAnnotations() {
        List<AnnotationWrapper> list = this.fAnnotationWrappers;
        synchronized (list) {
            for (AnnotationWrapper wrapper : this.fAnnotationWrappers) {
                this.removeAnnotation(wrapper.getTextEditor(), wrapper.getAnnotation());
            }
            this.fAnnotationWrappers.clear();
        }
    }

    private void removeAnnotation(ITextEditor textEditor, Annotation annotation) {
        IAnnotationModel annotationModel;
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        if (docProvider != null && (annotationModel = docProvider.getAnnotationModel((Object)textEditor.getEditorInput())) != null) {
            annotationModel.removeAnnotation(annotation);
        }
    }

    static class AnnotationWrapper {
        private ITextEditor fTextEditor;
        private IStack.IFrameDMContext fFrameDmc;
        private Annotation fAnnotation;

        AnnotationWrapper(ITextEditor textEditor, Annotation annotation, IStack.IFrameDMContext frameDmc) {
            this.fTextEditor = textEditor;
            this.fAnnotation = annotation;
            this.fFrameDmc = frameDmc;
        }

        public boolean equals(Object other) {
            if (other instanceof AnnotationWrapper) {
                AnnotationWrapper otherContext = (AnnotationWrapper)other;
                return this.getAnnotation().equals(otherContext.getAnnotation());
            }
            return false;
        }

        public int hashCode() {
            return this.getAnnotation().hashCode();
        }

        ITextEditor getTextEditor() {
            return this.fTextEditor;
        }

        Annotation getAnnotation() {
            return this.fAnnotation;
        }

        IStack.IFrameDMContext getFrameDMC() {
            return this.fFrameDmc;
        }
    }

    static class IPAnnotation
    extends Annotation {
        private Image fImage;
        private IStack.IFrameDMContext fFrame;

        IPAnnotation(IStack.IFrameDMContext frame, String annotationType, String text, Image image) {
            super(annotationType, false, text);
            this.fFrame = frame;
            this.fImage = image;
        }

        protected Image getImage() {
            return this.fImage;
        }

        public boolean equals(Object other) {
            if (other instanceof IPAnnotation) {
                return this.fFrame.equals(((IPAnnotation)((Object)other)).fFrame);
            }
            return false;
        }

        public int hashCode() {
            return this.fFrame.hashCode();
        }
    }
}

