/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly.text;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class REDFile {
    private static final boolean DEBUG = false;
    public static final int fcNrBufs = 4;
    private RandomAccessFile fFile;
    private int fPosition;
    private int fLength;
    private Buffer[] fBuffer = new Buffer[4];
    private byte[] fByteBuffer = new byte[4096];
    private int fSwapper;
    private String fName;
    private boolean fReadonly;
    private boolean fDeleteOnDispose;

    private REDFile(File file, boolean readonly) {
        assert (!readonly || file != null);
        this.fReadonly = readonly;
        boolean bl = this.fDeleteOnDispose = file == null;
        if (file != null) {
            try {
                this.setFile(file);
                this.fLength = (int)(this.fFile.length() / 2L);
            }
            catch (IOException ioe) {
                throw new Error(ioe);
            }
        }
    }

    public REDFile() {
        this((File)null, false);
    }

    public REDFile(String name, boolean readonly) {
        this(new File(name), readonly);
    }

    public REDFile(String name) {
        this(name, false);
    }

    private void setFile(File file) throws IOException {
        assert (file != null);
        if (this.fReadonly) {
            this.fFile = new RandomAccessFile(file, "r");
            this.fName = file.toString();
        } else if (file != null) {
            this.fFile = new RandomAccessFile(file, "rw");
            this.fName = file.toString();
        }
    }

    public void dispose() {
        if (this.fFile != null) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fFile = null;
            if (this.fDeleteOnDispose) {
                new File(this.fName).delete();
            }
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.fFile != null) {
            this.fFile.close();
        }
    }

    public void flush() throws IOException {
        for (int i = 0; i < 4; ++i) {
            if (this.fBuffer[i] == null) continue;
            if (this.fBuffer[i].fDirty) {
                this.flush(this.fBuffer[i]);
            }
            this.fBuffer[i] = null;
        }
    }

    private void flush(Buffer buffer) throws IOException {
        assert (buffer.fDirty);
        this.write(buffer.fOffset, buffer.fData, 0, buffer.fSize);
        buffer.fDirty = false;
    }

    public boolean isReadonly() {
        return this.fReadonly;
    }

    public int length() {
        if (this.fLength < 0) {
            if (this.fFile == null) {
                this.fLength = 0;
            } else {
                try {
                    this.fLength = (int)(this.fFile.length() / 2L);
                }
                catch (IOException e) {
                    this.fLength = 0;
                }
            }
        }
        return this.fLength;
    }

    public boolean purge() throws IOException {
        if (this.isReadonly()) {
            return false;
        }
        this.fFile.setLength(0L);
        for (int i = 0; i < 4; ++i) {
            if (this.fBuffer[i] == null) continue;
            this.fBuffer[i].fOffset = -1;
            this.fBuffer[i].fDirty = false;
            if (i <= 0) continue;
            this.fBuffer[i] = null;
        }
        this.fLength = 0;
        return true;
    }

    protected void finalize() {
        this.dispose();
    }

    private File createTmpFile() {
        try {
            File file = File.createTempFile("scratch", ".tmp");
            file.deleteOnExit();
            return file;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static void copyFile(REDFile src, REDFile dest) throws IOException {
        dest.purge();
        byte[] buf = new byte[4096];
        int n = src.fFile.read(buf);
        while (n >= 0) {
            if (n > 0) {
                dest.fFile.write(buf, 0, n);
            }
            n = src.fFile.read(buf);
        }
        dest.fLength = src.length();
    }

    public void seek(int offset) throws IOException {
        if (offset < 0) {
            throw new IOException("Negative seek position");
        }
        this.fPosition = offset;
    }

    private void write(int position, char[] data, int offset, int length) throws IOException {
        if (this.fFile == null) {
            this.setFile(this.createTmpFile());
        }
        this.fFile.seek(position * 2);
        int blen = 0;
        for (int clen = 0; clen < length; ++clen) {
            char c = data[offset + clen];
            this.fByteBuffer[blen++] = (byte)(c >>> 8 & 0xFF);
            this.fByteBuffer[blen++] = (byte)(c >>> 0 & 0xFF);
            if (blen != this.fByteBuffer.length) continue;
            this.fFile.write(this.fByteBuffer, 0, blen);
            blen = 0;
        }
        if (blen > 0) {
            this.fFile.write(this.fByteBuffer, 0, blen);
        }
    }

    public void writeBuffered(char[] data, int offset, int length) throws IOException {
        int count;
        if (this.isReadonly()) {
            throw new IOException("Cannot write to readonly file");
        }
        Buffer buffer = null;
        int clen = 0;
        while (clen < length && (count = Math.min(length - clen, (buffer = this.getBufferForOffset(this.fPosition, true)).free())) != 0) {
            System.arraycopy(data, offset, buffer.fData, buffer.fPos, count);
            buffer.fPos += count;
            if (buffer.fPos > buffer.fSize) {
                buffer.fSize = buffer.fPos;
            }
            buffer.fDirty = true;
            offset += count;
            clen += count;
            this.fPosition += count;
        }
        if (this.fPosition > this.fLength) {
            this.fLength = this.fPosition;
        }
    }

    public void writeBuffered(String data, int offset, int length) throws IOException {
        int count;
        if (this.isReadonly()) {
            throw new IOException("Cannot write to readonly file");
        }
        Buffer buffer = null;
        int clen = 0;
        while (clen < length && (count = Math.min(length - clen, (buffer = this.getBufferForOffset(this.fPosition, true)).free())) != 0) {
            data.getChars(offset, offset + count, buffer.fData, buffer.fPos);
            buffer.fPos += count;
            if (buffer.fPos > buffer.fSize) {
                buffer.fSize = buffer.fPos;
            }
            buffer.fDirty = true;
            offset += count;
            clen += count;
            this.fPosition += count;
        }
        if (this.fPosition > this.fLength) {
            this.fLength = this.fPosition;
        }
    }

    private void update(Buffer buffer) throws IOException {
        assert (!buffer.fDirty);
        buffer.fSize = this.read(buffer.fOffset, buffer.fData, 0, buffer.fData.length);
    }

    private int read(int position, char[] data, int offset, int length) throws IOException {
        int blen;
        int count;
        this.fFile.seek(position * 2);
        int bsize = length * 2;
        for (blen = 0; blen < bsize && (count = this.fFile.read(this.fByteBuffer, 0, Math.min(this.fByteBuffer.length, bsize - blen))) >= 0; blen += count) {
            for (int i = 0; i < count; i += 2) {
                int hiByte = this.fByteBuffer[i] & 0xFF;
                int loByte = this.fByteBuffer[i + 1] & 0xFF;
                data[offset++] = (char)(hiByte << 8 | loByte << 0);
            }
        }
        return blen / 2;
    }

    public int readBuffered(char[] data, int offset, int length) throws IOException {
        Buffer buffer;
        int count;
        int clen = 0;
        while (clen < length && (count = Math.min(length - clen, (buffer = this.getBufferForOffset(this.fPosition, false)).avail())) > 0) {
            System.arraycopy(buffer.fData, buffer.fPos, data, offset, count);
            buffer.fPos += count;
            offset += count;
            clen += count;
            this.fPosition += count;
        }
        return clen;
    }

    public int readBuffered(StringBuffer strBuf, int length) throws IOException {
        Buffer buffer;
        int count;
        int clen = 0;
        while (clen < length && (count = Math.min(length - clen, (buffer = this.getBufferForOffset(this.fPosition, false)).avail())) > 0) {
            strBuf.append(buffer.fData, buffer.fPos, count);
            buffer.fPos += count;
            clen += count;
            this.fPosition += count;
        }
        return clen;
    }

    private Buffer getBufferForOffset(int offset, boolean write) throws IOException {
        int i;
        Buffer buffer = null;
        int bufferOffset = offset / 2048 * 2048;
        for (i = 0; i < 4 && this.fBuffer[i] != null; ++i) {
            if (bufferOffset != this.fBuffer[i].fOffset) continue;
            buffer = this.fBuffer[i];
            break;
        }
        if (buffer == null) {
            if (i < 4) {
                this.fBuffer[i] = buffer = new Buffer();
            } else {
                this.fSwapper = (this.fSwapper + 1) % 4;
                buffer = this.fBuffer[this.fSwapper];
                if (buffer.fDirty) {
                    this.flush(buffer);
                }
            }
            buffer.fOffset = bufferOffset;
            buffer.fSize = 0;
        }
        buffer.fPos = offset - buffer.fOffset;
        if (write && buffer.fSize < buffer.fPos || !write && buffer.avail() <= 0) {
            if (buffer.fDirty) {
                this.flush(buffer);
            }
            this.update(buffer);
        }
        return buffer;
    }

    private static final class Buffer {
        static final int fcBufSize = 2048;
        boolean fDirty;
        int fOffset = -1;
        int fPos;
        int fSize;
        char[] fData = new char[2048];

        Buffer() {
        }

        boolean containsOffset(int pos) {
            return this.fOffset < pos || this.fOffset + this.fSize <= pos;
        }

        public int avail() {
            return this.fSize - this.fPos;
        }

        public int free() {
            return 2048 - this.fPos;
        }
    }
}

