/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.service.control;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.gdb.service.control.GDBControl;
import org.eclipse.dd.dsf.gdb.service.control.MIInferiorProcess;
import org.eclipse.dd.dsf.mi.core.command.DsfCLICommand;
import org.eclipse.dd.dsf.mi.core.command.DsfMIInterpreterExecConsole;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIStreamRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIBreakpointChangedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIBreakpointHitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIDetachedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIErrorEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIFunctionFinishedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorSignalExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMILocationReachedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIRunningEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISharedLibEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISignalChangedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISignalEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISteppingRangeEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIWatchpointScopeEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIWatchpointTriggerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBEventProcessor
implements ICommandListener,
IEventListener {
    private final GDBControl fConnection;
    private final MIInferiorProcess fInferior;
    private final List<Object> fEventList = new LinkedList<Object>();

    public GDBEventProcessor(GDBControl connection, MIInferiorProcess inferior) {
        this.fConnection = connection;
        this.fInferior = inferior;
        connection.addCommandListener(this);
        connection.addEventListener(this);
    }

    public void dispose() {
        this.fConnection.removeCommandListener(this);
        this.fConnection.removeEventListener(this);
    }

    public void commandSent(ICommand<? extends ICommandResult> command) {
        if (command instanceof DsfCLICommand) {
            this.processStateChanges((DsfCLICommand<? extends ICommandResult>)((DsfCLICommand)command));
        } else if (command instanceof DsfMIInterpreterExecConsole) {
            this.processStateChanges((DsfMIInterpreterExecConsole<? extends ICommandResult>)((DsfMIInterpreterExecConsole)command));
        }
    }

    public void commandDone(ICommand<? extends ICommandResult> command, ICommandResult result) {
        if (command instanceof DsfCLICommand) {
            this.processSettingChanges((DsfCLICommand)command);
        } else if (command instanceof DsfMIInterpreterExecConsole) {
            this.processSettingChanges((DsfMIInterpreterExecConsole)command);
        }
        this.fEventList.clear();
    }

    public void commandQueued(ICommand<? extends ICommandResult> command) {
    }

    public void commandRemoved(ICommand<? extends ICommandResult> command) {
    }

    public void eventReceived(Object output) {
        String state;
        for (DsfMIOOBRecord oobr : ((DsfMIOutput)output).getMIOOBRecords()) {
            this.fEventList.add(oobr);
        }
        DsfMIResultRecord rr = ((DsfMIOutput)output).getMIResultRecord();
        if (rr != null && "error".equals(state = rr.getResultClass()) && this.fConnection.getInferiorProcess().getState() == MIInferiorProcess.State.RUNNING) {
            this.fConnection.getInferiorProcess().setState(MIInferiorProcess.State.RUNNING);
            this.fConnection.getSession().dispatchEvent((Object)new DsfMIErrorEvent(rr, null), this.fConnection.getProperties());
        }
    }

    /*
     * WARNING - void declaration
     */
    void processMIOOBRecord(DsfMIResultRecord rr) {
        LinkedList<Object> list = new LinkedList<Object>();
        DsfMIResult[] results = rr.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String reason;
            DsfMIEvent event;
            DsfMIValue value;
            String string = results[i].getVariable();
            if (!string.equals("reason") || !((value = results[i].getMIValue()) instanceof DsfMIConst) || (event = this.createEvent(reason = ((DsfMIConst)value).getString(), rr)) == null) continue;
            list.add(event);
        }
        if (list.isEmpty()) {
            void var5_10;
            String[] logs = this.getStreamRecords();
            boolean bl = false;
            while (var5_10 < logs.length) {
                if (logs[var5_10].equalsIgnoreCase("Stopped due to shared library event")) {
                    this.fInferior.setState(MIInferiorProcess.State.STOPPED);
                    DsfMISharedLibEvent e = new DsfMISharedLibEvent(rr);
                    list.add(e);
                }
                ++var5_10;
            }
        }
        if (list.isEmpty() && this.fInferior.getState() == MIInferiorProcess.State.RUNNING) {
            this.fInferior.setState(MIInferiorProcess.State.STOPPED);
            DsfMIStoppedEvent event = new DsfMIStoppedEvent(rr);
            list.add(event);
        }
        for (DsfMIEvent dsfMIEvent : list) {
            this.fConnection.getSession().dispatchEvent((Object)dsfMIEvent, this.fConnection.getProperties());
        }
    }

    private void processStateChanges(DsfCLICommand<? extends ICommandResult> cmd) {
        String operation = cmd.getOperation().trim();
        this.processStateChanges(0, operation);
    }

    private void processStateChanges(DsfMIInterpreterExecConsole<? extends ICommandResult> exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processStateChanges(0, operations[0]);
        }
    }

    private void processStateChanges(int token, String operation) {
        int indx = operation.indexOf(32);
        int type = GDBEventProcessor.getSteppingOperationKind(operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim());
        if (type != -1) {
            DsfMIRunningEvent event = new DsfMIRunningEvent(token, type);
            this.fConnection.getSession().dispatchEvent((Object)event, this.fConnection.getProperties());
        }
    }

    private void processSettingChanges(DsfCLICommand<?> cmd) {
        String operation = cmd.getOperation().trim();
        this.processSettingChanges(0, operation);
    }

    private void processSettingChanges(DsfMIInterpreterExecConsole<?> exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processSettingChanges(0, operations[0]);
        }
    }

    private void processSettingChanges(int token, String operation) {
        int indx = operation.indexOf(32);
        if (this.isSettingBreakpoint(operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim()) || this.isSettingWatchpoint(operation) || this.isChangeBreakpoint(operation) || this.isDeletingBreakpoint(operation)) {
            DsfMIBreakpointChangedEvent event = new DsfMIBreakpointChangedEvent(0);
            this.fConnection.getSession().dispatchEvent((Object)event, this.fConnection.getProperties());
        } else if (this.isSettingSignal(operation)) {
            DsfMISignalChangedEvent event = new DsfMISignalChangedEvent("");
            this.fConnection.getSession().dispatchEvent((Object)event, this.fConnection.getProperties());
        } else if (this.isDetach(operation)) {
            DsfMIDetachedEvent event = new DsfMIDetachedEvent(token);
            this.fConnection.getSession().dispatchEvent((Object)event, this.fConnection.getProperties());
        }
    }

    private static int getSteppingOperationKind(String operation) {
        int type = -1;
        if (operation.equals("n") || operation.equals("next")) {
            type = 1;
        } else if (operation.equals("ni") || operation.equals("nexti")) {
            type = 2;
        } else if (operation.equals("s") || operation.equals("step")) {
            type = 3;
        } else if (operation.equals("si") || operation.equals("stepi")) {
            type = 4;
        } else if (operation.equals("u") || operation.startsWith("unt") && "until".indexOf(operation) != -1) {
            type = 6;
        } else if (operation.startsWith("fin") && "finish".indexOf(operation) != -1) {
            type = 5;
        } else if (operation.equals("c") || operation.equals("fg") || operation.startsWith("cont") && "continue".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("sig") && "signal".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("j") && "jump".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.equals("r") || operation.equals("run")) {
            type = 0;
        }
        return type;
    }

    public static boolean isSteppingOperation(String operation) {
        int type = GDBEventProcessor.getSteppingOperationKind(operation);
        return type != -1;
    }

    private boolean isSettingBreakpoint(String operation) {
        boolean isbreak = false;
        if (operation.startsWith("b") && "break".indexOf(operation) != -1 || operation.startsWith("tb") && "tbreak".indexOf(operation) != -1 || operation.startsWith("hb") && "hbreak".indexOf(operation) != -1 || operation.startsWith("thb") && "thbreak".indexOf(operation) != -1 || operation.startsWith("rb") && "rbreak".indexOf(operation) != -1) {
            isbreak = true;
        }
        return isbreak;
    }

    private boolean isSettingWatchpoint(String operation) {
        boolean isWatch = false;
        if (operation.startsWith("wa") && "watch".indexOf(operation) != -1 || operation.startsWith("rw") && "rwatch".indexOf(operation) != -1 || operation.startsWith("aw") && "awatch".indexOf(operation) != -1) {
            isWatch = true;
        }
        return isWatch;
    }

    private boolean isDeletingBreakpoint(String operation) {
        boolean isDelete = false;
        if (operation.startsWith("cl") && "clear".indexOf(operation) != -1 || operation.equals("d") || operation.startsWith("del") && "delete".indexOf(operation) != -1) {
            isDelete = true;
        }
        return isDelete;
    }

    private boolean isChangeBreakpoint(String operation) {
        boolean isChange = false;
        if (operation.equals("dis") || operation.equals("disa") || operation.startsWith("disa") && "disable".indexOf(operation) != -1 || operation.equals("en") || operation.startsWith("en") && "enable".indexOf(operation) != -1 || operation.startsWith("ig") && "ignore".indexOf(operation) != -1 || operation.startsWith("cond") && "condition".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    private boolean isSettingSignal(String operation) {
        boolean isChange = false;
        if (operation.startsWith("ha") && "handle".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    private boolean isDetach(String operation) {
        return operation.startsWith("det") && "detach".indexOf(operation) != -1;
    }

    DsfMIEvent createEvent(String reason, DsfMIResultRecord rr) {
        DsfMIBreakpointHitEvent event = null;
        if ("breakpoint-hit".equals(reason)) {
            event = new DsfMIBreakpointHitEvent(rr);
            this.fInferior.setState(MIInferiorProcess.State.STOPPED);
        } else if ("watchpoint-trigger".equals(reason) || "read-watchpoint-trigger".equals(reason) || "access-watchpoint-trigger".equals(reason)) {
            event = new DsfMIWatchpointTriggerEvent(rr);
        } else if ("watchpoint-scope".equals(reason)) {
            event = new DsfMIWatchpointScopeEvent(rr);
            this.fInferior.setState(MIInferiorProcess.State.STOPPED);
        } else if ("end-stepping-range".equals(reason)) {
            event = new DsfMISteppingRangeEvent(rr);
            this.fInferior.setState(MIInferiorProcess.State.STOPPED);
        } else if ("signal-received".equals(reason)) {
            event = new DsfMISignalEvent(rr);
            this.fInferior.setState(MIInferiorProcess.State.STOPPED);
        } else if ("location-reached".equals(reason)) {
            event = new DsfMILocationReachedEvent(rr);
            this.fInferior.setState(MIInferiorProcess.State.STOPPED);
        } else if ("function-finished".equals(reason)) {
            event = new DsfMIFunctionFinishedEvent(rr);
            this.fInferior.setState(MIInferiorProcess.State.STOPPED);
        } else if ("exited-normally".equals(reason) || "exited".equals(reason)) {
            event = new DsfMIInferiorExitEvent(rr);
            this.fInferior.setState(MIInferiorProcess.State.TERMINATED);
        } else if ("exited-signalled".equals(reason)) {
            event = new DsfMIInferiorSignalExitEvent(rr);
            this.fInferior.setState(MIInferiorProcess.State.TERMINATED);
        }
        return event;
    }

    private String[] getStreamRecords() {
        ArrayList<String> streamRecords = new ArrayList<String>();
        DsfMIOOBRecord[] oobRecords = this.fEventList.toArray(new DsfMIOOBRecord[0]);
        for (int i = 0; i < oobRecords.length; ++i) {
            String s;
            if (!(oobRecords[i] instanceof DsfMIStreamRecord) || (s = ((DsfMIStreamRecord)oobRecords[i]).getString().trim()) == null || s.length() <= 0) continue;
            streamRecords.add(s);
        }
        return streamRecords.toArray(new String[0]);
    }
}

