/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.launching;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.gdb.service.GDBRunControl;
import org.eclipse.dd.dsf.gdb.service.control.GDBControl;
import org.eclipse.dd.dsf.mi.service.CSourceLookup;
import org.eclipse.dd.dsf.mi.service.ExpressionService;
import org.eclipse.dd.dsf.mi.service.MIBreakpoints;
import org.eclipse.dd.dsf.mi.service.MIBreakpointsManager;
import org.eclipse.dd.dsf.mi.service.MIMemory;
import org.eclipse.dd.dsf.mi.service.MIModules;
import org.eclipse.dd.dsf.mi.service.MIRegisters;
import org.eclipse.dd.dsf.mi.service.MIStack;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.IDsfService;
import org.eclipse.dd.gdb.DsfGdbPlugin;

public class ShutdownSequence
extends Sequence {
    String fSessionId;
    String fApplicationName;
    String fDebugModelId;
    DsfServicesTracker fTracker;
    private final Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            assert (DsfGdbPlugin.getBundleContext() != null);
            ShutdownSequence.this.fTracker = new DsfServicesTracker(DsfGdbPlugin.getBundleContext(), ShutdownSequence.this.fSessionId);
            requestMonitor.done();
        }

        public void rollBack(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIRegisters.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            MIBreakpointsManager bpm = (MIBreakpointsManager)ShutdownSequence.this.fTracker.getService(MIBreakpointsManager.class);
            GDBControl commandControl = (GDBControl)ShutdownSequence.this.fTracker.getService(GDBControl.class);
            if (bpm != null && commandControl != null) {
                bpm.stopTrackingBreakpoints((IBreakpoints.IBreakpointsTargetDMContext)commandControl.getGDBDMContext(), new RequestMonitor((Executor)ShutdownSequence.this.getExecutor(), requestMonitor){

                    protected void handleCompleted() {
                        if (!this.getStatus().isOK()) {
                            DsfGdbPlugin.getDefault().getLog().log(this.getStatus());
                        }
                        requestMonitor.done();
                    }
                });
            } else {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Needed services not found.", null));
                requestMonitor.done();
            }
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIBreakpointsManager.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIBreakpoints.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(CSourceLookup.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(ExpressionService.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIStack.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIModules.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(MIMemory.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(GDBRunControl.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.shutdownService(GDBControl.class, requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            ShutdownSequence.this.fTracker.dispose();
            ShutdownSequence.this.fTracker = null;
            requestMonitor.done();
        }
    }};

    public ShutdownSequence(DsfExecutor executor, String sessionId, RequestMonitor requestMonitor) {
        super(executor, requestMonitor);
        this.fSessionId = sessionId;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private void shutdownService(Class clazz, final RequestMonitor requestMonitor) {
        IDsfService service = this.fTracker.getService(clazz);
        if (service != null) {
            service.shutdown(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

                protected void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        DsfGdbPlugin.getDefault().getLog().log(this.getStatus());
                    }
                    requestMonitor.done();
                }
            });
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Service '" + clazz.getName() + "' not found.", null));
            requestMonitor.done();
        }
    }
}

