/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

public class DsfMIBreakpoint {
    int number;
    String type = "";
    String disp = "";
    boolean enabled;
    String address;
    String func = "";
    String file = "";
    int line;
    String cond = "";
    int times;
    String what = "";
    String threadId = "";
    int ignore;
    boolean isWpt;
    boolean isAWpt;
    boolean isRWpt;
    boolean isWWpt;
    boolean isHdw;

    public DsfMIBreakpoint(DsfMITuple tuple) {
        this.parse(tuple);
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int num) {
        this.number = num;
    }

    public String getType() {
        return this.type;
    }

    public boolean isTemporary() {
        return this.getDisposition().equals("del");
    }

    public boolean isWatchpoint() {
        return this.isWpt;
    }

    public void setWatchpoint(boolean w) {
        this.isWpt = w;
    }

    public boolean isHardware() {
        return this.isHdw;
    }

    public void setHardware(boolean hd) {
        this.isWpt = hd;
        this.isHdw = hd;
    }

    public boolean isAccessWatchpoint() {
        return this.isAWpt;
    }

    public void setAccessWatchpoint(boolean a) {
        this.isWpt = a;
        this.isAWpt = a;
    }

    public boolean isReadWatchpoint() {
        return this.isRWpt;
    }

    public void setReadWatchpoint(boolean r) {
        this.isWpt = r;
        this.isRWpt = r;
    }

    public boolean isWriteWatchpoint() {
        return this.isWWpt;
    }

    public void setWriteWatchpoint(boolean w) {
        this.isWpt = w;
        this.isWWpt = w;
    }

    public String getDisposition() {
        return this.disp;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public String getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.func;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getTimes() {
        return this.times;
    }

    public String getWhat() {
        return this.what;
    }

    public int getIgnoreCount() {
        return this.ignore;
    }

    public String getCondition() {
        return this.cond;
    }

    public String getThreadId() {
        return this.threadId;
    }

    void parse(DsfMITuple tuple) {
        DsfMIResult[] results = tuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof DsfMIConst) {
                str = ((DsfMIConst)value).getCString();
            }
            if (var.equals("number")) {
                try {
                    this.number = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("type")) {
                this.type = str;
                if (this.type.startsWith("hw")) {
                    this.isHdw = true;
                    this.isWWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("acc")) {
                    this.isWWpt = true;
                    this.isRWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("read")) {
                    this.isRWpt = true;
                    this.isWpt = true;
                }
                if (!this.type.equals("watchpoint")) continue;
                this.isWpt = true;
                continue;
            }
            if (var.equals("disp")) {
                this.disp = str;
                continue;
            }
            if (var.equals("enabled")) {
                this.enabled = str.equals("y");
                continue;
            }
            if (var.equals("addr")) {
                try {
                    this.address = str.trim();
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("func")) {
                this.func = str;
                continue;
            }
            if (var.equals("file")) {
                this.file = str;
                continue;
            }
            if (var.equals("thread")) {
                this.threadId = str;
                continue;
            }
            if (var.equals("line")) {
                try {
                    this.line = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("times")) {
                try {
                    this.times = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("what") || var.equals("exp")) {
                this.what = str;
                continue;
            }
            if (var.equals("ignore")) {
                try {
                    this.ignore = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!var.equals("cond")) continue;
            this.cond = str;
        }
    }
}

