/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;

public class DsfMIWatchpointScopeEvent
extends DsfMIStoppedEvent {
    private static final long serialVersionUID = 8964634882368082346L;
    int number;

    public DsfMIWatchpointScopeEvent(DsfMIExecAsyncOutput async) {
        super(async);
        this.parse();
    }

    public DsfMIWatchpointScopeEvent(DsfMIResultRecord record) {
        super(record);
        this.parse();
    }

    public int getNumber() {
        return this.number;
    }

    void parse() {
        DsfMIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        DsfMIResultRecord rr = this.getMIResultRecord();
        DsfMIResult[] results = null;
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String str;
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                if (var.equals("wpnum")) {
                    if (!(value instanceof DsfMIConst)) continue;
                    str = ((DsfMIConst)value).getString();
                    try {
                        this.number = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (var.equals("thread-id")) {
                    if (!(value instanceof DsfMIConst)) continue;
                    str = ((DsfMIConst)value).getString();
                    try {
                        int id = Integer.parseInt(str.trim());
                        this.setThreadId(id);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!var.equals("frame") || !(value instanceof DsfMITuple)) continue;
                DsfMIFrame f = new DsfMIFrame((DsfMITuple)value);
                this.setFrame(f);
            }
        }
    }
}

