/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConsoleStreamOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIStreamRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfCLIInfoThreadsInfo
extends DsfMIInfo {
    protected List<ThreadInfo> info;

    public DsfCLIInfoThreadsInfo(DsfMIOutput out) {
        super(out);
        this.parse();
    }

    public List<ThreadInfo> getThreadInfo() {
        return this.info;
    }

    protected void parse() {
        this.info = new ArrayList<ThreadInfo>();
        if (this.isDone()) {
            DsfMIOutput out = this.getMIOutput();
            DsfMIOOBRecord[] oobs = out.getMIOOBRecords();
            for (int i = 0; i < oobs.length; ++i) {
                if (!(oobs[i] instanceof DsfMIConsoleStreamOutput)) continue;
                DsfMIStreamRecord cons = (DsfMIStreamRecord)oobs[i];
                String str = cons.getString();
                this.parseThreadInfo(str.trim(), this.info);
            }
        }
    }

    protected void parseThreadInfo(String str, List<ThreadInfo> info) {
        if (str.length() > 0) {
            Pattern pattern = Pattern.compile("(^\\d*|^\\*\\s*\\d*)(\\s*Thread\\s*)(\\d*)(\\s*\\(LWP\\s*)(\\d*)", 8);
            Matcher matcher = pattern.matcher(str);
            boolean isCurrentThread = false;
            if (matcher.find()) {
                String id = matcher.group(1);
                if (id.charAt(0) == '*') {
                    isCurrentThread = true;
                    id = id.substring(1).trim();
                }
                info.add(new ThreadInfo(id, matcher.group(5), "", isCurrentThread));
            }
        }
    }

    public class ThreadInfo {
        String fName;
        String fGdbId;
        String fPid;
        boolean fIsCurrentThread = false;

        public ThreadInfo(String tid, String pid, String name, boolean isCurrentThread) {
            this.fName = name;
            this.fGdbId = tid;
            this.fPid = pid;
            this.fIsCurrentThread = isCurrentThread;
        }

        public String getName() {
            return this.fName;
        }

        public String getId() {
            return this.fGdbId;
        }

        public String getOsId() {
            return this.fPid;
        }

        public boolean isCurrentThread() {
            return this.fIsCurrentThread;
        }
    }
}

