/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.math.BigInteger;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.debug.core.model.MemoryByte;

public class DsfMIDataReadMemoryInfo
extends DsfMIInfo {
    BigInteger fAddress = new BigInteger("0");
    int fBytesRead;
    int fBytesRequested;
    MemoryByte[] fMemoryBlock = new MemoryByte[0];

    public DsfMIDataReadMemoryInfo(DsfMIOutput output) {
        super(output);
        if (this.isDone()) {
            this.parseResult(1);
        }
    }

    public DsfMIDataReadMemoryInfo(DsfMIOutput output, int word_size) {
        super(output);
        if (this.isDone()) {
            this.parseResult(word_size);
        }
    }

    private void parseResult(int word_size) {
        DsfMIOutput output = this.getMIOutput();
        DsfMIResultRecord record = output.getMIResultRecord();
        if (record != null) {
            DsfMIResult[] results = record.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String size;
                DsfMIValue value;
                String var = results[i].getVariable();
                if (var.equals("addr") && (value = results[i].getMIValue()) instanceof DsfMIConst) {
                    String address = ((DsfMIConst)value).getCString();
                    this.fAddress = new BigInteger(address.substring(2), 16);
                }
                if (var.equals("total-bytes") && (value = results[i].getMIValue()) instanceof DsfMIConst) {
                    size = ((DsfMIConst)value).getCString();
                    this.fBytesRead = Integer.parseInt(size);
                }
                if (var.equals("total-bytes") && (value = results[i].getMIValue()) instanceof DsfMIConst) {
                    size = ((DsfMIConst)value).getCString();
                    this.fBytesRequested = Integer.parseInt(size);
                    this.fMemoryBlock = new MemoryByte[this.fBytesRequested];
                    for (int j = 0; j < this.fMemoryBlock.length; ++j) {
                        this.fMemoryBlock[j] = new MemoryByte(0, 0);
                    }
                }
                if (!var.equals("memory") || !((value = results[i].getMIValue()) instanceof DsfMIList)) continue;
                this.parseMemoryLines((DsfMIList)value, word_size);
            }
        }
    }

    private void parseMemoryLines(DsfMIList lines, int word_size) {
        DsfMIValue[] lineValues = lines.getMIValues();
        for (int i = 0; i < lineValues.length; ++i) {
            DsfMIValue value;
            if (!(lineValues[i] instanceof DsfMITuple)) continue;
            DsfMITuple tuple = (DsfMITuple)lineValues[i];
            DsfMIResult[] results = tuple.getMIResults();
            int offset = 0;
            DsfMIValue addrValue = results[0].getMIValue();
            if (addrValue instanceof DsfMIConst) {
                String address = ((DsfMIConst)addrValue).getCString();
                BigInteger startAddress = new BigInteger(address.substring(2), 16);
                offset = startAddress.subtract(this.fAddress).intValue();
            }
            if (!((value = results[1].getMIValue()) instanceof DsfMIList)) continue;
            DsfMIList list = (DsfMIList)value;
            DsfMIValue[] values = list.getMIValues();
            MemoryByte[] byteValues = new MemoryByte[values.length * word_size];
            for (int j = 0; j < values.length; ++j) {
                if (!(values[j] instanceof DsfMIConst)) continue;
                String str = ((DsfMIConst)values[j]).getCString();
                try {
                    long word = Long.decode(str.trim());
                    for (int k = 0; k < word_size; ++k) {
                        int bit_shift = (word_size - k - 1) * 8;
                        byteValues[j * word_size + k] = new MemoryByte((byte)((word >> bit_shift) % 256L));
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    for (int k = 0; k < word_size; ++k) {
                        byteValues[j * word_size + k] = new MemoryByte(-1, 0);
                    }
                }
            }
            System.arraycopy(byteValues, 0, this.fMemoryBlock, offset, byteValues.length);
        }
    }

    public MemoryByte[] getMIMemoryBlock() {
        return this.fMemoryBlock;
    }
}

