/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

public class DsfMIVar {
    String name = "";
    String type = "";
    String exp = "";
    int numchild;

    public DsfMIVar(String n, int num, String t) {
        this.name = n;
        this.numchild = num;
        this.type = t;
    }

    public DsfMIVar(DsfMITuple tuple) {
        this.parse(tuple);
    }

    public String getVarName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getNumChild() {
        return this.numchild;
    }

    public String getExp() {
        return this.exp;
    }

    void parse(DsfMITuple tuple) {
        DsfMIResult[] results = tuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof DsfMIConst) {
                str = ((DsfMIConst)value).getCString();
            }
            if (var.equals("numchild")) {
                try {
                    this.numchild = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("name")) {
                this.name = str;
                continue;
            }
            if (var.equals("type")) {
                this.type = str;
                continue;
            }
            if (!var.equals("exp")) continue;
            this.exp = str;
        }
    }
}

