/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetChildCount;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetChildren;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetValue;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetVar;
import org.eclipse.dd.dsf.mi.core.command.DsfMIDataEvaluateExpression;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetChildCountInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetChildrenInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetValueInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetVarInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIDataEvaluateExpressionInfo;
import org.eclipse.dd.dsf.mi.service.MIVariableManager;
import org.eclipse.dd.dsf.mi.service.control.MICommandCache;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.service.IDsfService;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionService
extends AbstractDsfService
implements IExpressions {
    private MICommandCache fExpressionCache;
    private MIVariableManager varManager;

    public ExpressionService(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleOK() {
                ExpressionService.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.getSession().addServiceEventListener((Object)this, null);
        this.varManager = new MIVariableManager(this.getSession(), this.getServicesTracker());
        this.fExpressionCache = new MICommandCache(this.varManager);
        this.register(new String[]{IExpressions.class.getName(), ExpressionService.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    public boolean isValid() {
        return true;
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext ctx, String expression) {
        return new ExpressionDMC(this, expression, ctx);
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
        return new IFormattedValues.FormattedValueDMContext((IDMService)this, (IDMContext)dmc, formatId);
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"BINARY.Format", "NATURAL.Format", "HEX.Format", "OCTAL.Format", "DECIMAL.Format"});
        rm.done();
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof ExpressionDMC) {
            this.getExpressionData((ExpressionDMC)dmc, rm);
        } else if (dmc instanceof IFormattedValues.FormattedValueDMContext) {
            this.getFormattedExpressionValue((IFormattedValues.FormattedValueDMContext)dmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public void getExpressionData(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
        this.fExpressionCache.execute(new DsfExprMetaGetVar(dmc), new DataRequestMonitor<DsfExprMetaGetVarInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                rm.setData((Object)new ExpressionDMData(((DsfExprMetaGetVarInfo)this.getData()).getExpr(), ((DsfExprMetaGetVarInfo)this.getData()).getType(), ((DsfExprMetaGetVarInfo)this.getData()).getNumChildren()));
                rm.done();
            }
        });
    }

    public void getExpressionAddressData(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMAddress> rm) {
        ExpressionDMC addressDmc = new ExpressionDMC(this, "&(" + dmc.getExpression() + ")", dmc.getParents());
        final ExpressionDMC sizeDmc = new ExpressionDMC(this, "sizeof(" + dmc.getExpression() + ")", dmc.getParents());
        this.fExpressionCache.execute(new DsfMIDataEvaluateExpression(addressDmc), new DataRequestMonitor<DsfMIDataEvaluateExpressionInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                final String addrStr = ((DsfMIDataEvaluateExpressionInfo)this.getData()).getValue();
                ExpressionService.this.fExpressionCache.execute(new DsfMIDataEvaluateExpression(sizeDmc), new DataRequestMonitor<DsfMIDataEvaluateExpressionInfo>((Executor)ExpressionService.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleOK() {
                        try {
                            int size = Integer.parseInt(((DsfMIDataEvaluateExpressionInfo)this.getData()).getValue());
                            rm.setData((Object)new ExpressionDMAddress(addrStr, size));
                        }
                        catch (NumberFormatException e) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unexpected size format from backend: " + ((DsfMIDataEvaluateExpressionInfo)this.getData()).getValue(), null));
                        }
                        rm.done();
                    }
                });
            }
        });
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        this.fExpressionCache.execute(new DsfExprMetaGetValue(dmc), new DataRequestMonitor<DsfExprMetaGetValueInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                rm.setData((Object)new IFormattedValues.FormattedValueDMData(((DsfExprMetaGetValueInfo)this.getData()).getValue()));
                rm.done();
            }
        });
    }

    public void getBaseExpressions(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Not supported", null));
        rm.done();
    }

    public void getSubExpressions(final IExpressions.IExpressionDMContext exprCtx, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        this.fExpressionCache.execute(new DsfExprMetaGetChildren(exprCtx), new DataRequestMonitor<DsfExprMetaGetChildrenInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                String[] childrenExpr = ((DsfExprMetaGetChildrenInfo)this.getData()).getChildrenExpressions();
                IExpressions.IExpressionDMContext[] childArray = new IExpressions.IExpressionDMContext[childrenExpr.length];
                for (int i = 0; i < childArray.length; ++i) {
                    childArray[i] = new ExpressionDMC(ExpressionService.this, childrenExpr[i], exprCtx.getParents());
                }
                rm.setData((Object)childArray);
                rm.done();
            }
        });
    }

    public void getSubExpressions(IExpressions.IExpressionDMContext exprCtx, final int startIndex, final int length, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        this.getSubExpressions(exprCtx, new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                rm.setData((Object)((IExpressions.IExpressionDMContext[])Arrays.asList((Object[])this.getData()).subList(startIndex, startIndex + length).toArray()));
                rm.done();
            }
        });
    }

    public void getSubExpressionCount(IExpressions.IExpressionDMContext exprCtx, final DataRequestMonitor<Integer> rm) {
        this.fExpressionCache.execute(new DsfExprMetaGetChildCount(exprCtx), new DataRequestMonitor<DsfExprMetaGetChildCountInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                rm.setData((Object)((DsfExprMetaGetChildCountInfo)this.getData()).getChildNum());
                rm.done();
            }
        });
    }

    public void writeExpression(final IExpressions.IExpressionDMContext expressionContext, String expressionValue, String formatId, final RequestMonitor rm) {
        this.varManager.writeValue((IDMContext)expressionContext, expressionValue, formatId, new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                ExpressionService.this.fExpressionCache.reset();
                ExpressionService.this.getSession().dispatchEvent((Object)new ExpressionChangedEvent(expressionContext), ExpressionService.this.getProperties());
                rm.done();
            }
        });
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fExpressionCache.setTargetAvailable(false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fExpressionCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fExpressionCache.setTargetAvailable(true);
        this.fExpressionCache.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpressionChangedEvent
    extends AbstractDMEvent<IExpressions.IExpressionDMContext>
    implements IExpressions.IExpressionChangedDMEvent {
        public ExpressionChangedEvent(IExpressions.IExpressionDMContext context) {
            super((IDMContext)context);
        }
    }

    public static class ExpressionDMAddress
    implements IExpressions.IExpressionDMAddress {
        IAddress fAddr;
        int fSize;

        public ExpressionDMAddress(IAddress addr, int size) {
            this.fAddr = addr;
            this.fSize = size;
        }

        public ExpressionDMAddress(String addrStr, int size) {
            this.fSize = size;
            this.fAddr = addrStr.length() <= 10 ? new Addr32(addrStr) : new Addr64(addrStr);
        }

        public IAddress getAddress() {
            return this.fAddr;
        }

        public int getSize() {
            return this.fSize;
        }

        public boolean equals(Object other) {
            if (other instanceof ExpressionDMAddress) {
                ExpressionDMAddress otherAddr = (ExpressionDMAddress)other;
                return this.fAddr.equals(otherAddr.getAddress()) && this.fSize == otherAddr.getSize();
            }
            return false;
        }

        public int hashCode() {
            return this.fAddr.hashCode() + this.fSize;
        }

        public String toString() {
            return "(0x" + this.fAddr.toString() + ", " + this.fSize + ")";
        }
    }

    public static class ExpressionDMC
    extends AbstractDMContext
    implements IExpressions.IExpressionDMContext {
        private final String expression;

        public ExpressionDMC(ExpressionService service, String expression, IDMContext parent) {
            this(service, expression, new IDMContext[]{parent});
        }

        public ExpressionDMC(ExpressionService service, String expr, IDMContext[] parentCtxs) {
            super((IDsfService)service, parentCtxs);
            this.expression = expr;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && this.expression.equals(((ExpressionDMC)((Object)other)).getExpression());
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.expression.hashCode();
        }

        public String toString() {
            return this.baseToString() + ".expr[" + this.expression + "]";
        }

        public String getExpression() {
            return this.expression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpressionDMData
    implements IExpressions.IExpressionDMData {
        private final String relativeExpression;
        private final String exprType;
        private final int numChildren;

        public ExpressionDMData(String expr, String type, int num) {
            this.relativeExpression = expr;
            this.exprType = type;
            this.numChildren = num;
        }

        public IExpressions.IExpressionDMData.BasicType getBasicType() {
            return null;
        }

        public int getBitCount() {
            return 0;
        }

        public int getSize() {
            return (this.getBitCount() + 7) / 8;
        }

        public String getEncoding() {
            return null;
        }

        public Map<String, Integer> getEnumerations() {
            return new HashMap<String, Integer>();
        }

        public String getName() {
            return this.relativeExpression;
        }

        public IRegisters.IRegisterDMContext getRegister() {
            return null;
        }

        public String getStringValue() {
            return null;
        }

        public String getTypeId() {
            return null;
        }

        public String getTypeName() {
            return this.exprType;
        }

        public int getNumChildren() {
            return this.numChildren;
        }
    }
}

