/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakDelete;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakInsert;
import org.eclipse.dd.dsf.mi.core.output.DsfMIBreakInsertInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.event.DsfMIBreakpointHitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIGDBExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIWatchpointTriggerEvent;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBreakpoints
extends AbstractDsfService
implements IBreakpointListener {
    ICommandControl fConnection;
    IRunControl fRunControl;
    ISourceLookup fSourceLookup;
    private String fDebugModelId;
    private Map<ICBreakpoint, Map<String, ?>> fPlatformBPs = new HashMap();
    private Map<ICBreakpoint, Integer> fBreakpointIds = new HashMap<ICBreakpoint, Integer>();
    private boolean fStarted = false;

    public MIBreakpoints(DsfSession session, String debugModelId) {
        super(session);
        this.fDebugModelId = debugModelId;
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleOK() {
                MIBreakpoints.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(final RequestMonitor requestMonitor) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        this.fSourceLookup = (ISourceLookup)this.getServicesTracker().getService(ISourceLookup.class);
        this.getSession().addServiceEventListener((Object)this, null);
        new Job("MI Debugger: Fetch initial breampoint list."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IBreakpoint[] bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(MIBreakpoints.this.fDebugModelId);
                    for (int i = 0; i < bps.length; ++i) {
                        if (!MIBreakpoints.this.supportsBreakpoint(bps[i])) continue;
                        Map attrs = bps[i].getMarker().getAttributes();
                        MIBreakpoints.this.fPlatformBPs.put((ICBreakpoint)bps[i], attrs);
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unable to read initial breakpoint attributes.", (Throwable)e);
                    requestMonitor.setStatus((IStatus)status);
                    requestMonitor.done();
                    return status;
                }
                MIBreakpoints.this.getExecutor().submit(new Runnable(){

                    public void run() {
                        MIBreakpoints.this.installInitBreakpoints(requestMonitor);
                    }
                });
                DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)MIBreakpoints.this);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void installInitBreakpoints(RequestMonitor requestMonitor) {
        this.fStarted = true;
        for (Map.Entry<ICBreakpoint, Map<String, ?>> entry : this.fPlatformBPs.entrySet()) {
            this.breakpointAdded(entry.getKey(), entry.getValue());
        }
        this.register(new String[]{MIBreakpoints.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.fStarted = false;
        this.unregister();
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        HashMap bps = new HashMap();
        bps.putAll(this.fPlatformBPs);
        for (Map.Entry<ICBreakpoint, Map<String, ?>> entry : this.fPlatformBPs.entrySet()) {
            this.breakpointRemoved(entry.getKey(), entry.getValue());
        }
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    @ThreadSafe
    public void breakpointAdded(final IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    final Map attrs = breakpoint.getMarker().getAttributes();
                    this.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            MIBreakpoints.this.breakpointAdded((ICBreakpoint)breakpoint, attrs);
                        }
                    });
                }
            }
            catch (CoreException e) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @ThreadSafe
    public void breakpointRemoved(final IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                final Map attrs = breakpoint.getMarker().getAttributes();
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        MIBreakpoints.this.breakpointRemoved((ICBreakpoint)breakpoint, attrs);
                    }
                });
            }
            catch (CoreException e) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @ThreadSafe
    public void breakpointChanged(final IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                final Map attrs = breakpoint.getMarker().getAttributes();
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        MIBreakpoints.this.breakpointChanged((ICBreakpoint)breakpoint, attrs);
                    }
                });
            }
            catch (CoreException e) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private boolean supportsBreakpoint(IBreakpoint bp) {
        IMarker marker;
        return bp instanceof ICBreakpoint && bp.getModelIdentifier().equals(this.fDebugModelId) && (marker = bp.getMarker()) != null;
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIBreakpointHitEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIWatchpointTriggerEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIGDBExitEvent e) {
        this.terminated();
    }

    private void terminated() {
        this.fStarted = false;
        this.clearBreakpointStatus(this.fPlatformBPs.keySet().toArray(new ICBreakpoint[this.fPlatformBPs.size()]));
        this.fPlatformBPs.clear();
    }

    private void breakpointAdded(final ICBreakpoint breakpoint, final Map<String, ?> attributes) {
        if (!this.fStarted) {
            return;
        }
        if (!this.fPlatformBPs.containsKey(breakpoint)) {
            this.fPlatformBPs.put(breakpoint, attributes);
        }
        String hostPath = breakpoint.getMarker().getResource().getName();
        this.fSourceLookup.getDebuggerPath(null, (Object)hostPath, (DataRequestMonitor)new DataRequestMonitor<String>((Executor)this.getExecutor(), null){

            protected void handleOK() {
                MIBreakpoints.this.doBreakpointAddedWithPath(breakpoint, attributes, (String)this.getData());
            }

            protected void handleErrorOrCancel() {
            }
        });
    }

    private void doBreakpointAddedWithPath(final ICBreakpoint breakpoint, Map<String, ?> attributes, String debugPath) {
        DsfMIBreakInsert cmd = new DsfMIBreakInsert(debugPath + ":" + attributes.get("lineNumber"));
        this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<DsfMIBreakInsertInfo>((Executor)this.getExecutor(), null){

            protected void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    return;
                }
                if (((DsfMIBreakInsertInfo)this.getData()).getMIBreakpoints().length > 0) {
                    MIBreakpoints.this.fBreakpointIds.put(breakpoint, ((DsfMIBreakInsertInfo)this.getData()).getMIBreakpoints()[0].getNumber());
                }
                MIBreakpoints.this.updateBreakpointStatus(breakpoint, true);
            }
        });
    }

    private void breakpointRemoved(final ICBreakpoint breakpoint, Map<String, ?> attributes) {
        if (!this.fStarted) {
            return;
        }
        Integer bpNum = this.fBreakpointIds.get(breakpoint);
        if (bpNum == null) {
            return;
        }
        DsfMIBreakDelete cmd = new DsfMIBreakDelete(new int[]{bpNum});
        this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), null){

            protected void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    return;
                }
                MIBreakpoints.this.fBreakpointIds.remove(breakpoint);
            }
        });
        this.fPlatformBPs.remove(breakpoint);
    }

    private void breakpointChanged(ICBreakpoint breakpoint, Map<String, ?> attributes) {
    }

    private void updateBreakpointStatus(final ICBreakpoint bp, final boolean set) {
        new Job("Update Breakpoint Status"){

            protected IStatus run(IProgressMonitor monitor) {
                final IMarker marker = bp.getMarker();
                if (marker == null) {
                    return new Status(2, "org.eclipse.dsdp.debug.gdb.core", 1, "No marker associated with breakpoint.", null);
                }
                IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor2) throws CoreException {
                        if (marker == null) {
                            throw new DebugException((IStatus)new Status(2, "org.eclipse.dsdp.debug.gdb.core", 10004, "No marker associated with breakpoint.", null));
                        }
                        int count = marker.getAttribute("org.eclipse.cdt.debug.core.installCount", 0);
                        marker.setAttribute("org.eclipse.cdt.debug.core.installCount", set ? ++count : --count);
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(wr, ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(marker.getResource()), 0, null);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return new Status(0, "org.eclipse.dsdp.debug.gdb.core", 1, "", null);
            }
        }.schedule();
    }

    private void clearBreakpointStatus(final ICBreakpoint[] bps) {
        new Job("Clear Breakpoints Status"){

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        for (ICBreakpoint bp : bps) {
                            IMarker marker = bp.getMarker();
                            if (marker == null) continue;
                            int count = marker.getAttribute("org.eclipse.cdt.debug.core.installCount", 0);
                            marker.setAttribute("org.eclipse.cdt.debug.core.installCount", --count);
                        }
                    }
                };
                ISchedulingRule rule = null;
                ArrayList<ISchedulingRule> markerRules = new ArrayList<ISchedulingRule>();
                for (ICBreakpoint bp : bps) {
                    IMarker marker = bp.getMarker();
                    if (marker == null) continue;
                    ISchedulingRule markerRule = ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(marker.getResource());
                    if (markerRule == null) {
                        markerRules = null;
                        break;
                    }
                    markerRules.add(markerRule);
                }
                if (markerRules != null) {
                    rule = MultiRule.combine((ISchedulingRule[])markerRules.toArray(new ISchedulingRule[markerRules.size()]));
                }
                try {
                    ResourcesPlugin.getWorkspace().run(wr, rule, 0, null);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

