/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecContinue;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecFinish;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecInterrupt;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecNext;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecStep;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecUntil;
import org.eclipse.dd.dsf.mi.core.command.DsfMIThreadListIds;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIThreadListIdsInfo;
import org.eclipse.dd.dsf.mi.event.DsfMIBreakpointHitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIErrorEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIGDBExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIRunningEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISharedLibEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISignalEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISteppingRangeEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIThreadCreatedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIThreadExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIWatchpointTriggerEvent;
import org.eclipse.dd.dsf.mi.service.control.AbstractMIControl;
import org.eclipse.dd.dsf.mi.service.control.MICommandCache;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.service.IDsfService;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIRunControl
extends AbstractDsfService
implements IRunControl {
    private MIContainerDMC fContainerDmc;
    private ICommandControl fConnection;
    private MICommandCache fMICommandCache;
    private boolean fSuspended = true;
    private boolean fResumePending = false;
    private boolean fStepping = false;
    private boolean fTerminated = false;
    private IRunControl.StateChangeReason fStateChangeReason;
    private IRunControl.IExecutionDMContext fStateChangeTriggeringContext;
    private static final int NO_THREAD_ID = 0;

    public MIRunControl(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIRunControl.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fContainerDmc = new MIContainerDMC(this);
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fMICommandCache = new MICommandCache(this.fConnection);
        this.getSession().addServiceEventListener((Object)this, null);
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.getSession().removeServiceEventListener((Object)this);
        this.fMICommandCache.reset();
        super.shutdown(rm);
    }

    public boolean isValid() {
        return true;
    }

    public IRunControl.IContainerDMContext getContainerDMC() {
        return this.fContainerDmc;
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof IRunControl.IExecutionDMContext) {
            this.getExecutionData((IRunControl.IExecutionDMContext)dmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public MICommandCache getCache() {
        return this.fMICommandCache;
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIRunningEvent e) {
        MIExecutionDMC triggeringCtx = e.getThreadId() != -1 ? new MIExecutionDMC(this, e.getThreadId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerResumedEvent(this.fContainerDmc, triggeringCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIStoppedEvent e) {
        MIExecutionDMC triggeringCtx = e.getThreadId() != -1 ? new MIExecutionDMC(this, e.getThreadId()) : null;
        this.getSession().dispatchEvent((Object)new ContainerSuspendedEvent(this.fContainerDmc, triggeringCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIThreadCreatedEvent e) {
        MIExecutionDMC executionCtx = e.getId() != -1 ? new MIExecutionDMC(this, e.getId()) : null;
        this.getSession().dispatchEvent((Object)new StartedDMEvent(this.fContainerDmc, executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIThreadExitEvent e) {
        MIExecutionDMC executionCtx = e.getId() != -1 ? new MIExecutionDMC(this, e.getId()) : null;
        this.getSession().dispatchEvent((Object)new ExitedDMEvent(this.fContainerDmc, executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(ContainerResumedEvent e) {
        this.fSuspended = false;
        this.fResumePending = false;
        this.fStateChangeReason = e.getReason();
        this.fMICommandCache.setTargetAvailable(false);
        if (e.getReason().equals((Object)IRunControl.StateChangeReason.STEP)) {
            this.fStepping = true;
        } else {
            this.fMICommandCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ContainerSuspendedEvent e) {
        this.fMICommandCache.setTargetAvailable(true);
        this.fMICommandCache.reset();
        this.fStateChangeReason = e.getReason();
        this.fStateChangeTriggeringContext = e.getTriggeringContext();
        this.fSuspended = true;
        this.fStepping = false;
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIGDBExitEvent e) {
        this.fTerminated = true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(StartedDMEvent e) {
        ((AbstractMIControl)this.fConnection).resetCurrentThreadLevel();
    }

    @DsfServiceEventHandler
    public void eventDispatched(ExitedDMEvent e) {
        this.fMICommandCache.reset((IDMContext)e.getExecutionContext());
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    public boolean canResume(IDMContext context) {
        return !this.fTerminated && this.isSuspended(context) && !this.fResumePending;
    }

    public boolean canSuspend(IDMContext context) {
        return !this.fTerminated && !this.isSuspended(context);
    }

    public boolean isSuspended(IDMContext context) {
        return !this.fTerminated && this.fSuspended;
    }

    public boolean isStepping(IDMContext context) {
        return !this.fTerminated && this.fStepping;
    }

    public void resume(IDMContext context, final RequestMonitor rm) {
        assert (context != null);
        if (this.canResume(context)) {
            this.fResumePending = true;
            this.fMICommandCache.setTargetAvailable(false);
            DsfMIExecContinue cmd = null;
            if (context instanceof MIContainerDMC) {
                cmd = new DsfMIExecContinue((MIContainerDMC)context);
            } else {
                MIExecutionDMC dmc = (MIExecutionDMC)DMContexts.getAncestorOfType((IDMContext)context, MIExecutionDMC.class);
                if (dmc == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + " is not an execution context.", null));
                    rm.done();
                    return;
                }
                cmd = new DsfMIExecContinue(dmc);
            }
            this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + ", is already running.", null));
            rm.done();
        }
    }

    public void suspend(IDMContext context, final RequestMonitor rm) {
        assert (context != null);
        if (this.canSuspend(context)) {
            DsfMIExecInterrupt cmd = null;
            if (context instanceof MIContainerDMC) {
                cmd = new DsfMIExecInterrupt((MIContainerDMC)context);
            } else {
                MIExecutionDMC dmc = (MIExecutionDMC)DMContexts.getAncestorOfType((IDMContext)context, MIExecutionDMC.class);
                if (dmc == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + " is not an execution context.", null));
                    rm.done();
                    return;
                }
                cmd = new DsfMIExecInterrupt(dmc);
            }
            this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + ", is already suspended.", null));
            rm.done();
        }
    }

    public boolean canStep(IDMContext context) {
        return this.canResume(context);
    }

    public void step(IDMContext context, IRunControl.StepType stepType, RequestMonitor rm) {
        assert (context != null);
        MIExecutionDMC dmc = (MIExecutionDMC)DMContexts.getAncestorOfType((IDMContext)context, MIExecutionDMC.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (!this.canResume(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        this.fResumePending = true;
        this.fStepping = true;
        this.fMICommandCache.setTargetAvailable(false);
        switch (stepType) {
            case STEP_INTO: {
                this.fConnection.queueCommand((ICommand)new DsfMIExecStep(dmc, 1), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){});
                break;
            }
            case STEP_OVER: {
                this.fConnection.queueCommand((ICommand)new DsfMIExecNext(dmc), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){});
                break;
            }
            case STEP_RETURN: {
                this.fConnection.queueCommand((ICommand)new DsfMIExecFinish(dmc), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){});
                break;
            }
            default: {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Given step type not supported", null));
                rm.done();
            }
        }
    }

    public boolean canInstructionStep(IDMContext context) {
        return false;
    }

    public void instructionStep(IDMContext context, IRunControl.StepType stepType, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Operation not implemented", null));
        rm.done();
    }

    public void getExecutionContexts(IRunControl.IContainerDMContext c, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        if (c != null && c.equals((Object)this.fContainerDmc)) {
            this.fMICommandCache.execute(new DsfMIThreadListIds(), new DataRequestMonitor<DsfMIThreadListIdsInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    rm.setData((Object)MIRunControl.this.makeExecutionDMCs((DsfMIThreadListIdsInfo)this.getData()));
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Invalid Container", null));
            rm.done();
        }
    }

    private IRunControl.IExecutionDMContext[] makeExecutionDMCs(DsfMIThreadListIdsInfo info) {
        if (info.getThreadIds().length == 0) {
            return new MIExecutionDMC[]{new MIExecutionDMC(this, 0)};
        }
        IRunControl.IExecutionDMContext[] executionDmcs = new MIExecutionDMC[info.getThreadIds().length];
        for (int i = 0; i < info.getThreadIds().length; ++i) {
            executionDmcs[i] = new MIExecutionDMC(this, info.getThreadIds()[i]);
        }
        return executionDmcs;
    }

    public void getExecutionData(IRunControl.IExecutionDMContext dmc, DataRequestMonitor<IRunControl.IExecutionDMData> rm) {
        if (dmc instanceof MIContainerDMC) {
            rm.setData((Object)new ExecutionData(this.fStateChangeReason));
        } else if (dmc instanceof MIExecutionDMC) {
            IRunControl.StateChangeReason reason = dmc.equals(this.fStateChangeTriggeringContext) ? this.fStateChangeReason : IRunControl.StateChangeReason.CONTAINER;
            rm.setData((Object)new ExecutionData(reason));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Given context: " + dmc + " is not an execution context.", null));
        }
        rm.done();
    }

    public void runToLine(IDMContext context, String fileName, String lineNo, boolean skipBreakpoints, final DataRequestMonitor<DsfMIInfo> rm) {
        assert (context != null);
        MIExecutionDMC dmc = (MIExecutionDMC)DMContexts.getAncestorOfType((IDMContext)context, MIExecutionDMC.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (this.canResume(context)) {
            this.fResumePending = true;
            this.fMICommandCache.setTargetAvailable(false);
            this.fConnection.queueCommand((ICommand)new DsfMIExecUntil(dmc, fileName + ":" + lineNo), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Cannot resume given DMC.", null));
            rm.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContainerResumedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, DsfMIRunningEvent>
    implements IRunControl.IContainerResumedDMEvent {
        final MIExecutionDMC triggeringDmc;

        ContainerResumedEvent(MIContainerDMC containerDmc, MIExecutionDMC triggeringDmc, DsfMIRunningEvent miInfo) {
            super(containerDmc, miInfo);
            this.triggeringDmc = triggeringDmc;
        }

        public IRunControl.StateChangeReason getReason() {
            switch (((DsfMIRunningEvent)this.getMIEvent()).getType()) {
                case 0: {
                    return IRunControl.StateChangeReason.USER_REQUEST;
                }
                case 1: 
                case 2: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 3: 
                case 4: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 5: {
                    return IRunControl.StateChangeReason.STEP;
                }
            }
            return IRunControl.StateChangeReason.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContainerSuspendedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, DsfMIStoppedEvent>
    implements IRunControl.IContainerSuspendedDMEvent {
        final MIExecutionDMC triggeringDmc;

        ContainerSuspendedEvent(MIContainerDMC containerDmc, MIExecutionDMC triggeringDmc, DsfMIStoppedEvent miInfo) {
            super(containerDmc, miInfo);
            this.triggeringDmc = triggeringDmc;
        }

        public IRunControl.StateChangeReason getReason() {
            if (this.getMIEvent() instanceof DsfMIBreakpointHitEvent) {
                return IRunControl.StateChangeReason.BREAKPOINT;
            }
            if (this.getMIEvent() instanceof DsfMISteppingRangeEvent) {
                return IRunControl.StateChangeReason.STEP;
            }
            if (this.getMIEvent() instanceof DsfMISharedLibEvent) {
                return IRunControl.StateChangeReason.SHAREDLIB;
            }
            if (this.getMIEvent() instanceof DsfMISignalEvent) {
                return IRunControl.StateChangeReason.SIGNAL;
            }
            if (this.getMIEvent() instanceof DsfMIWatchpointTriggerEvent) {
                return IRunControl.StateChangeReason.WATCHPOINT;
            }
            if (this.getMIEvent() instanceof DsfMIErrorEvent) {
                return IRunControl.StateChangeReason.ERROR;
            }
            return IRunControl.StateChangeReason.USER_REQUEST;
        }

        public IRunControl.IExecutionDMContext getTriggeringContext() {
            return this.triggeringDmc;
        }
    }

    private static class ExecutionData
    implements IRunControl.IExecutionDMData {
        private final IRunControl.StateChangeReason fReason;

        ExecutionData(IRunControl.StateChangeReason reason) {
            this.fReason = reason;
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return this.fReason;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExitedDMEvent
    extends RunControlEvent<IRunControl.IContainerDMContext, DsfMIThreadExitEvent>
    implements IRunControl.IExitedDMEvent {
        private final MIExecutionDMC fExecutionDmc;

        ExitedDMEvent(MIContainerDMC containerDmc, MIExecutionDMC executionDmc, DsfMIThreadExitEvent miInfo) {
            super(containerDmc, miInfo);
            this.fExecutionDmc = executionDmc;
        }

        public IRunControl.IExecutionDMContext getExecutionContext() {
            return this.fExecutionDmc;
        }
    }

    public static class MIContainerDMC
    extends AbstractDMContext
    implements IRunControl.IContainerDMContext {
        public MIContainerDMC(MIRunControl service) {
            super((IDsfService)service, new IDMContext[0]);
        }

        public String toString() {
            return this.baseToString() + ".container";
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }

    public static class MIExecutionDMC
    extends AbstractDMContext
    implements IRunControl.IExecutionDMContext {
        private final int fThreadId;

        public MIExecutionDMC(MIRunControl service, int threadId) {
            super((IDsfService)service, new IDMContext[]{service.getContainerDMC()});
            this.fThreadId = threadId;
        }

        public int getThreadId() {
            return this.fThreadId;
        }

        public String toString() {
            return this.baseToString() + ".thread[" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && ((MIExecutionDMC)((Object)obj)).fThreadId == this.fThreadId;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode() ^ this.fThreadId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunControlEvent<V extends IDMContext, T extends DsfMIEvent>
    extends AbstractDMEvent<V>
    implements IDMEvent<V> {
        private T fMIInfo;

        public RunControlEvent(V dmc, T miInfo) {
            super(dmc);
            this.fMIInfo = miInfo;
        }

        public T getMIEvent() {
            return this.fMIInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartedDMEvent
    extends RunControlEvent<IRunControl.IContainerDMContext, DsfMIThreadCreatedEvent>
    implements IRunControl.IStartedDMEvent {
        private final MIExecutionDMC fExecutionDmc;

        StartedDMEvent(MIContainerDMC containerDmc, MIExecutionDMC executionDmc, DsfMIThreadCreatedEvent miInfo) {
            super(containerDmc, miInfo);
            this.fExecutionDmc = executionDmc;
        }

        public IRunControl.IExecutionDMContext getExecutionContext() {
            return this.fExecutionDmc;
        }
    }
}

