/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConsoleStreamOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIStreamRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfCLIInfoSharedLibraryInfo
extends DsfMIInfo {
    DsfMISharedInfo[] shared;

    public DsfCLIInfoSharedLibraryInfo(DsfMIOutput out) {
        super(out);
        this.parse();
    }

    public DsfMISharedInfo[] getMIShared() {
        return this.shared;
    }

    void parse() {
        ArrayList<DsfMISharedInfo> aList = new ArrayList<DsfMISharedInfo>();
        if (this.isDone()) {
            DsfMIOutput out = this.getMIOutput();
            DsfMIOOBRecord[] oobs = out.getMIOOBRecords();
            for (int i = 0; i < oobs.length; ++i) {
                if (!(oobs[i] instanceof DsfMIConsoleStreamOutput)) continue;
                DsfMIStreamRecord cons = (DsfMIStreamRecord)oobs[i];
                String str = cons.getString();
                this.parseShared(str.trim(), aList);
            }
        }
        this.shared = new DsfMISharedInfo[aList.size()];
        for (int i = 0; i < aList.size(); ++i) {
            this.shared[i] = (DsfMISharedInfo)aList.get(i);
        }
    }

    void parseShared(String str, List<DsfMISharedInfo> aList) {
        Pattern pattern;
        Matcher matcher;
        if (str.length() > 0 && (matcher = (pattern = Pattern.compile("(0x.*)(0x.*)(Yes|No)(\\s*)(.*)", 8)).matcher(str)).find()) {
            DsfMISharedInfo s = new DsfMISharedInfo(matcher.group(1), matcher.group(2), matcher.group(3).equals("Yes"), matcher.group(5));
            aList.add(s);
        }
    }

    public class DsfMISharedInfo {
        String from;
        String to;
        boolean isread;
        String name;

        public DsfMISharedInfo(String start, String end, boolean read, String location) {
            this.from = start;
            this.to = end;
            this.isread = read;
            this.name = location;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public boolean isRead() {
            return this.isread;
        }

        public String getName() {
            return this.name;
        }

        public void setSymbolsRead(boolean read) {
            this.isread = read;
        }
    }
}

