/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIBreakpoint;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

public class DsfMIBreakInsertInfo
extends DsfMIInfo {
    DsfMIBreakpoint[] breakpoints = null;

    public DsfMIBreakInsertInfo(DsfMIOutput record) {
        super(record);
        DsfMIResultRecord rr;
        ArrayList<DsfMIBreakpoint> aList = new ArrayList<DsfMIBreakpoint>(1);
        if (this.isDone() && (rr = record.getMIResultRecord()) != null) {
            DsfMIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue val = results[i].getMIValue();
                DsfMIBreakpoint bpt = null;
                if (var.equals("wpt")) {
                    if (val instanceof DsfMITuple) {
                        bpt = new DsfMIBreakpoint((DsfMITuple)val);
                        bpt.setEnabled(true);
                        bpt.setWriteWatchpoint(true);
                    }
                } else if (var.equals("bkpt")) {
                    if (val instanceof DsfMITuple) {
                        bpt = new DsfMIBreakpoint((DsfMITuple)val);
                        bpt.setEnabled(true);
                    }
                } else if (var.equals("hw-awpt")) {
                    if (val instanceof DsfMITuple) {
                        bpt = new DsfMIBreakpoint((DsfMITuple)val);
                        bpt.setAccessWatchpoint(true);
                        bpt.setEnabled(true);
                    }
                } else if (var.equals("hw-rwpt") && val instanceof DsfMITuple) {
                    bpt = new DsfMIBreakpoint((DsfMITuple)val);
                    bpt.setReadWatchpoint(true);
                    bpt.setEnabled(true);
                }
                if (bpt == null) continue;
                aList.add(bpt);
            }
        }
        this.breakpoints = aList.toArray(new DsfMIBreakpoint[aList.size()]);
    }

    public DsfMIBreakpoint[] getMIBreakpoints() {
        return this.breakpoints;
    }
}

