/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;

public class DsfMIBreakpoint {
    int number = -1;
    String type = "";
    String disp = "";
    boolean enabled = false;
    String address = "";
    String func = "";
    String fullName = "";
    String file = "";
    int line = -1;
    String cond = "";
    int times = 0;
    String exp = "";
    String threadId = "0";
    int ignore = 0;
    boolean isWpt = false;
    boolean isAWpt = false;
    boolean isRWpt = false;
    boolean isWWpt = false;
    boolean isHdw = false;

    public DsfMIBreakpoint() {
    }

    public DsfMIBreakpoint(DsfMIBreakpoint other) {
        this.number = other.number;
        this.type = new String(other.type);
        this.disp = new String(other.disp);
        this.enabled = other.enabled;
        this.type = new String(other.type);
        this.address = new String(other.address);
        this.func = new String(other.func);
        this.fullName = new String(other.fullName);
        this.file = new String(other.file);
        this.line = other.line;
        this.cond = new String(other.cond);
        this.times = other.times;
        this.exp = new String(other.exp);
        this.threadId = new String(other.threadId);
        this.ignore = other.ignore;
        this.isWpt = other.isWpt;
        this.isAWpt = other.isAWpt;
        this.isRWpt = other.isRWpt;
        this.isWWpt = other.isWWpt;
        this.isHdw = other.isHdw;
    }

    public DsfMIBreakpoint(DsfMITuple tuple) {
        this.parse(tuple);
    }

    public int getNumber() {
        return this.number;
    }

    public String getType() {
        return this.type;
    }

    public String getDisposition() {
        return this.disp;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public String getAddress() {
        return this.address;
    }

    public String getFunction() {
        return this.func;
    }

    public String getFile() {
        return this.file;
    }

    public String getFullName() {
        return this.fullName;
    }

    public int getLine() {
        return this.line;
    }

    public String getCondition() {
        return this.cond;
    }

    public void setCondition(String condition) {
        this.cond = condition;
    }

    public int getIgnoreCount() {
        return this.ignore;
    }

    public void setIgnoreCount(int ignoreCount) {
        this.ignore = ignoreCount;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public int getTimes() {
        return this.times;
    }

    public String getExpression() {
        return this.exp;
    }

    public boolean isTemporary() {
        return this.getDisposition().equals("del");
    }

    public boolean isHardware() {
        return this.isHdw;
    }

    public void setHardware(boolean b) {
        this.isWpt = b;
        this.isHdw = b;
    }

    public boolean isWatchpoint() {
        return this.isWpt;
    }

    public void isWatchpoint(boolean b) {
        this.isWpt = b;
    }

    public boolean isAccessWatchpoint() {
        return this.isAWpt;
    }

    public void setAccessWatchpoint(boolean b) {
        this.isWpt = b;
        this.isAWpt = b;
    }

    public boolean isReadWatchpoint() {
        return this.isRWpt;
    }

    public void setReadWatchpoint(boolean b) {
        this.isWpt = b;
        this.isRWpt = b;
    }

    public boolean isWriteWatchpoint() {
        return this.isWWpt;
    }

    public void setWriteWatchpoint(boolean b) {
        this.isWpt = b;
        this.isWWpt = b;
    }

    void parse(DsfMITuple tuple) {
        DsfMIResult[] results = tuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof DsfMIConst) {
                str = ((DsfMIConst)value).getCString();
            }
            if (var.equals("number")) {
                try {
                    this.number = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("type")) {
                this.type = str;
                if (this.type.startsWith("hw")) {
                    this.isHdw = true;
                    this.isWWpt = true;
                    this.isWpt = true;
                }
                if (this.type.startsWith("acc")) {
                    this.isAWpt = true;
                    this.isWpt = true;
                }
                if (!this.type.startsWith("read")) continue;
                this.isRWpt = true;
                this.isWpt = true;
                continue;
            }
            if (var.equals("disp")) {
                this.disp = str;
                continue;
            }
            if (var.equals("enabled")) {
                this.enabled = str.equals("y");
                continue;
            }
            if (var.equals("addr")) {
                try {
                    this.address = str.trim();
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("func")) {
                this.func = str;
                continue;
            }
            if (var.equals("file")) {
                this.file = str;
                continue;
            }
            if (var.equals("fullname")) {
                this.fullName = str;
                continue;
            }
            if (var.equals("thread")) {
                this.threadId = str;
                continue;
            }
            if (var.equals("line")) {
                try {
                    this.line = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("times")) {
                try {
                    this.times = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("what") || var.equals("exp")) {
                this.exp = str;
                continue;
            }
            if (var.equals("ignore")) {
                try {
                    this.ignore = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!var.equals("cond")) continue;
            this.cond = str;
        }
    }
}

