/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.service.MIRunControl;

@Immutable
public class DsfMIFunctionFinishedEvent
extends DsfMIStoppedEvent {
    private final String gdbResult;
    private final String returnValue;
    private final String returnType;

    protected DsfMIFunctionFinishedEvent(IRunControl.IExecutionDMContext ctx, int token, DsfMIResult[] results, DsfMIFrame frame, String gdbResult, String returnValue, String returnType) {
        super(ctx, token, results, frame);
        this.gdbResult = gdbResult;
        this.returnValue = returnValue;
        this.returnType = returnType;
    }

    public String getGDBResultVar() {
        return this.gdbResult;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public static DsfMIFunctionFinishedEvent parse(MIRunControl runControl, IRunControl.IContainerDMContext containerDmc, int token, DsfMIResult[] results) {
        String gdbResult = "";
        String returnValue = "";
        String returnType = "";
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof DsfMIConst) {
                str = ((DsfMIConst)value).getString();
            }
            if (var.equals("gdb-result-var")) {
                gdbResult = str;
                continue;
            }
            if (var.equals("return-value")) {
                returnValue = str;
                continue;
            }
            if (!var.equals("return-type")) continue;
            returnType = str;
        }
        DsfMIStoppedEvent stoppedEvent = DsfMIStoppedEvent.parse(runControl, containerDmc, token, results);
        return new DsfMIFunctionFinishedEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), gdbResult, returnValue, returnType);
    }
}

