/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakAfter;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakCondition;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakDelete;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakDisable;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakEnable;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakInsert;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakList;
import org.eclipse.dd.dsf.mi.core.command.DsfMIBreakWatch;
import org.eclipse.dd.dsf.mi.core.common.MIBreakpointDMData;
import org.eclipse.dd.dsf.mi.core.output.DsfMIBreakInsertInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIBreakListInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIBreakpoint;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.event.DsfMIWatchpointScopeEvent;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBreakpoints
extends AbstractDsfService
implements IBreakpoints {
    ICommandControl fConnection;
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<Integer, MIBreakpointDMData>> fBreakpoints = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<Integer, MIBreakpointDMData>>();

    public MIBreakpoints(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIBreakpoints.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IBreakpoints.class.getName(), MIBreakpoints.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        rm.done();
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIWatchpointScopeEvent e) {
        this.fBreakpoints.remove(e.getNumber());
    }

    public void getBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext context, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]> drm) {
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            drm.done();
            return;
        }
        final Map<Integer, MIBreakpointDMData> breakpointContext = this.fBreakpoints.get(context);
        if (breakpointContext == null) {
            drm.setData((Object)new IBreakpoints.IBreakpointDMContext[0]);
            drm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new DsfMIBreakList(context), (DataRequestMonitor)new DataRequestMonitor<DsfMIBreakListInfo>((Executor)this.getExecutor(), drm){

            protected void handleOK() {
                breakpointContext.clear();
                DsfMIBreakpoint[] breakpoints = ((DsfMIBreakListInfo)this.getData()).getMIBreakpoints();
                IBreakpoints.IBreakpointDMContext[] result = new IBreakpoints.IBreakpointDMContext[breakpoints.length];
                for (int i = 0; i < breakpoints.length; ++i) {
                    MIBreakpointDMData breakpoint = new MIBreakpointDMData(breakpoints[i]);
                    int reference = breakpoint.getReference();
                    result[i] = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                    breakpointContext.put(reference, breakpoint);
                }
                drm.setData((Object)result);
                drm.done();
            }
        });
    }

    public void getBreakpointDMData(IBreakpoints.IBreakpointDMContext dmc, DataRequestMonitor<IBreakpoints.IBreakpointDMData> drm) {
        if (dmc == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            drm.done();
            return;
        }
        if (!(dmc instanceof MIBreakpointDMContext)) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint type", null));
            drm.done();
            return;
        }
        MIBreakpointDMContext breakpoint = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = breakpoint.getTargetContext();
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            drm.done();
            return;
        }
        Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            drm.done();
            return;
        }
        MIBreakpointDMData breakpointCopy = new MIBreakpointDMData(contextBreakpoints.get(breakpoint.getReference()));
        drm.setData((Object)breakpointCopy);
        drm.done();
    }

    public void insertBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        String type;
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            drm.done();
            return;
        }
        Map<Integer, MIBreakpointDMData> breakpointContext = this.fBreakpoints.get(context);
        if (breakpointContext == null) {
            breakpointContext = new HashMap<Integer, MIBreakpointDMData>();
            this.fBreakpoints.put(context, breakpointContext);
        }
        if ((type = (String)attributes.get("org.eclipse.dd.dsf.debug.breakpoint.type")) == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unsupported breakpoint type", null));
            drm.done();
            return;
        }
        if (type.equals("breakpoint")) {
            this.addBreakpoint(context, attributes, drm);
        } else if (type.equals("watchpoint")) {
            this.addWatchpoint(context, attributes, drm);
        } else {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unsupported breakpoint type", null));
            drm.done();
        }
    }

    public Object getProperty(Map<String, Object> map, String key, Object defaultValue) {
        return map.containsKey(key) && map.get(key) != null ? map.get(key) : defaultValue;
    }

    private String formatLocation(Map<String, Object> attributes) {
        String location = (String)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.address", "");
        String fileName = (String)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.fileName", "");
        Integer lineNumber = (Integer)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.lineNumber", -1);
        String function = (String)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.function", "");
        if (!fileName.equals("")) {
            location = lineNumber != -1 ? fileName + ":" + lineNumber : fileName + ":" + function;
        }
        return location;
    }

    private void addBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Uninitialized breakpoint context", null));
            drm.done();
            return;
        }
        String location = this.formatLocation(attributes);
        Boolean isTemporary = (Boolean)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.mi.isTemporary", false);
        Boolean isHardware = (Boolean)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.mi.isHardware", false);
        String condition = (String)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.condition", "");
        Integer ignoreCount = (Integer)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 0);
        String threadId = (String)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.mi.threadId", "0");
        int tid = Integer.parseInt(threadId);
        DataRequestMonitor<DsfMIBreakInsertInfo> addBreakpointDRM = new DataRequestMonitor<DsfMIBreakInsertInfo>((Executor)this.getExecutor(), drm){

            protected void handleOK() {
                if (((DsfMIBreakInsertInfo)this.getData()).getMIBreakpoints().length == 0) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Invalid breakpoint location", null));
                    drm.done();
                    return;
                }
                MIBreakpointDMData newBreakpoint = new MIBreakpointDMData(((DsfMIBreakInsertInfo)this.getData()).getMIBreakpoints()[0]);
                int reference = newBreakpoint.getNumber();
                if (reference == -1) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Breakpoint installation failed", null));
                    drm.done();
                    return;
                }
                contextBreakpoints.put(reference, newBreakpoint);
                MIBreakpointDMContext dmc = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                drm.setData((Object)dmc);
                MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointAddedEvent(dmc), MIBreakpoints.this.getProperties());
                HashMap<String, Object> delta = new HashMap<String, Object>();
                delta.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", MIBreakpoints.this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.isEnabled", true));
                MIBreakpoints.this.modifyBreakpoint(dmc, delta, (RequestMonitor)drm, false);
            }
        };
        this.fConnection.queueCommand((ICommand)new DsfMIBreakInsert(context, isTemporary, isHardware, condition, ignoreCount, location, tid), (DataRequestMonitor)addBreakpointDRM);
    }

    private void addWatchpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Uninitialized breakpoint context", null));
            drm.done();
            return;
        }
        String expression = (String)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.expression", "");
        boolean isRead = (Boolean)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.read", false);
        boolean isWrite = (Boolean)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.write", false);
        DataRequestMonitor<DsfMIBreakInsertInfo> addWatchpointDRM = new DataRequestMonitor<DsfMIBreakInsertInfo>((Executor)this.getExecutor(), drm){

            protected void handleOK() {
                if (((DsfMIBreakInsertInfo)this.getData()).getMIBreakpoints().length == 0) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Invalid watchpoint address", null));
                    drm.done();
                    return;
                }
                MIBreakpointDMData newBreakpoint = new MIBreakpointDMData(((DsfMIBreakInsertInfo)this.getData()).getMIBreakpoints()[0]);
                int reference = newBreakpoint.getNumber();
                if (reference == -1) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Breakpoint installation failed", null));
                    drm.done();
                    return;
                }
                contextBreakpoints.put(reference, newBreakpoint);
                MIBreakpointDMContext dmc = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                drm.setData((Object)dmc);
                MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointAddedEvent(dmc), MIBreakpoints.this.getProperties());
                HashMap<String, Object> delta = new HashMap<String, Object>();
                delta.put("org.eclipse.dd.dsf.debug.breakpoint.condition", MIBreakpoints.this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.condition", ""));
                delta.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", MIBreakpoints.this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", 0));
                delta.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", MIBreakpoints.this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.isEnabled", true));
                MIBreakpoints.this.modifyBreakpoint(dmc, delta, (RequestMonitor)drm, false);
            }
        };
        this.fConnection.queueCommand((ICommand)new DsfMIBreakWatch(context, isRead, isWrite, expression), (DataRequestMonitor)addWatchpointDRM);
    }

    public void removeBreakpoint(final IBreakpoints.IBreakpointDMContext dmc, final RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        if (!(dmc instanceof MIBreakpointDMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint type", null));
            rm.done();
            return;
        }
        MIBreakpointDMContext breakpointCtx = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = dmc.getTargetContext();
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            rm.done();
            return;
        }
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            rm.done();
            return;
        }
        final int reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        if (breakpoint == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new DsfMIBreakDelete(context, new int[]{reference}), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointRemovedEvent(dmc), MIBreakpoints.this.getProperties());
                contextBreakpoints.remove(reference);
                rm.done();
            }
        });
    }

    public void updateBreakpoint(IBreakpoints.IBreakpointDMContext dmc, Map<String, Object> properties, RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        if (!(dmc instanceof MIBreakpointDMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint type", null));
            rm.done();
            return;
        }
        MIBreakpointDMContext breakpointCtx = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = dmc.getTargetContext();
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            rm.done();
            return;
        }
        Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            rm.done();
            return;
        }
        int reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        if (breakpoint == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            rm.done();
            return;
        }
        this.modifyBreakpoint(dmc, properties, rm, true);
    }

    private void modifyBreakpoint(final IBreakpoints.IBreakpointDMContext dmc, Map<String, Object> properties, final RequestMonitor rm, final boolean generateUpdateEvent) {
        String enableAttribute;
        String ignoreCountAttribute;
        MIBreakpointDMContext breakpointCtx = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = dmc.getTargetContext();
        Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        int reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        int numberOfChanges = 0;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                if (generateUpdateEvent) {
                    MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointUpdatedEvent(dmc), MIBreakpoints.this.getProperties());
                }
                rm.done();
            }
        };
        String conditionAttribute = "org.eclipse.dd.dsf.debug.breakpoint.condition";
        if (properties.containsKey(conditionAttribute)) {
            String oldValue = breakpoint.getCondition();
            String newValue = (String)properties.get(conditionAttribute);
            if (newValue == null) {
                newValue = "";
            }
            if (!oldValue.equals(newValue)) {
                this.changeCondition(context, reference, newValue, (RequestMonitor)countingRm);
                ++numberOfChanges;
            }
            properties.remove(conditionAttribute);
        }
        if (properties.containsKey(ignoreCountAttribute = "org.eclipse.dd.dsf.debug.breakpoint.ignoreCount")) {
            Integer oldValue = breakpoint.getIgnoreCount();
            Integer newValue = (Integer)properties.get(ignoreCountAttribute);
            if (newValue == null) {
                newValue = 0;
            }
            if (!oldValue.equals(newValue)) {
                this.changeIgnoreCount(context, reference, newValue, (RequestMonitor)countingRm);
                ++numberOfChanges;
            }
            properties.remove(ignoreCountAttribute);
        }
        if (properties.containsKey(enableAttribute = "org.eclipse.dd.dsf.debug.breakpoint.isEnabled")) {
            Boolean oldValue = breakpoint.isEnabled();
            Boolean newValue = (Boolean)properties.get(enableAttribute);
            if (newValue == null) {
                newValue = false;
            }
            if (!oldValue.equals(newValue)) {
                ++numberOfChanges;
                if (newValue.booleanValue()) {
                    this.enableBreakpoint(context, reference, (RequestMonitor)countingRm);
                } else {
                    this.disableBreakpoint(context, reference, (RequestMonitor)countingRm);
                }
            }
            properties.remove(enableAttribute);
        }
        countingRm.setDoneCount(numberOfChanges);
    }

    private void changeCondition(IBreakpoints.IBreakpointsTargetDMContext context, final int reference, final String condition, final RequestMonitor rm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Uninitialized breakpoint context", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new DsfMIBreakCondition(context, reference, condition), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setCondition(condition);
                rm.done();
            }
        });
    }

    private void changeIgnoreCount(IBreakpoints.IBreakpointsTargetDMContext context, final int reference, final int ignoreCount, final RequestMonitor rm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Uninitialized breakpoint context", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new DsfMIBreakAfter(context, reference, ignoreCount), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setIgnoreCount(ignoreCount);
                rm.done();
            }
        });
    }

    private void enableBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, final int reference, final RequestMonitor rm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Uninitialized breakpoint context", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new DsfMIBreakEnable(context, new int[]{reference}), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setEnabled(true);
                rm.done();
            }
        });
    }

    private void disableBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, final int reference, final RequestMonitor rm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Uninitialized breakpoint context", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new DsfMIBreakDisable(context, new int[]{reference}), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setEnabled(false);
                rm.done();
            }
        });
    }

    public class BreakpointAddedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointAddedEvent {
        public BreakpointAddedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }

        public IBreakpoints.IBreakpointDMContext getAddedBreakpoint() {
            return this.getContext();
        }
    }

    public class BreakpointRemovedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointRemovedEvent {
        public BreakpointRemovedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }

        public IBreakpoints.IBreakpointDMContext getRemovedBreakpoint() {
            return this.getContext();
        }
    }

    public class BreakpointUpdatedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointUpdatedEvent {
        public BreakpointUpdatedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }

        public IBreakpoints.IBreakpointDMContext getUpdatedBreakpoint() {
            return this.getContext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BreakpointsChangedEvent
    extends AbstractDMEvent<IBreakpoints.IBreakpointDMContext>
    implements IBreakpoints.IBreakpointsChangedEvent {
        private IBreakpoints.IBreakpointDMContext fContext;

        public BreakpointsChangedEvent(IBreakpoints.IBreakpointDMContext context) {
            super((IDMContext)context);
            this.fContext = context;
        }

        protected IBreakpoints.IBreakpointDMContext getContext() {
            return this.fContext;
        }
    }

    @Immutable
    public static final class MIBreakpointDMContext
    extends AbstractDMContext
    implements IBreakpoints.IBreakpointDMContext {
        private final Integer fReference;

        public MIBreakpointDMContext(MIBreakpoints service, IDMContext[] parents, int reference) {
            super(service.getSession().getId(), parents);
            this.fReference = reference;
        }

        public IBreakpoints.IBreakpointsTargetDMContext getTargetContext() {
            return (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this, IBreakpoints.IBreakpointsTargetDMContext.class);
        }

        public int getReference() {
            return this.fReference;
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && this.fReference == ((MIBreakpointDMContext)((Object)obj)).fReference;
        }

        public int hashCode() {
            return this.baseHashCode() + this.fReference.hashCode();
        }

        public String toString() {
            return this.baseToString() + ".reference(" + this.fReference + ")";
        }
    }
}

