/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IBreakpointsManager;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.event.DsfMIGDBExitEvent;
import org.eclipse.dd.dsf.mi.service.MIBreakpoints;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBreakpointsManager
extends AbstractDsfService
implements IBreakpointsManager,
IBreakpointListener {
    private static final String ATTR_HOST_PATH = "org.eclipse.dsdp.debug.gdb.core.hostPath";
    private static final String ATTR_DEBUGGER_PATH = "org.eclipse.dsdp.debug.gdb.core.debuggerPath";
    ICommandControl fConnection;
    IRunControl fRunControl;
    ISourceLookup fSourceLookup;
    MIBreakpoints fBreakpoints;
    private String fDebugModelId;
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Map<String, Object>>> fPlatformBPs = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Map<String, Object>>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, IBreakpoints.IBreakpointDMContext>> fBreakpointIDs = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, IBreakpoints.IBreakpointDMContext>>();

    public MIBreakpointsManager(DsfSession session, String debugModelId) {
        super(session);
        this.fDebugModelId = debugModelId;
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleOK() {
                MIBreakpointsManager.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        this.fSourceLookup = (ISourceLookup)this.getServicesTracker().getService(ISourceLookup.class);
        this.fBreakpoints = (MIBreakpoints)this.getServicesTracker().getService(MIBreakpoints.class);
        this.getSession().addServiceEventListener((Object)this, null);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.register(new String[]{IBreakpointsManager.class.getName(), MIBreakpointsManager.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(final RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIBreakpointsManager.super.shutdown(rm);
            }
        };
        ArrayList<IBreakpoints.IBreakpointsTargetDMContext> platformBPKeysCopy = new ArrayList<IBreakpoints.IBreakpointsTargetDMContext>(this.fPlatformBPs.size());
        platformBPKeysCopy.addAll(0, this.fPlatformBPs.keySet());
        for (IBreakpoints.IBreakpointsTargetDMContext dmc : platformBPKeysCopy) {
            this.stopTrackingBreakpoints(dmc, (RequestMonitor)countingRm);
        }
        countingRm.setDoneCount(platformBPKeysCopy.size());
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    public void startTrackingBreakpoints(IBreakpoints.IBreakpointsTargetDMContext dmc, final RequestMonitor rm) {
        final IBreakpoints.IBreakpointsTargetDMContext breakpointsDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (breakpointsDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Unknown context type", null));
            rm.done();
            return;
        }
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs != null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Context already initialized", null));
            rm.done();
            return;
        }
        this.fPlatformBPs.put(breakpointsDmc, new HashMap());
        this.fBreakpointIDs.put(breakpointsDmc, new HashMap());
        new Job("MI Debugger: Install initial breakpoint list."){

            protected IStatus run(IProgressMonitor monitor) {
                final HashMap<ICBreakpoint, Map> initialPlatformBPs = new HashMap<ICBreakpoint, Map>();
                try {
                    IBreakpoint[] bps = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(MIBreakpointsManager.this.fDebugModelId);
                    for (int i = 0; i < bps.length; ++i) {
                        IPath location;
                        IResource resource;
                        if (!MIBreakpointsManager.this.supportsBreakpoint(bps[i])) continue;
                        Map attrs = bps[i].getMarker().getAttributes();
                        IMarker marker = bps[i].getMarker();
                        if (marker != null && (resource = marker.getResource()) != null && (location = resource.getLocation()) != null) {
                            attrs.put(MIBreakpointsManager.ATTR_HOST_PATH, location.toString());
                        }
                        initialPlatformBPs.put((ICBreakpoint)bps[i], attrs);
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unable to read initial breakpoint attributes.", (Throwable)e);
                    rm.setStatus((IStatus)status);
                    rm.done();
                    return status;
                }
                MIBreakpointsManager.this.getExecutor().submit(new Runnable(){

                    public void run() {
                        MIBreakpointsManager.this.installInitBreakpoints(breakpointsDmc, initialPlatformBPs, rm);
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void stopTrackingBreakpoints(IBreakpoints.IBreakpointsTargetDMContext dmc, RequestMonitor rm) {
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.remove(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Breakpoints not installed for given context", null));
            rm.done();
            return;
        }
        Map<ICBreakpoint, IBreakpoints.IBreakpointDMContext> breakpointIDs = this.fBreakpointIDs.remove(dmc);
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        countingRm.setDoneCount(platformBPs.size());
        for (final ICBreakpoint bp : platformBPs.keySet()) {
            this.uninstallBreakpoint(dmc, bp, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm){

                protected void handleCompleted() {
                    MIBreakpointsManager.this.updateBreakpointStatus(bp, false);
                    super.handleCompleted();
                }
            });
        }
        platformBPs.clear();
        breakpointIDs.clear();
    }

    private void installInitBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext dmc, Map<ICBreakpoint, Map<String, Object>> initialPlatformBPs, RequestMonitor rm) {
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        countingRm.setDoneCount(platformBPs.size());
        for (final ICBreakpoint bp : initialPlatformBPs.keySet()) {
            final Map<String, Object> attrs = initialPlatformBPs.get(bp);
            this.calcDebuggerPath(dmc, attrs, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm){

                protected void handleOK() {
                    MIBreakpointsManager.this.installBreakpoint(dmc, bp, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm));
                }
            });
        }
    }

    private void installBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, final ICBreakpoint breakpoint, Map<String, Object> attributes, final RequestMonitor rm) {
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        final Map<ICBreakpoint, IBreakpoints.IBreakpointDMContext> breakpointIDs = this.fBreakpointIDs.get(dmc);
        assert (breakpointIDs != null);
        if (platformBPs.containsKey(breakpoint)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Breakpoint already installed", null));
            rm.done();
            return;
        }
        String debuggerPath = (String)attributes.get(ATTR_DEBUGGER_PATH);
        if (debuggerPath == null || debuggerPath == "") {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "No debugger path for breakpoint", null));
            rm.done();
            return;
        }
        platformBPs.put(breakpoint, attributes);
        DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm = new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (this.getStatus().isOK()) {
                    MIBreakpoints.MIBreakpointDMContext ref = (MIBreakpoints.MIBreakpointDMContext)((Object)this.getData());
                    breakpointIDs.put(breakpoint, ref);
                    MIBreakpointsManager.this.updateBreakpointStatus(breakpoint, true);
                }
                rm.done();
            }
        };
        Map<String, Object> attrs = this.convertToMIBreakpoint(breakpoint, attributes);
        this.fBreakpoints.insertBreakpoint(dmc, attrs, drm);
    }

    private Map<String, Object> convertToMIBreakpoint(ICBreakpoint breakpoint, Map<String, Object> attributes) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (breakpoint instanceof ICWatchpoint) {
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.expression", attributes.get("org.eclipse.cdt.debug.core.expression"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.read", attributes.get("org.eclipse.cdt.debug.core.read"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.write", attributes.get("org.eclipse.cdt.debug.core.write"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", attributes.get("org.eclipse.debug.core.enabled"));
        } else {
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", attributes.get(ATTR_DEBUGGER_PATH));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", attributes.get("lineNumber"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.function", attributes.get("org.eclipse.cdt.debug.core.function"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.address", attributes.get("org.eclipse.cdt.debug.core.address"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.mi.threadId", attributes.get("org.eclipse.cdt.debug.core.threadId"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.condition", attributes.get("org.eclipse.cdt.debug.core.condition"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", attributes.get("org.eclipse.cdt.debug.core.ignoreCount"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", attributes.get("org.eclipse.debug.core.enabled"));
        }
        return properties;
    }

    private void uninstallBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext dmc, final ICBreakpoint breakpoint, final RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        if (breakpoint == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Breakpoint already un-installed", null));
            rm.done();
            return;
        }
        RequestMonitor removeRM = new RequestMonitor((Executor)this.getExecutor(), null){

            protected void handleOK() {
                Map platformBPs = (Map)MIBreakpointsManager.this.fPlatformBPs.get(dmc);
                if (platformBPs == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context", null));
                    rm.done();
                    return;
                }
                platformBPs.remove(breakpoint);
                Map breakpointIDs = (Map)MIBreakpointsManager.this.fBreakpointIDs.get(dmc);
                if (breakpointIDs == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Breakpoint doesn't exist", null));
                    rm.done();
                    return;
                }
                breakpointIDs.remove(breakpoint);
                rm.done();
            }
        };
        Map<ICBreakpoint, IBreakpoints.IBreakpointDMContext> breakpointIDs = this.fBreakpointIDs.get(dmc);
        if (breakpointIDs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Breakpoint doesn't exist", null));
            rm.done();
            return;
        }
        this.fBreakpoints.removeBreakpoint(breakpointIDs.get(breakpoint), removeRM);
    }

    private void modifyBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final ICBreakpoint breakpoint, final Map<String, Object> attributes, final RequestMonitor rm) {
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Invalid context", null));
            rm.done();
            return;
        }
        if (breakpoint == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Breakpoint doesn't exist", null));
            rm.done();
            return;
        }
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(context);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        Map<ICBreakpoint, IBreakpoints.IBreakpointDMContext> breakpointIDs = this.fBreakpointIDs.get(context);
        if (breakpointIDs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid breakpoint", null));
            rm.done();
            return;
        }
        Map<String, Object> oldAttributes = platformBPs.get(breakpoint);
        if (oldAttributes == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Breakpoint doesn't exist", null));
            rm.done();
            return;
        }
        IBreakpoints.IBreakpointDMContext dmc = breakpointIDs.get(breakpoint);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Breakpoint doesn't exist", null));
            rm.done();
            return;
        }
        final Map<String, Object> delta = this.getAttributesDelta(oldAttributes, attributes);
        final RequestMonitor updateRM = new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                Map platformBPs = (Map)MIBreakpointsManager.this.fPlatformBPs.get(context);
                if (platformBPs == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context", null));
                    rm.done();
                    return;
                }
                platformBPs.put(breakpoint, attributes);
                rm.done();
            }
        };
        DataRequestMonitor<IBreakpoints.IBreakpointDMContext> insertRM = new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), null){

            protected void handleOK() {
                Map breakpointIDs = (Map)MIBreakpointsManager.this.fBreakpointIDs.get(context);
                if (breakpointIDs == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Breakpoint doesn't exist", null));
                    rm.done();
                    return;
                }
                IBreakpoints.IBreakpointDMContext dmc = (IBreakpoints.IBreakpointDMContext)this.getData();
                breakpointIDs.put(breakpoint, dmc);
                MIBreakpointsManager.this.fBreakpoints.updateBreakpoint(dmc, delta, updateRM);
            }
        };
        RequestMonitor removeRM = new RequestMonitor((Executor)this.getExecutor(), null, (DataRequestMonitor)insertRM){
            final /* synthetic */ DataRequestMonitor val$insertRM;
            {
                this.val$insertRM = dataRequestMonitor;
                super(x0, x1);
            }

            protected void handleOK() {
                MIBreakpointsManager.this.fBreakpoints.insertBreakpoint(context, attributes, (DataRequestMonitor<IBreakpoints.IBreakpointDMContext>)this.val$insertRM);
            }
        };
        if (this.needsResinstallation(delta)) {
            this.fBreakpoints.removeBreakpoint(dmc, removeRM);
        } else {
            this.fBreakpoints.updateBreakpoint(dmc, delta, updateRM);
        }
    }

    private Map<String, Object> getAttributesDelta(Map<String, Object> oldAttributes, Map<String, Object> newAttributes) {
        HashMap<String, Object> delta = new HashMap<String, Object>();
        Set<String> oldKeySet = oldAttributes.keySet();
        Set<String> newKeySet = newAttributes.keySet();
        HashSet<String> commonKeys = new HashSet<String>(newKeySet);
        commonKeys.retainAll(oldKeySet);
        HashSet<String> addedKeys = new HashSet<String>(newKeySet);
        addedKeys.removeAll(oldKeySet);
        HashSet<String> removedKeys = new HashSet<String>(oldKeySet);
        removedKeys.removeAll(newKeySet);
        for (String key : commonKeys) {
            if (oldAttributes.get(key).equals(newAttributes.get(key))) continue;
            delta.put(key, newAttributes.get(key));
        }
        for (String key : addedKeys) {
            delta.put(key, newAttributes.get(key));
        }
        for (String key : removedKeys) {
            delta.put(key, null);
        }
        return this.convertBreakpoint(delta);
    }

    private Map<String, Object> convertBreakpoint(Map<String, Object> delta) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String key : delta.keySet()) {
            if (key.equals(ATTR_DEBUGGER_PATH)) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", delta.get(ATTR_DEBUGGER_PATH));
                continue;
            }
            if (key.equals("lineNumber")) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", delta.get("lineNumber"));
                continue;
            }
            if (key.equals("org.eclipse.cdt.debug.core.function")) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.function", delta.get("org.eclipse.cdt.debug.core.function"));
                continue;
            }
            if (key.equals("org.eclipse.cdt.debug.core.address")) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.address", delta.get("org.eclipse.cdt.debug.core.address"));
                continue;
            }
            if (key.equals("org.eclipse.cdt.debug.core.threadId")) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.mi.threadId", delta.get("org.eclipse.cdt.debug.core.threadId"));
                continue;
            }
            if (key.equals("org.eclipse.cdt.debug.core.condition")) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.condition", delta.get("org.eclipse.cdt.debug.core.condition"));
                continue;
            }
            if (key.equals("org.eclipse.cdt.debug.core.ignoreCount")) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", delta.get("org.eclipse.cdt.debug.core.ignoreCount"));
                continue;
            }
            if (key.equals("org.eclipse.debug.core.enabled")) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", delta.get("org.eclipse.debug.core.enabled"));
                continue;
            }
            if (key.equals("org.eclipse.cdt.debug.core.expression")) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.expression", delta.get("org.eclipse.cdt.debug.core.expression"));
                continue;
            }
            if (key.equals("org.eclipse.cdt.debug.core.read")) {
                results.put("org.eclipse.dd.dsf.debug.breakpoint.read", delta.get("org.eclipse.cdt.debug.core.read"));
                continue;
            }
            if (!key.equals("org.eclipse.cdt.debug.core.write")) continue;
            results.put("org.eclipse.dd.dsf.debug.breakpoint.write", delta.get("org.eclipse.cdt.debug.core.write"));
        }
        return results;
    }

    private boolean needsResinstallation(Map<String, Object> delta) {
        if (delta == null) {
            return false;
        }
        return delta.containsKey(ATTR_DEBUGGER_PATH) || delta.containsKey("lineNumber") || delta.containsKey("org.eclipse.cdt.debug.core.function") || delta.containsKey("org.eclipse.cdt.debug.core.address") || delta.containsKey("org.eclipse.cdt.debug.core.threadId") || delta.containsKey("org.eclipse.cdt.debug.core.expression") || delta.containsKey("org.eclipse.cdt.debug.core.read") || delta.containsKey("org.eclipse.cdt.debug.core.write");
    }

    @ThreadSafe
    public void breakpointAdded(final IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    IPath location;
                    IResource resource;
                    final Map attrs = breakpoint.getMarker().getAttributes();
                    IMarker marker = breakpoint.getMarker();
                    if (marker != null && (resource = marker.getResource()) != null && (location = resource.getLocation()) != null) {
                        attrs.put(ATTR_HOST_PATH, location.toString());
                    }
                    this.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null){

                                protected void handleError() {
                                    if (this.getStatus().getSeverity() == 4) {
                                        DsfMIPlugin.getDefault().getLog().log(this.getStatus());
                                    }
                                }
                            };
                            countingRm.setDoneCount(MIBreakpointsManager.this.fPlatformBPs.size());
                            for (final IBreakpoints.IBreakpointsTargetDMContext dmc : MIBreakpointsManager.this.fPlatformBPs.keySet()) {
                                MIBreakpointsManager.this.calcDebuggerPath(dmc, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm){

                                    protected void handleOK() {
                                        MIBreakpointsManager.this.installBreakpoint(dmc, (ICBreakpoint)breakpoint, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm));
                                    }
                                });
                            }
                        }
                    });
                }
            }
            catch (CoreException e) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @ThreadSafe
    public void breakpointRemoved(final IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null){

                            protected void handleError() {
                                if (this.getStatus().getSeverity() == 4) {
                                    DsfMIPlugin.getDefault().getLog().log(this.getStatus());
                                }
                            }
                        };
                        countingRm.setDoneCount(MIBreakpointsManager.this.fPlatformBPs.size());
                        for (IBreakpoints.IBreakpointsTargetDMContext dmc : MIBreakpointsManager.this.fPlatformBPs.keySet()) {
                            if (((Map)MIBreakpointsManager.this.fPlatformBPs.get(dmc)).remove(breakpoint) == null) continue;
                            MIBreakpointsManager.this.uninstallBreakpoint(dmc, (ICBreakpoint)breakpoint, (RequestMonitor)countingRm);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @ThreadSafe
    public void breakpointChanged(final IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                IPath location;
                IResource resource;
                final Map attrs = breakpoint.getMarker().getAttributes();
                IMarker marker = breakpoint.getMarker();
                if (marker != null && (resource = marker.getResource()) != null && (location = resource.getLocation()) != null) {
                    attrs.put(ATTR_HOST_PATH, location.toString());
                }
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null){

                            protected void handleError() {
                                if (this.getStatus().getSeverity() == 4) {
                                    DsfMIPlugin.getDefault().getLog().log(this.getStatus());
                                }
                            }
                        };
                        for (final IBreakpoints.IBreakpointsTargetDMContext dmc : MIBreakpointsManager.this.fPlatformBPs.keySet()) {
                            MIBreakpointsManager.this.calcDebuggerPath(dmc, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm){

                                protected void handleOK() {
                                    MIBreakpointsManager.this.modifyBreakpoint(dmc, (ICBreakpoint)breakpoint, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm));
                                }
                            });
                        }
                        countingRm.setDoneCount(MIBreakpointsManager.this.fPlatformBPs.size());
                    }
                });
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                    }
                });
            }
            catch (CoreException e) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(DsfMIGDBExitEvent e) {
        this.terminated();
    }

    private void terminated() {
        this.clearBreakpointStatus(this.fPlatformBPs.keySet().toArray(new ICBreakpoint[this.fPlatformBPs.size()]));
        this.fPlatformBPs.clear();
    }

    private void updateBreakpointStatus(final ICBreakpoint bp, final boolean set) {
        new Job("Update Breakpoint Status"){

            protected IStatus run(IProgressMonitor monitor) {
                final IMarker marker = bp.getMarker();
                if (marker == null) {
                    return new Status(2, "org.eclipse.dsdp.debug.gdb.core", 1, "No marker associated with breakpoint.", null);
                }
                IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor2) throws CoreException {
                        if (marker == null) {
                            throw new DebugException((IStatus)new Status(2, "org.eclipse.dsdp.debug.gdb.core", 10004, "No marker associated with breakpoint.", null));
                        }
                        int count = marker.getAttribute("org.eclipse.cdt.debug.core.installCount", 0);
                        marker.setAttribute("org.eclipse.cdt.debug.core.installCount", set ? ++count : --count);
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(wr, ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(marker.getResource()), 0, null);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return new Status(0, "org.eclipse.dsdp.debug.gdb.core", 1, "", null);
            }
        }.schedule();
    }

    private void clearBreakpointStatus(final ICBreakpoint[] bps) {
        new Job("Clear Breakpoints Status"){

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        for (ICBreakpoint bp : bps) {
                            IMarker marker = bp.getMarker();
                            if (marker == null) continue;
                            int count = marker.getAttribute("org.eclipse.cdt.debug.core.installCount", 0);
                            marker.setAttribute("org.eclipse.cdt.debug.core.installCount", --count);
                        }
                    }
                };
                ISchedulingRule rule = null;
                ArrayList<ISchedulingRule> markerRules = new ArrayList<ISchedulingRule>();
                for (ICBreakpoint bp : bps) {
                    IMarker marker = bp.getMarker();
                    if (marker == null) continue;
                    ISchedulingRule markerRule = ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(marker.getResource());
                    if (markerRule == null) {
                        markerRules = null;
                        break;
                    }
                    markerRules.add(markerRule);
                }
                if (markerRules != null) {
                    rule = MultiRule.combine((ISchedulingRule[])markerRules.toArray(new ISchedulingRule[markerRules.size()]));
                }
                try {
                    ResourcesPlugin.getWorkspace().run(wr, rule, 0, null);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private boolean supportsBreakpoint(IBreakpoint bp) {
        IMarker marker;
        return bp instanceof ICBreakpoint && bp.getModelIdentifier().equals(this.fDebugModelId) && (marker = bp.getMarker()) != null;
    }

    private void calcDebuggerPath(IBreakpoints.IBreakpointsTargetDMContext dmc, final Map<String, Object> attributes, final RequestMonitor rm) {
        String hostPath = (String)attributes.get(ATTR_HOST_PATH);
        if (hostPath != null) {
            ISourceLookup.ISourceLookupDMContext srcDmc = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ISourceLookup.ISourceLookupDMContext.class);
            if (srcDmc != null) {
                this.fSourceLookup.getDebuggerPath(srcDmc, (Object)hostPath, (DataRequestMonitor)new DataRequestMonitor<String>((Executor)this.getExecutor(), rm){

                    protected void handleOK() {
                        attributes.put(MIBreakpointsManager.ATTR_DEBUGGER_PATH, this.getData());
                        rm.done();
                    }
                });
            } else {
                attributes.put(ATTR_DEBUGGER_PATH, hostPath);
                rm.done();
            }
        } else {
            rm.done();
        }
    }
}

