/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetChildCount;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetChildren;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetValue;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetVar;
import org.eclipse.dd.dsf.mi.core.command.DsfMIDataEvaluateExpression;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarAssign;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarCreate;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarDelete;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarEvaluateExpression;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarInfoPathExpression;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarListChildren;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarSetFormat;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarUpdate;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetChildCountInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetChildrenInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetValueInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetVarInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVar;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarChange;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarCreateInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarEvaluateExpressionInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarInfoPathExpressionInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarListChildrenInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarUpdateInfo;
import org.eclipse.dd.dsf.mi.service.ExpressionService;
import org.eclipse.dd.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.dsf.mi.service.control.AbstractMIControl;
import org.eclipse.dd.dsf.mi.service.control.MIControlDMContext;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIVariableManager
extends AbstractDsfService
implements ICommandControl {
    private final ICommandControl fCommandControl;
    private final IStack fStackService;
    private IExpressions fExpressionService;
    private final MIControlDMContext fControlDmc;
    private final List<ICommandListener> fCommandProcessors = new ArrayList<ICommandListener>();
    Map<VariableObjectId, MIVariableObject> lruVariableList = new LRUVariableCache();

    public MIVariableManager(DsfSession session, DsfServicesTracker tracker) {
        super(session);
        this.fCommandControl = (ICommandControl)tracker.getService(ICommandControl.class);
        this.fStackService = (IStack)tracker.getService(IStack.class);
        this.fExpressionService = (IExpressions)tracker.getService(IExpressions.class);
        this.fControlDmc = ((AbstractMIControl)this.fCommandControl).getControlDMContext();
    }

    private void getVariable(IExpressions.IExpressionDMContext exprCtx, DataRequestMonitor<MIVariableObject> rm) {
        final VariableObjectId id = new VariableObjectId();
        id.generateId(exprCtx, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, exprCtx){
            final /* synthetic */ DataRequestMonitor val$rm;
            final /* synthetic */ IExpressions.IExpressionDMContext val$exprCtx;
            {
                this.val$rm = dataRequestMonitor;
                this.val$exprCtx = iExpressionDMContext;
                super(x0, x1);
            }

            protected void handleOK() {
                final MIVariableObject varObj = MIVariableManager.this.lruVariableList.get(id);
                if (varObj != null) {
                    varObj.addFailedCreationListener((DataRequestMonitor<MIVariableObject>)this.val$rm);
                    varObj.executeWhenReady(new Runnable(){

                        public void run() {
                            if (varObj != MIVariableManager.this.lruVariableList.get(id)) {
                                MIVariableManager.this.getVariable(val$exprCtx, (DataRequestMonitor<MIVariableObject>)val$rm);
                                return;
                            }
                            varObj.lock();
                            MIVariableManager.this.fCommandControl.queueCommand((ICommand)new DsfMIVarUpdate(MIVariableManager.this.fControlDmc, varObj.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarUpdateInfo>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)val$rm){

                                protected void handleCompleted() {
                                    if (this.getStatus().isOK()) {
                                        DsfMIVarChange[] changes = ((DsfMIVarUpdateInfo)this.getData()).getMIVarChanges();
                                        if (changes.length == 0 || changes[0].isInScope()) {
                                            val$rm.setData((Object)varObj);
                                            val$rm.done();
                                            varObj.unlock();
                                        } else {
                                            VariableObjectId newId = new VariableObjectId();
                                            newId.generateId("OOS-" + varObj.getGdbName(), varObj.getInternalId());
                                            MIVariableManager.this.lruVariableList.put(newId, varObj);
                                            ((LRUVariableCache)MIVariableManager.this.lruVariableList).removeOnlyFromList(id);
                                            varObj.unlock();
                                            MIVariableManager.this.getVariable(val$exprCtx, (DataRequestMonitor<MIVariableObject>)val$rm);
                                        }
                                    } else {
                                        val$rm.setStatus(this.getStatus());
                                        val$rm.done();
                                        varObj.unlock();
                                    }
                                }
                            });
                        }
                    });
                    return;
                }
                final MIVariableObject newVarObj = new MIVariableObject(id, null);
                MIVariableManager.this.lruVariableList.put(id, newVarObj);
                MIVariableManager.this.fCommandControl.queueCommand((ICommand)new DsfMIVarCreate(this.val$exprCtx, this.val$exprCtx.getExpression()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarCreateInfo>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)this.val$rm){

                    protected void handleCompleted() {
                        if (this.getStatus().isOK()) {
                            newVarObj.setGdbName(((DsfMIVarCreateInfo)this.getData()).getName());
                            newVarObj.setExpressionData(val$exprCtx.getExpression(), ((DsfMIVarCreateInfo)this.getData()).getType(), ((DsfMIVarCreateInfo)this.getData()).getNumChildren());
                            val$rm.setData((Object)newVarObj);
                            val$rm.done();
                            newVarObj.creationCompleted(true);
                        } else {
                            MIVariableManager.this.lruVariableList.remove(id);
                            val$rm.setStatus(this.getStatus());
                            val$rm.done();
                            newVarObj.creationCompleted(false);
                        }
                    }
                });
            }
        });
    }

    private void getValue(final IFormattedValues.FormattedValueDMContext dmc, final MIVariableObject varObj, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        if (varObj.isComplex()) {
            if (varObj.isArray()) {
                IExpressions.IExpressionDMContext exprCxt = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IExpressions.IExpressionDMContext.class);
                IExpressions.IExpressionDMContext addrCxt = this.fExpressionService.createExpression((IDMContext)exprCxt, "&(" + exprCxt.getExpression() + ")");
                final IFormattedValues.FormattedValueDMContext formatCxt = new IFormattedValues.FormattedValueDMContext(this.fExpressionService.getSession().getId(), (IDMContext)addrCxt, dmc.getFormatID());
                this.getVariable(addrCxt, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), rm){

                    protected void handleOK() {
                        MIVariableManager.this.getValue(formatCxt, (MIVariableObject)this.getData(), (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)rm);
                    }
                });
            } else {
                rm.setData((Object)new IFormattedValues.FormattedValueDMData("{...}"));
                rm.done();
            }
            return;
        }
        varObj.executeWhenReady(new Runnable(){

            public void run() {
                varObj.lock();
                if (dmc.getFormatID().equals(varObj.getFormat())) {
                    if (varObj.getValue() != null) {
                        // empty if block
                    }
                    MIVariableManager.this.evaluate(varObj, (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)rm);
                } else {
                    MIVariableManager.this.fCommandControl.queueCommand((ICommand)new DsfMIVarSetFormat(MIVariableManager.this.fControlDmc, varObj.getGdbName(), dmc.getFormatID()), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleCompleted() {
                            if (this.getStatus().isOK()) {
                                varObj.setFormat(dmc.getFormatID());
                                MIVariableManager.this.evaluate(varObj, (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)rm);
                            } else {
                                varObj.unlock();
                                this.handleErrorOrCancel();
                            }
                        }
                    });
                }
            }
        });
    }

    private void getChildren(final MIVariableObject varObj, final ExpressionService.MIExpressionDMC exprDmc, final DataRequestMonitor<ExpressionService.ExpressionInfo[]> rm) {
        ExpressionService.ExpressionInfo[] childrenArray = varObj.getChildren();
        if (childrenArray != null) {
            rm.setData((Object)childrenArray);
            rm.done();
            return;
        }
        if (varObj.getNumChildren() == 0) {
            varObj.setChildren(new ExpressionService.ExpressionInfo[0]);
            rm.setData((Object)varObj.getChildren());
            rm.done();
            return;
        }
        if (varObj.isArray()) {
            ExpressionService.ExpressionInfo[] childrenOfArray = new ExpressionService.ExpressionInfo[varObj.getNumChildren()];
            for (int i = 0; i < childrenOfArray.length; ++i) {
                String indexStr = "[" + i + "]";
                String fullExpr = exprDmc.getExpression() + indexStr;
                String relExpr = exprDmc.getRelativeExpression() + indexStr;
                childrenOfArray[i] = new ExpressionService.ExpressionInfo(fullExpr, relExpr);
            }
            varObj.setChildren(childrenOfArray);
            rm.setData((Object)varObj.getChildren());
            rm.done();
            return;
        }
        this.fCommandControl.queueCommand((ICommand)new DsfMIVarListChildren(this.fControlDmc, varObj.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarListChildrenInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                DsfMIVar[] children = ((DsfMIVarListChildrenInfo)this.getData()).getMIVars();
                final ArrayList realChildren = new ArrayList();
                final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleOK() {
                        varObj.setChildren(realChildren.toArray(new ExpressionService.ExpressionInfo[realChildren.size()]));
                        rm.setData((Object)varObj.getChildren());
                        rm.done();
                    }
                };
                int numSubRequests = 0;
                for (final DsfMIVar child : children) {
                    ++numSubRequests;
                    MIVariableManager.this.fCommandControl.queueCommand((ICommand)new DsfMIVarInfoPathExpression(MIVariableManager.this.fControlDmc, child.getVarName()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarInfoPathExpressionInfo>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)countingRm){

                        protected void handleOK() {
                            String childFullExpression = ((DsfMIVarInfoPathExpressionInfo)this.getData()).getFullExpression();
                            boolean fakeChild = false;
                            if (childFullExpression.length() == 0) {
                                fakeChild = true;
                                childFullExpression = child.getVarName();
                            }
                            VariableObjectId childId = new VariableObjectId();
                            childId.generateId(childFullExpression, varObj.getInternalId());
                            MIVariableObject childVar = MIVariableManager.this.lruVariableList.get(childId);
                            if (childVar == null) {
                                childVar = new MIVariableObject(childId, varObj);
                                childVar.setGdbName(child.getVarName());
                                childVar.setExpressionData(childFullExpression, child.getType(), child.getNumChild());
                                childVar.creationCompleted(true);
                                MIVariableManager.this.lruVariableList.put(childId, childVar);
                            }
                            if (fakeChild) {
                                MIVariableManager.this.getChildren(childVar, exprDmc, (DataRequestMonitor<ExpressionService.ExpressionInfo[]>)((DataRequestMonitor)new DataRequestMonitor<ExpressionService.ExpressionInfo[]>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)countingRm){

                                    protected void handleOK() {
                                        ExpressionService.ExpressionInfo[] vars;
                                        for (ExpressionService.ExpressionInfo realChild : vars = (ExpressionService.ExpressionInfo[])this.getData()) {
                                            realChildren.add(realChild);
                                        }
                                        countingRm.done();
                                    }
                                }));
                            } else {
                                realChildren.add(new ExpressionService.ExpressionInfo(childFullExpression, child.getExp()));
                                countingRm.done();
                            }
                        }
                    });
                }
                countingRm.setDoneCount(numSubRequests);
            }
        });
    }

    private void getChildrenCount(MIVariableObject varObj, DataRequestMonitor<Integer> rm) {
        rm.setData((Object)varObj.getNumChildren());
        rm.done();
    }

    public void writeValue(IExpressions.IExpressionDMContext ctx, final String expressionValue, final String formatId, final RequestMonitor rm) {
        this.getVariable(ctx, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIVariableManager.this.writeValue((MIVariableObject)this.getData(), expressionValue, formatId, rm);
            }
        });
    }

    private void writeValue(final MIVariableObject varObj, String value, String formatId, final RequestMonitor rm) {
        if (varObj.isComplex()) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Cannot change the value of a complex expression", null));
            rm.done();
            return;
        }
        if (formatId.equals("HEX.Format")) {
            if (!value.startsWith("0x")) {
                value = "0x" + value;
            }
        } else if (formatId.equals("OCTAL.Format")) {
            if (!value.startsWith("0")) {
                value = "0" + value;
            }
        } else if (formatId.equals("BINARY.Format")) {
            if (value.startsWith("0b")) {
                value = value.substring(2, value.length());
            }
            try {
                value = Integer.toString(Integer.parseInt(value, 2));
            }
            catch (NumberFormatException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid binary number: " + value, (Throwable)e));
                rm.done();
                return;
            }
        } else if (!formatId.equals("DECIMAL.Format") && !formatId.equals("NATURAL.Format")) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown format: " + formatId, null));
            rm.done();
            return;
        }
        final String finalVal = value;
        varObj.executeWhenReady(new Runnable(){

            public void run() {
                MIVariableManager.this.fCommandControl.queueCommand((ICommand)new DsfMIVarAssign(MIVariableManager.this.fControlDmc, varObj.getGdbName(), finalVal), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)MIVariableManager.this.getExecutor(), rm){

                    protected void handleOK() {
                        rm.setStatus(this.getStatus());
                        rm.done();
                    }
                });
            }
        });
    }

    private void deleteVariable(MIVariableObject varObj) {
        if (varObj.getParent() != null) {
            return;
        }
        if (varObj.getGdbName() != null) {
            this.fCommandControl.queueCommand((ICommand)new DsfMIVarDelete(this.fControlDmc, varObj.getGdbName()), new DataRequestMonitor((Executor)this.getExecutor(), null));
        }
    }

    private void evaluate(final MIVariableObject varObj, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        this.fCommandControl.queueCommand((ICommand)new DsfMIVarEvaluateExpression(this.fControlDmc, varObj.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarEvaluateExpressionInfo>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (this.getStatus().isOK()) {
                    varObj.setValue(((DsfMIVarEvaluateExpressionInfo)this.getData()).getValue());
                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(((DsfMIVarEvaluateExpressionInfo)this.getData()).getValue()));
                }
                rm.done();
                varObj.unlock();
            }
        });
    }

    public <V extends ICommandResult> void queueCommand(ICommand<V> command, DataRequestMonitor<V> rm) {
        this.processCommandSent(command);
        if (command instanceof DsfExprMetaGetVar) {
            final DataRequestMonitor<V> drm = rm;
            final ExpressionService.MIExpressionDMC exprCtx = (ExpressionService.MIExpressionDMC)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), drm){

                protected void handleOK() {
                    drm.setData((Object)new DsfExprMetaGetVarInfo(exprCtx.getRelativeExpression(), ((MIVariableObject)this.getData()).getNumChildren(), ((MIVariableObject)this.getData()).getType()));
                    drm.done();
                }
            });
        } else if (command instanceof DsfExprMetaGetValue) {
            final DataRequestMonitor<V> drm = rm;
            final IFormattedValues.FormattedValueDMContext valueCtx = (IFormattedValues.FormattedValueDMContext)command.getContext();
            IExpressions.IExpressionDMContext exprCtx = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)valueCtx, IExpressions.IExpressionDMContext.class);
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), drm){

                protected void handleOK() {
                    MIVariableManager.this.getValue(valueCtx, (MIVariableObject)this.getData(), (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)((DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)drm){

                        protected void handleOK() {
                            drm.setData((Object)new DsfExprMetaGetValueInfo(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue()));
                            drm.done();
                        }
                    }));
                }
            });
        } else if (command instanceof DsfExprMetaGetChildren) {
            final DataRequestMonitor<V> drm = rm;
            final ExpressionService.MIExpressionDMC exprCtx = (ExpressionService.MIExpressionDMC)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), drm){

                protected void handleOK() {
                    MIVariableManager.this.getChildren((MIVariableObject)this.getData(), exprCtx, (DataRequestMonitor<ExpressionService.ExpressionInfo[]>)((DataRequestMonitor)new DataRequestMonitor<ExpressionService.ExpressionInfo[]>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)drm){

                        protected void handleOK() {
                            drm.setData((Object)new DsfExprMetaGetChildrenInfo((ExpressionService.ExpressionInfo[])this.getData()));
                            drm.done();
                        }
                    }));
                }
            });
        } else if (command instanceof DsfExprMetaGetChildCount) {
            final DataRequestMonitor<V> drm = rm;
            IExpressions.IExpressionDMContext exprCtx = (IExpressions.IExpressionDMContext)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), drm){

                protected void handleOK() {
                    MIVariableManager.this.getChildrenCount((MIVariableObject)this.getData(), (DataRequestMonitor<Integer>)((DataRequestMonitor)new DataRequestMonitor<Integer>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)drm){

                        protected void handleOK() {
                            drm.setData((Object)new DsfExprMetaGetChildCountInfo((Integer)this.getData()));
                            drm.done();
                        }
                    }));
                }
            });
        } else if (command instanceof DsfMIDataEvaluateExpression) {
            this.fCommandControl.queueCommand(command, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Unexpected Expression Meta command", null));
            rm.done();
        }
    }

    public void removeCommand(ICommand<? extends ICommandResult> command) {
        assert (false);
    }

    public void cancelCommand(ICommand<? extends ICommandResult> command) {
    }

    public void addCommandListener(ICommandListener processor) {
        this.fCommandProcessors.add(processor);
    }

    public void removeCommandListener(ICommandListener processor) {
        this.fCommandProcessors.remove(processor);
    }

    public void addEventListener(IEventListener processor) {
    }

    public void removeEventListener(IEventListener processor) {
    }

    private void processCommandSent(ICommand<?> command) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandSent(command);
        }
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LRUVariableCache
    extends LinkedHashMap<VariableObjectId, MIVariableObject> {
        public static final long serialVersionUID = 0L;
        private static final int MAX_VARIABLE_LIST = 1000;

        public LRUVariableCache() {
            super(0, 0.75f, true);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<VariableObjectId, MIVariableObject> eldest) {
            return false;
        }

        @Override
        public MIVariableObject get(Object key) {
            Map.Entry eldest;
            MIVariableObject retVal = (MIVariableObject)super.get(key);
            this.touchAncestors(retVal);
            if (this.size() > 1000 && !((MIVariableObject)(eldest = this.entrySet().iterator().next()).getValue()).equals(retVal) && ((MIVariableObject)eldest.getValue()).currentState == MIVariableObject.VarState.READY) {
                this.remove(eldest.getKey());
            }
            return retVal;
        }

        private void touchAncestors(MIVariableObject varObj) {
            while (varObj != null) {
                if ((varObj = varObj.getParent()) == null) continue;
                super.get(varObj.getInternalId());
            }
        }

        @Override
        public MIVariableObject put(VariableObjectId key, MIVariableObject value) {
            MIVariableObject retVal = super.put(key, value);
            this.touchAncestors(value);
            return retVal;
        }

        @Override
        public MIVariableObject remove(Object key) {
            MIVariableObject varObj = (MIVariableObject)super.remove(key);
            MIVariableManager.this.deleteVariable(varObj);
            return varObj;
        }

        public void removeOnlyFromList(Object key) {
            super.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MIVariableObject {
        private final VariableObjectId internalId;
        private String gdbName = null;
        private String format = "NATURAL.Format";
        private String fullExp = null;
        private String type = null;
        private int numChildren = 0;
        private String value = null;
        private Language lang = null;
        private VarState currentState = VarState.CREATING;
        private List<Runnable> runQueue = new ArrayList<Runnable>();
        private List<DataRequestMonitor<MIVariableObject>> requestsPendingCreation = new ArrayList<DataRequestMonitor<MIVariableObject>>();
        private ExpressionService.ExpressionInfo[] children = null;
        private MIVariableObject parent = null;

        public MIVariableObject(VariableObjectId id, MIVariableObject parentObj) {
            this.internalId = id;
            this.parent = parentObj;
        }

        public VariableObjectId getInternalId() {
            return this.internalId;
        }

        public String getGdbName() {
            return this.gdbName;
        }

        public String getFormat() {
            return this.format;
        }

        public MIVariableObject getParent() {
            return this.parent;
        }

        public MIVariableObject getTopAncestor() {
            if (this.getParent() == null) {
                return this;
            }
            return this.getParent().getTopAncestor();
        }

        public String getExpression() {
            return this.fullExp;
        }

        public String getType() {
            return this.type;
        }

        public int getNumChildren() {
            return this.numChildren;
        }

        public String getValue() {
            return this.value;
        }

        public Language getLanguage() {
            return this.lang;
        }

        public ExpressionService.ExpressionInfo[] getChildren() {
            return this.children;
        }

        public boolean isArray() {
            return this.getType() == null ? false : this.getType().endsWith("]") && !this.getType().contains("(*)");
        }

        public boolean isPointer() {
            return this.getType() == null ? false : this.getType().contains("*") && !this.isArray();
        }

        public boolean isMethod() {
            return this.getType() == null ? false : this.getType().contains("()");
        }

        public boolean isComplex() {
            return this.getType() == null ? false : this.getNumChildren() > 0 && !this.isPointer();
        }

        public void setGdbName(String n) {
            this.gdbName = n;
        }

        public void setFormat(String f) {
            this.format = f;
        }

        public void setExpressionData(String fullExpression, String t, int num) {
            this.fullExp = fullExpression;
            this.type = t;
            this.numChildren = num;
        }

        public void setValue(String val) {
            this.value = val;
        }

        public void setLanguage(String lStr) {
            Language l = Language.CPP;
            if (lStr.equals("C++")) {
                l = Language.CPP;
            } else if (lStr.equals("C")) {
                l = Language.C;
            } else if (lStr.equalsIgnoreCase("Java")) {
                l = Language.JAVA;
            }
            this.setLanguage(l);
        }

        public void setLanguage(Language l) {
            this.lang = l;
        }

        public void setChildren(ExpressionService.ExpressionInfo[] c) {
            this.children = c;
        }

        public void setParent(MIVariableObject p) {
            this.parent = p;
        }

        public void addFailedCreationListener(DataRequestMonitor<MIVariableObject> rm) {
            if (this.currentState == VarState.CREATING) {
                this.requestsPendingCreation.add(rm);
            }
        }

        public void creationCompleted(boolean success) {
            assert (this.currentState == VarState.CREATING);
            if (success) {
                this.currentState = VarState.READY;
                this.requestsPendingCreation.clear();
                while (this.runQueue.size() > 0 && this.currentState == VarState.READY) {
                    this.runQueue.remove(0).run();
                }
            } else {
                while (this.requestsPendingCreation.size() > 0) {
                    DataRequestMonitor<MIVariableObject> rm = this.requestsPendingCreation.remove(0);
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unable to create variable object", null));
                    rm.done();
                }
            }
        }

        public void executeWhenReady(Runnable runObj) {
            if (this.currentState == VarState.READY) {
                runObj.run();
            } else {
                this.runQueue.add(runObj);
            }
        }

        public void lock() {
            this.currentState = VarState.IN_USE;
        }

        public void unlock() {
            this.currentState = VarState.READY;
            while (this.runQueue.size() > 0 && this.currentState == VarState.READY) {
                this.runQueue.remove(0).run();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Language {
            C,
            CPP,
            JAVA;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum VarState {
            CREATING,
            READY,
            IN_USE;

        }
    }

    private class VariableObjectId {
        String fExpression = null;
        ThreadInfo fThreadInfo = null;
        FrameInfo fFrameInfo = null;

        private VariableObjectId() {
        }

        public boolean equals(Object other) {
            if (other instanceof VariableObjectId) {
                VariableObjectId otherId = (VariableObjectId)other;
                return (this.fExpression == null ? otherId.fExpression == null : this.fExpression.equals(otherId.fExpression)) && (this.fThreadInfo == null ? otherId.fThreadInfo == null : this.fThreadInfo.equals(otherId.fThreadInfo)) && (this.fFrameInfo == null ? otherId.fFrameInfo == null : this.fFrameInfo.equals(otherId.fFrameInfo));
            }
            return false;
        }

        public int hashCode() {
            return (this.fExpression == null ? 0 : this.fExpression.hashCode()) + (this.fThreadInfo == null ? 0 : this.fThreadInfo.hashCode()) + (this.fFrameInfo == null ? 0 : this.fFrameInfo.hashCode());
        }

        public void generateId(IExpressions.IExpressionDMContext exprCtx, final RequestMonitor rm) {
            this.fExpression = exprCtx.getExpression();
            IMIExecutionDMContext execCtx = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)exprCtx, IMIExecutionDMContext.class);
            if (execCtx == null) {
                rm.done();
                return;
            }
            this.fThreadInfo = new ThreadInfo(execCtx.getThreadId());
            final IStack.IFrameDMContext frameCtx = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)exprCtx, IStack.IFrameDMContext.class);
            if (frameCtx == null) {
                rm.done();
                return;
            }
            MIVariableManager.this.fStackService.getStackDepth((IDMContext)execCtx, 0, (DataRequestMonitor)new DataRequestMonitor<Integer>((Executor)MIVariableManager.this.getExecutor(), rm){

                public void handleOK() {
                    VariableObjectId.this.fFrameInfo = new FrameInfo((Integer)this.getData() - frameCtx.getLevel());
                    rm.done();
                }
            });
        }

        public void generateId(String childFullExp, VariableObjectId parentId) {
            this.fThreadInfo = parentId.fThreadInfo;
            this.fFrameInfo = parentId.fFrameInfo;
            this.fExpression = childFullExp;
        }

        private class FrameInfo {
            int fStackDepth = 0;

            public FrameInfo(int depth) {
                this.fStackDepth = depth;
            }

            public int getDepth() {
                return this.fStackDepth;
            }

            public boolean equals(Object other) {
                if (other instanceof FrameInfo) {
                    FrameInfo otherInfo = (FrameInfo)other;
                    return this.getDepth() == otherInfo.getDepth();
                }
                return false;
            }

            public int hashCode() {
                return this.fStackDepth;
            }
        }

        private class ThreadInfo {
            private int fThreadId = 0;

            public ThreadInfo(int thread) {
                this.fThreadId = thread;
            }

            public int getThreadId() {
                return this.fThreadId;
            }

            public boolean equals(Object other) {
                if (other instanceof ThreadInfo) {
                    return this.getThreadId() == ((ThreadInfo)other).getThreadId();
                }
                return false;
            }

            public int hashCode() {
                return this.fThreadId;
            }
        }
    }
}

