/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service.control;

import java.util.LinkedList;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecContinue;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecFinish;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecNext;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecNextInstruction;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecReturn;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecStep;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecStepInstruction;
import org.eclipse.dd.dsf.mi.core.command.DsfMIExecUntil;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMINotifyAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIStatusAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIBreakpointHitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIFunctionFinishedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorSignalExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMILocationReachedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIRunningEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISignalEvent;
import org.eclipse.dd.dsf.mi.event.DsfMISteppingRangeEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIWatchpointScopeEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIWatchpointTriggerEvent;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.mi.service.control.AbstractMIControl;
import org.eclipse.dd.dsf.service.DsfServicesTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIRunControlEventProcessor
implements IEventListener,
ICommandListener {
    private final AbstractMIControl fCommandControl;
    private final IRunControl.IContainerDMContext fContainerDmc;
    private final DsfServicesTracker fServicesTracker;

    public MIRunControlEventProcessor(AbstractMIControl connection, IRunControl.IContainerDMContext containerDmc) {
        this.fCommandControl = connection;
        this.fContainerDmc = containerDmc;
        this.fServicesTracker = new DsfServicesTracker(DsfMIPlugin.getBundleContext(), this.fCommandControl.getSession().getId());
        connection.addEventListener(this);
        connection.addCommandListener(this);
    }

    public void dispose() {
        this.fCommandControl.removeEventListener(this);
        this.fCommandControl.removeCommandListener(this);
        this.fServicesTracker.dispose();
    }

    public void eventReceived(Object output) {
        for (DsfMIOOBRecord oobr : ((DsfMIOutput)output).getMIOOBRecords()) {
            if (oobr instanceof DsfMIExecAsyncOutput) {
                DsfMIExecAsyncOutput exec = (DsfMIExecAsyncOutput)oobr;
                String state = exec.getAsyncClass();
                if (!"stopped".equals(state)) continue;
                this.fCommandControl.resetCurrentThreadLevel();
                LinkedList events = new LinkedList();
                DsfMIResult[] results = exec.getMIResults();
                for (int i = 0; i < results.length; ++i) {
                    String reason;
                    DsfMIEvent<?> e;
                    String string = results[i].getVariable();
                    DsfMIValue val = results[i].getMIValue();
                    if (!string.equals("reason") || !(val instanceof DsfMIConst) || (e = this.createEvent(reason = ((DsfMIConst)val).getString(), exec)) == null) continue;
                    events.add(e);
                }
                if (events.isEmpty()) {
                    DsfMIStoppedEvent e = DsfMIStoppedEvent.parse((MIRunControl)this.fServicesTracker.getService(MIRunControl.class), this.fContainerDmc, exec.getToken(), exec.getMIResults());
                    events.add(e);
                }
                for (DsfMIEvent dsfMIEvent : events) {
                    this.fCommandControl.getSession().dispatchEvent((Object)dsfMIEvent, this.fCommandControl.getProperties());
                }
                continue;
            }
            if (!(oobr instanceof DsfMIStatusAsyncOutput) && !(oobr instanceof DsfMINotifyAsyncOutput)) continue;
        }
    }

    protected DsfMIEvent<?> createEvent(String reason, DsfMIExecAsyncOutput exec) {
        MIRunControl runControl = (MIRunControl)this.fServicesTracker.getService(MIRunControl.class);
        DsfMIEvent event = null;
        if ("breakpoint-hit".equals(reason)) {
            event = DsfMIBreakpointHitEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-trigger".equals(reason) || "read-watchpoint-trigger".equals(reason) || "access-watchpoint-trigger".equals(reason)) {
            event = DsfMIWatchpointTriggerEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-scope".equals(reason)) {
            event = DsfMIWatchpointScopeEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("end-stepping-range".equals(reason)) {
            event = DsfMISteppingRangeEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("signal-received".equals(reason)) {
            event = DsfMISignalEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("location-reached".equals(reason)) {
            event = DsfMILocationReachedEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("function-finished".equals(reason)) {
            event = DsfMIFunctionFinishedEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("exited-normally".equals(reason) || "exited".equals(reason)) {
            event = DsfMIInferiorExitEvent.parse(this.fCommandControl.getControlDMContext(), exec.getToken(), exec.getMIResults());
        } else if ("exited-signalled".equals(reason)) {
            event = DsfMIInferiorSignalExitEvent.parse(this.fCommandControl.getControlDMContext(), exec.getToken(), exec.getMIResults());
        }
        return event;
    }

    public void commandQueued(ICommand<?> command) {
    }

    public void commandSent(ICommand<?> command) {
    }

    public void commandRemoved(ICommand<?> command) {
    }

    public void commandDone(ICommand<?> cmd, ICommandResult result) {
        DsfMIInfo cmdResult = (DsfMIInfo)result;
        DsfMIOutput output = cmdResult.getMIOutput();
        DsfMIResultRecord rr = output.getMIResultRecord();
        if (rr != null) {
            int id = rr.getToken();
            String state = rr.getResultClass();
            if ("running".equals(state)) {
                int type = 0;
                type = cmd instanceof DsfMIExecNext ? 1 : (cmd instanceof DsfMIExecNextInstruction ? 2 : (cmd instanceof DsfMIExecStep ? 3 : (cmd instanceof DsfMIExecStepInstruction ? 4 : (cmd instanceof DsfMIExecUntil ? 6 : (cmd instanceof DsfMIExecFinish ? 5 : (cmd instanceof DsfMIExecReturn ? 7 : (cmd instanceof DsfMIExecContinue ? 0 : 0)))))));
                this.fCommandControl.getSession().dispatchEvent((Object)new DsfMIRunningEvent((IRunControl.IExecutionDMContext)this.fContainerDmc, id, type), this.fCommandControl.getProperties());
            } else if ("exit".equals(state) || "connected".equals(state) || "error".equals(state)) {
                // empty if block
            }
        }
    }
}

