/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.INativeProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStepQueueManager;
import org.eclipse.dd.dsf.mi.ui.DsfMIUIPlugin;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.core.commands.IDebugCommandRequest;

@Immutable
public abstract class DsfCommandRunnable
extends DsfRunnable {
    private final IRunControl.IExecutionDMContext fContext;
    private final DsfServicesTracker fTracker;
    private final IDebugCommandRequest fRequest;

    public IRunControl.IExecutionDMContext getContext() {
        return this.fContext;
    }

    public IRunControl getRunControl() {
        return (IRunControl)this.fTracker.getService(IRunControl.class);
    }

    public IStepQueueManager getStepQueueMgr() {
        return (IStepQueueManager)this.fTracker.getService(IStepQueueManager.class);
    }

    public INativeProcesses getProcesses() {
        return (INativeProcesses)this.fTracker.getService(INativeProcesses.class);
    }

    public DsfCommandRunnable(DsfServicesTracker servicesTracker, Object element, IDebugCommandRequest request) {
        this.fTracker = servicesTracker;
        if (element instanceof AbstractDMVMLayoutNode.DMVMContext) {
            AbstractDMVMLayoutNode.DMVMContext vmc = (AbstractDMVMLayoutNode.DMVMContext)element;
            this.fContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMC(), IRunControl.IExecutionDMContext.class);
        } else {
            this.fContext = null;
        }
        this.fRequest = request;
    }

    public final void run() {
        if (this.fRequest.isCanceled()) {
            return;
        }
        if (this.getContext() == null) {
            this.fRequest.setStatus(this.makeError("Selected object does not support run control.", null));
        } else if (this.getRunControl() == null) {
            this.fRequest.setStatus(this.makeError("Run Control not available", null));
        } else {
            this.doExecute();
        }
        this.fRequest.done();
    }

    protected abstract void doExecute();

    protected IStatus makeError(String message, Throwable e) {
        return new Status(4, DsfMIUIPlugin.getId(), -1, message, e);
    }
}

