/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.ui.actions;

import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.mi.ui.DsfMIUIPlugin;
import org.eclipse.dd.dsf.mi.ui.actions.DsfCommandRunnable;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.IResumeHandler;

@Immutable
public class DsfResumeCommand
implements IResumeHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfResumeCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(DsfMIUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], (IDebugCommandRequest)request){

            public void doExecute() {
                request.setEnabled(this.getRunControl().canResume((IDMContext)this.getContext()));
            }
        }));
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            public void doExecute() {
                this.getRunControl().resume((IDMContext)this.getContext(), new RequestMonitor(DsfResumeCommand.this.fExecutor, null));
            }
        }));
        return false;
    }
}

