/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.ui.actions;

import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.INativeProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.mi.ui.DsfMIUIPlugin;
import org.eclipse.dd.dsf.mi.ui.actions.DsfCommandRunnable;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;

public class DsfTerminateCommand
implements ITerminateHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfTerminateCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(DsfMIUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1 || !(request.getElements()[0] instanceof AbstractDMVMLayoutNode.DMVMContext)) {
            request.setEnabled(false);
            request.done();
            return;
        }
        AbstractDMVMLayoutNode.DMVMContext vmc = (AbstractDMVMLayoutNode.DMVMContext)request.getElements()[0];
        final IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMC(), IRunControl.IExecutionDMContext.class);
        if (dmc == null) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                INativeProcesses processes = (INativeProcesses)DsfTerminateCommand.this.fTracker.getService(INativeProcesses.class);
                if (processes == null || dmc == null) {
                    request.done();
                } else {
                    processes.canTerminate(processes.getThreadForExecutionContext(dmc), (DataRequestMonitor)new DataRequestMonitor<Boolean>(DsfTerminateCommand.this.fExecutor, null){

                        public void handleCompleted() {
                            request.setEnabled(((Boolean)this.getData()).booleanValue());
                            request.done();
                        }
                    });
                }
            }
        });
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            public void doExecute() {
                this.getProcesses().terminate(this.getProcesses().getThreadForExecutionContext(this.getContext()), new RequestMonitor(DsfTerminateCommand.this.fExecutor, null));
            }
        }));
        return false;
    }
}

