/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.ui.model;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.ui.viewmodel.launch.StackFramesLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.launch.StandardLaunchRootLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.launch.StandardProcessLayoutNode;
import org.eclipse.dd.dsf.mi.ui.model.ThreadLayoutNode;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMRootLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMProvider;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class LaunchViewModelProvider
extends AbstractDMVMProvider
implements IDebugEventSetListener,
ILaunchesListener2 {
    @ThreadSafe
    public LaunchViewModelProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session, ILaunch launch) {
        super(adapter, presentationContext, session);
        StandardLaunchRootLayoutNode launchNode = new StandardLaunchRootLayoutNode((AbstractVMProvider)this, launch);
        ThreadLayoutNode threadsNode = new ThreadLayoutNode((AbstractVMProvider)this, this.getSession());
        StandardProcessLayoutNode processesNode = new StandardProcessLayoutNode((AbstractVMProvider)this);
        launchNode.setChildNodes(new IVMLayoutNode[]{threadsNode, processesNode});
        StackFramesLayoutNode stackFramesNode = new StackFramesLayoutNode((AbstractVMProvider)this, this.getSession());
        threadsNode.setChildNodes(new IVMLayoutNode[]{stackFramesNode});
        this.setRootLayoutNode((IVMRootLayoutNode)launchNode);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void handleDebugEvents(final DebugEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    if (LaunchViewModelProvider.this.isDisposed()) {
                        return;
                    }
                    for (final DebugEvent event : events) {
                        IVMRootLayoutNode rootLayoutNode = LaunchViewModelProvider.this.getRootLayoutNode();
                        if (rootLayoutNode == null || rootLayoutNode.getDeltaFlags((Object)event) == 0) continue;
                        rootLayoutNode.createDelta((Object)event, (DataRequestMonitor)new DataRequestMonitor<IModelDelta>(LaunchViewModelProvider.this.getExecutor(), null){

                            public void handleCompleted() {
                                if (this.getStatus().isOK()) {
                                    LaunchViewModelProvider.this.getModelProxy().fireModelChangedNonDispatch((IModelDelta)this.getData());
                                }
                            }

                            public String toString() {
                                return "Result of a delta for debug event: '" + event.toString() + "' in VMP: '" + (Object)((Object)LaunchViewModelProvider.this) + "'" + "\n" + this.getData();
                            }
                        });
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        super.dispose();
    }

    public void launchesAdded(ILaunch[] launches) {
        this.handleLaunchesEvent(new StandardLaunchRootLayoutNode.LaunchesEvent(launches, StandardLaunchRootLayoutNode.LaunchesEvent.Type.ADDED));
    }

    public void launchesRemoved(ILaunch[] launches) {
        this.handleLaunchesEvent(new StandardLaunchRootLayoutNode.LaunchesEvent(launches, StandardLaunchRootLayoutNode.LaunchesEvent.Type.REMOVED));
    }

    public void launchesChanged(ILaunch[] launches) {
        this.handleLaunchesEvent(new StandardLaunchRootLayoutNode.LaunchesEvent(launches, StandardLaunchRootLayoutNode.LaunchesEvent.Type.CHANGED));
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.handleLaunchesEvent(new StandardLaunchRootLayoutNode.LaunchesEvent(launches, StandardLaunchRootLayoutNode.LaunchesEvent.Type.TERMINATED));
    }

    private void handleLaunchesEvent(final StandardLaunchRootLayoutNode.LaunchesEvent event) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(new Runnable(){

                public void run() {
                    if (LaunchViewModelProvider.this.isDisposed()) {
                        return;
                    }
                    IVMRootLayoutNode rootLayoutNode = LaunchViewModelProvider.this.getRootLayoutNode();
                    if (rootLayoutNode != null && rootLayoutNode.getDeltaFlags((Object)event) != 0) {
                        rootLayoutNode.createDelta((Object)event, (DataRequestMonitor)new DataRequestMonitor<IModelDelta>(LaunchViewModelProvider.this.getExecutor(), null){

                            public void handleCompleted() {
                                if (this.getStatus().isOK()) {
                                    LaunchViewModelProvider.this.getModelProxy().fireModelChangedNonDispatch((IModelDelta)this.getData());
                                }
                            }

                            public String toString() {
                                return "Result of a delta for launch event: '" + event.toString() + "' in VMP: '" + (Object)((Object)LaunchViewModelProvider.this) + "'" + "\n" + this.getData();
                            }
                        });
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

