/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.VMViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMElementsUpdate
extends VMViewerUpdate
implements IChildrenUpdate {
    private final int fOffset;
    private final int fLength;
    private final List<Object> fElements;

    public VMElementsUpdate(IChildrenUpdate clientUpdate, int offset, int length, DataRequestMonitor<List<Object>> requestMonitor) {
        super((IViewerUpdate)clientUpdate, (RequestMonitor)requestMonitor);
        this.fOffset = offset;
        this.fLength = length;
        this.fElements = length > 0 ? new ArrayList<Object>(length) : new ArrayList();
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setChild(Object element, int offset) {
        int idx = offset - (this.fOffset > 0 ? this.fOffset : 0);
        if (idx < 0 || this.fLength > 0 && idx >= this.fLength) {
            return;
        }
        this.ensureElementsSize(idx + 1);
        this.fElements.set(idx, element);
    }

    private void ensureElementsSize(int size) {
        while (this.fElements.size() < size) {
            this.fElements.add(null);
        }
    }

    public String toString() {
        return "VMElementsUpdate for elements under parent = " + this.getElement() + ", in range " + this.getOffset() + " -> " + (this.getOffset() + this.getLength());
    }

    @Override
    public void done() {
        DataRequestMonitor rm = (DataRequestMonitor)this.fRequestMonitor;
        rm.setData(this.fElements);
        super.done();
    }
}

