/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

@ThreadSafe
public abstract class AbstractVMAdapter
implements IVMAdapter {
    private boolean fDisposed;
    private final Map<IPresentationContext, IVMProvider> fViewModelProviders = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public IVMProvider getVMProvider(IPresentationContext context) {
        Map<IPresentationContext, IVMProvider> map = this.fViewModelProviders;
        synchronized (map) {
            if (this.fDisposed) {
                return null;
            }
            IVMProvider provider = this.fViewModelProviders.get(context);
            if (provider == null && (provider = this.createViewModelProvider(context)) != null) {
                this.fViewModelProviders.put(context, provider);
            }
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IVMProvider[] providers = new IVMProvider[]{};
        Map<IPresentationContext, IVMProvider> map = this.fViewModelProviders;
        synchronized (map) {
            providers = this.fViewModelProviders.values().toArray(new IVMProvider[this.fViewModelProviders.size()]);
            this.fViewModelProviders.clear();
            this.fDisposed = true;
        }
        for (final IVMProvider provider : providers) {
            try {
                provider.getExecutor().execute(new Runnable(){

                    public void run() {
                        provider.dispose();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                // empty catch block
            }
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        IVMProvider provider = this.getVMProvider(updates[0].getPresentationContext());
        if (provider != null) {
            this.updateProvider(provider, (IViewerUpdate[])updates);
        } else {
            for (IHasChildrenUpdate update : updates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10005, "No model provider for update " + update, null));
            }
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IVMProvider provider = this.getVMProvider(updates[0].getPresentationContext());
        if (provider != null) {
            this.updateProvider(provider, (IViewerUpdate[])updates);
        } else {
            for (IChildrenCountUpdate update : updates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10005, "No model provider for update " + update, null));
            }
        }
    }

    public void update(IChildrenUpdate[] updates) {
        IVMProvider provider = this.getVMProvider(updates[0].getPresentationContext());
        if (provider != null) {
            this.updateProvider(provider, (IViewerUpdate[])updates);
        } else {
            for (IChildrenUpdate update : updates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10005, "No model provider for update " + update, null));
            }
        }
    }

    private void updateProvider(final IVMProvider provider, final IViewerUpdate[] updates) {
        try {
            provider.getExecutor().execute(new Runnable(){

                public void run() {
                    if (updates instanceof IHasChildrenUpdate[]) {
                        provider.update((IHasChildrenUpdate[])updates);
                    } else if (updates instanceof IChildrenCountUpdate[]) {
                        provider.update((IChildrenCountUpdate[])updates);
                    } else if (updates instanceof IChildrenUpdate[]) {
                        provider.update((IChildrenUpdate[])updates);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (IViewerUpdate update : updates) {
                update.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.ui", 10005, "Display is disposed, cannot complete update " + update, null));
                update.done();
            }
        }
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.createModelProxy(element, context);
        }
        return null;
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.createColumnPresentation(context, element);
        }
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        IVMProvider provider = this.getVMProvider(context);
        if (provider != null) {
            return provider.getColumnPresentationId(context, element);
        }
        return null;
    }

    public void update(IViewerInputUpdate update) {
        IVMProvider provider = this.getVMProvider(update.getPresentationContext());
        if (provider != null) {
            provider.update(update);
        }
    }

    @ThreadSafe
    protected abstract IVMProvider createViewModelProvider(IPresentationContext var1);
}

