/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.datamodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.IDMContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMContexts {
    @ThreadSafe
    public static <V extends IDMContext> V getAncestorOfType(IDMContext ctx, Class<V> ancestorType) {
        if (ancestorType.isAssignableFrom(ctx.getClass())) {
            return (V)ctx;
        }
        for (IDMContext<?> parent : ctx.getParents()) {
            if (!ancestorType.isAssignableFrom(parent.getClass())) continue;
            return (V)parent;
        }
        for (IDMContext<?> parent : ctx.getParents()) {
            V ancestor = DMContexts.getAncestorOfType(parent, ancestorType);
            if (ancestor == null) continue;
            return ancestor;
        }
        return null;
    }

    @ThreadSafe
    public static boolean isAncestorOf(IDMContext<?> dmc, IDMContext<?> potentialAncestor) {
        for (IDMContext<?> parentDmc : dmc.getParents()) {
            if (!potentialAncestor.equals(parentDmc)) continue;
            return true;
        }
        for (IDMContext<?> parentDmc : dmc.getParents()) {
            if (!DMContexts.isAncestorOf(parentDmc, potentialAncestor)) continue;
            return true;
        }
        return false;
    }

    @ThreadSafe
    public static List<IDMContext<?>> toList(IDMContext<?> dmc) {
        ArrayList list = new ArrayList();
        list.add(dmc);
        for (IDMContext<?> parentDmc : dmc.getParents()) {
            list.addAll(DMContexts.toList(parentDmc));
        }
        return list;
    }
}

