/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.actions;

import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.dd.gdb.service.command.GDBControl;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.ITerminateHandler;

public class DsfTerminateCommand
implements ITerminateHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfTerminateCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1 || !(request.getElements()[0] instanceof IDMVMContext)) {
            request.setEnabled(false);
            request.done();
            return;
        }
        IDMVMContext vmc = (IDMVMContext)request.getElements()[0];
        final IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)vmc.getDMContext(), IRunControl.IExecutionDMContext.class);
        if (dmc == null) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                GDBControl gdbControl = (GDBControl)DsfTerminateCommand.this.fTracker.getService(GDBControl.class);
                if (gdbControl == null || dmc == null) {
                    request.setEnabled(false);
                    request.done();
                } else {
                    request.setEnabled(!gdbControl.isGDBExited());
                    request.done();
                }
            }
        });
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        this.fExecutor.submit((Runnable)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            public void doExecute() {
                GDBControl gdbControl = (GDBControl)DsfTerminateCommand.this.fTracker.getService(GDBControl.class);
                if (gdbControl != null) {
                    gdbControl.terminate(new RequestMonitor((Executor)DsfTerminateCommand.this.fExecutor, null));
                }
            }
        });
        return false;
    }
}

